﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// 代理加盟类别的操作类
/// </summary>
namespace Agent
{
    public class RAgentType : IAgentType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region TSincereAgent 成员

        /// <summary>
        /// 添加代理加盟类别
        /// </summary>
        /// <param name="eui">代理加盟类别对象</param>
        /// <returns></returns>
        public int Insert(TAgentType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               
                   	new SqlParameter("@Name",eui.Name),
                    new SqlParameter("@ParentID", eui.ParentID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_AgentType_Add", commandParameters);
        }

        /// <summary>
        /// 修改代理加盟类别
        /// </summary>
        /// <param name="eui">代理加盟类别对象<</param>
        /// <returns></returns>
        public int Update(TAgentType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("ID",eui.ID),
                    new SqlParameter("@Name", eui.Name),
                    new SqlParameter("@Compositor",eui.Compositor)

             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_AgentType_Update", commandParameters);
        }

        /// <summary>
        /// 根据ID删除代理加盟类别
        /// </summary>
        /// <param name="ID">类别</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_AgentType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }

        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_AgentType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有代理加盟类别信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName","W_AgentType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }

        /// <summary>
        ///
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strSelect","ID,Name,ParentID,Compositor"),
                new SqlParameter("@strwhere", "where ParentID="+ParamID+" group by Compositor,ID,Name,ParentID"),
                new SqlParameter("@strtableName", "W_AgentType"), 
                new SqlParameter("@strOrder", "order by Compositor asc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        /// <summary>
        /// 根据ID字符串得到代理加盟类别信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetFullData(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strSelect", " Name,ID"), 
                new SqlParameter("@strwhere", "where patindex('%,'+rtrim( ID)+',%',','+(select FullID from W_Area where ID="+ ParamID+") +',')>0 or ID="+ParamID),
                new SqlParameter("@strtableName", "W_AgentType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        /// <summary>
        /// 更新排序字段
        /// </summary>
        /// <param name="paixu">排序字段id</param>
        /// <param name="lbid">栏目字段id</param>
        public void UpdateCompositor(int paixu,int lbid) 
        {
            string updataStr = "UPDATE  W_AgentType SET Compositor=@Compositor where ID=@lbid";
            SqlParameter[] parms ={ 
            new SqlParameter("@Compositor",paixu),
            new SqlParameter("@lbid",lbid)
            };
           SqlHelper.ExecuteNonQuery(CommandType.Text, updataStr, parms);
        }

        /// <summary>
        /// 根据ID得到代理加盟类别每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TAgentType GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_AgentType"), 
                new SqlParameter("@strOrder", "") 
            };
            TAgentType info = new TAgentType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                if (reader["ParentID"].ToString() != "")
                {
                    info.ParentID = int.Parse(reader["ParentID"].ToString());
                }
                info.FullID = reader["FullID"].ToString();
                if (reader["UnderlingFlag"].ToString() != "")
                {
                    info.UnderlingFlag = int.Parse(reader["UnderlingFlag"].ToString());
                }

            }
            return info;
        }
        #endregion

        /// <summary>
        /// 获得所有的一几级类目
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public DataTable GetAllParentItem()
        {
            SqlConnection con = new SqlConnection(ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT * FROM [W_AgentType] WHERE [ParentID]=0",con);
            SqlDataAdapter adp = new SqlDataAdapter(cmd);
            DataTable dt = new DataTable();
            using(con)
            {
                con.Open();
                adp.Fill(dt);
            }
            return dt;
        }

        /// <summary>
        /// 根据ParentID获得所有的子类目
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public DataTable GetAllSonItem(int ParentID)
        {
            SqlConnection con = new SqlConnection(ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT * FROM [W_AgentType] WHERE [ParentID]=@ParentID", con);
            cmd.Parameters.AddWithValue("@ParentID", ParentID);
            SqlDataAdapter adp = new SqlDataAdapter(cmd);
            DataTable dt = new DataTable();
            using (con)
            {
                con.Open();
                adp.Fill(dt);
            }
            return dt;
        }
        public string GetTypeName(int ID)
        {
            SqlConnection con = new SqlConnection(ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT * FROM [W_AgentType] WHERE [ID]=@ID", con);
            cmd.Parameters.AddWithValue("@ID", ID);
            using (con)
            {
                con.Open();
                SqlDataReader sr = cmd.ExecuteReader();
                if (sr.Read())
                {
                    return sr["Name"].ToString();
                }
            }
            return "";
        }
    }
}
