﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// 诚招代理的操作类
/// </summary>
namespace Agent
{
    public class RSincereAgent : ISincereAgent
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region TSincereAgent 成员
        /// <summary>
        /// 添加诚招代理加盟
        /// </summary>
        /// <param name="eui">诚招代理加盟对象</param>
        /// <returns></returns>
        public int Insert(TSincereAgent eui, out int intReturn)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                	new SqlParameter("@Return", DbType.Int32),
                   	new SqlParameter("@UserID", eui.UserID),
					new SqlParameter("@Name", eui.Name),
					new SqlParameter("@AgentType", eui.AgentType),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Validity", eui.Validity),
					new SqlParameter("@Brand", eui.Brand),
					new SqlParameter("@Investment", eui.Investment),
					new SqlParameter("@Amount", eui.Amount),
					new SqlParameter("@InitialFee", eui.InitialFee),
					new SqlParameter("@Require", eui.Require),
					new SqlParameter("@Cradle", eui.Cradle),
					new SqlParameter("@Payback", eui.Payback),
					new SqlParameter("@Period", eui.Period),
					new SqlParameter("@Concession", eui.Concession),
					new SqlParameter("@Contract", eui.Contract),
					new SqlParameter("@Count", eui.Count),
					new SqlParameter("@BusinessDate", eui.BusinessDate),
					new SqlParameter("@isMoreBrand", eui.isMoreBrand),
					new SqlParameter("@BusinessMode", eui.BusinessMode),
					new SqlParameter("@Developmental", eui.Developmental),
					new SqlParameter("@Detail", eui.Detail),
					new SqlParameter("@Picture", eui.Picture),
                    new SqlParameter("@Obligate", eui.Obligate)
               

             };
            intReturn = 0;
            //commandParameters[1].Direction = ParameterDirection.Output;
            int ReRows = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_SincereAgent_Add", commandParameters);
            if (ReRows >= 0)
                intReturn = (int)commandParameters[0].Value;
            return ReRows;
        }

        /// <summary>
        /// 修改诚招代理加盟
        /// </summary>
        /// <param name="eui">诚招代理加盟对象<</param>
        /// <returns></returns>
        public int Update(TSincereAgent eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("ID",eui.ID),
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@AgentType", eui.AgentType),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Validity", eui.Validity),
					new SqlParameter("@Brand", eui.Brand),
					new SqlParameter("@Investment", eui.Investment),
					new SqlParameter("@Amount", eui.Amount),
					new SqlParameter("@InitialFee", eui.InitialFee),
					new SqlParameter("@Require", eui.Require),
					new SqlParameter("@Cradle", eui.Cradle),
					new SqlParameter("@Payback", eui.Payback),
					new SqlParameter("@Period", eui.Period),
					new SqlParameter("@Concession", eui.Concession),
					new SqlParameter("@Contract", eui.Contract),
					new SqlParameter("@Count", eui.Count),
					new SqlParameter("@BusinessDate", eui.BusinessDate),
					new SqlParameter("@isMoreBrand", eui.isMoreBrand),
					new SqlParameter("@BusinessMode", eui.BusinessMode),
					new SqlParameter("@Developmental", eui.Developmental),
					new SqlParameter("@Detail", eui.Detail),
					new SqlParameter("@Picture", eui.Picture),
                    new SqlParameter("@Obligate", eui.Obligate)

             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_SincereAgent_Update", commandParameters);
        }

        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TSincereAgent eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_SincereAgent_UpdateVerify", commandParameters);
        }

        /// <summary>
        /// 修改推荐信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateRecommend(TSincereAgent eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Recommend", eui.Recommend)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_SincereAgent_UpdateRecommend", commandParameters);
        }

        /// <summary>
        /// 根据ID删除诚招代理加盟
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_SincereAgent") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据AgentType 行业类别删除诚招代理加盟
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where AgentType in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_SincereAgent") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }

        /// <summary>
        /// //根据标题名称和代理加盟所属类目取得诚招代理加盟信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","W_SincereAgent"), 
                new SqlParameter("@strOrder", " order by AddDate desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }

        /// <summary>
        /// 根据诚招代理加盟类型得到诚招代理加盟
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TSincereAgent us)
        {
            string str = "where 1=1";
            if (us.UserID != 0)
                str += " and UserID=" + us.UserID;
            if (us.Verify != 0)
            {
                if (us.Verify == 4)
                    str += " and (datediff(day,AddDate,getdate())>Validity)";
                else
                    str += " and Verify=" + us.Verify;
            }
            else
                str += " and Verify=" + 1;

            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "W_SincereAgent"), 
                new SqlParameter("@strOrder", " order by AddDate desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        /// <summary>
        /// 根据ID得到诚招代理加盟每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TSincereAgent GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_SincereAgent"), 
                new SqlParameter("@strOrder", "") 
            };
            TSincereAgent info = new TSincereAgent();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                if (reader["AgentType"].ToString() != "")
                {
                    info.AgentType = int.Parse(reader["AgentType"].ToString());
                }
                info.Title = (reader["Title"].ToString());
                info.Validity = reader["Validity"].ToString();
                info.Brand = reader["Brand"].ToString();
                info.Investment = reader["Investment"].ToString();

                if (reader["Amount"].ToString() != "")
                {
                    info.Amount = Convert.ToDecimal(reader["Amount"].ToString());
                }
                if (reader["InitialFee"].ToString() != "")
                {
                    info.InitialFee = Convert.ToDecimal(reader["InitialFee"].ToString());
                }
                info.Require = reader["Require"].ToString();
                info.Cradle = reader["Cradle"].ToString();
                if (reader["Payback"].ToString() != "")
                {
                    info.Payback = Convert.ToDecimal(reader["Payback"].ToString());
                }
                if (reader["Period"].ToString() != "")
                {
                    info.Period = Convert.ToDecimal(reader["Period"].ToString());
                }
                if (reader["Concession"].ToString() != "")
                {
                    info.Concession = Convert.ToDecimal(reader["Concession"].ToString());
                }
                if (reader["Contract"].ToString() != "")
                {
                    info.Contract = Convert.ToDecimal(reader["Contract"].ToString());
                }
                if (reader["Count"].ToString() != "")
                {
                    info.Count = Convert.ToInt32(reader["Count"].ToString());
                }
                if (reader["BusinessDate"].ToString() != "")
                {
                    info.BusinessDate = Convert.ToInt32(reader["BusinessDate"].ToString());
                }
                if (reader["isMoreBrand"].ToString() != "")
                {
                    info.isMoreBrand = Convert.ToBoolean(reader["isMoreBrand"].ToString());
                }
                info.BusinessMode = reader["BusinessMode"].ToString();
                info.Developmental = reader["Developmental"].ToString();
                info.Detail = reader["Detail"].ToString();
                info.Picture = (reader["Picture"].ToString());
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToInt32(reader["Verify"].ToString());
                }
                if (reader["Recommend"].ToString() != "")
                {
                    info.Recommend = Convert.ToBoolean(reader["Recommend"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                info.Obligate = reader["Obligate"].ToString();
            }
            return info;
        }

        /// <summary>
        /// 根据父级ID得到代理加盟子类别每一条信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetSonType(int ParentID)
        {
            DataTable dt = new DataTable();
            string Sql = "SELECT * FROM [W_AgentType] WHERE [ParentID]=" + ParentID;
            dt = SqlHelper.ExecuteSqlQuery(Sql);
            return dt;
        }

        /// <summary>
        /// 获得所有的招商信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllInfo()
        {
            string Sql = "SELECT * FROM [W_SincereAgent]";
            DataTable dt=new DataTable();
            dt = SqlHelper.ExecuteSqlQuery(Sql);
            return dt;
        }
        #endregion
    }
}
