﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// 愿做代理的操作类
/// </summary>
namespace Agent
{
    public class RWillAgent : IWillAgent
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IWillAgent 成员
        /// <summary>
        /// 添加愿做代理加盟信息
        /// </summary>
        /// <param name="eui">愿做代理加盟对象</param>
        /// <returns></returns>
        public int Insert(TWillAgent eui,out int intReturn)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               
                   	new SqlParameter("@Return",DbType.Int32),
                    new SqlParameter("@UserID", eui.UserID),
			        new SqlParameter("@Name", eui.Name),
					new SqlParameter("@AgentType", eui.AgentType),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Validity", eui.Validity),
					new SqlParameter("@Count", eui.Count),
					new SqlParameter("@Investment", eui.Investment),
					new SqlParameter("@Price", eui.Price),
					new SqlParameter("@Standard", eui.Standard),
					new SqlParameter("@Detail", eui.Detail),
					new SqlParameter("@Picture", eui.Picture),
					new SqlParameter("@Obligate", eui.Obligate)
					
             };
            intReturn = 0;
           // commandParameters[1].Direction = ParameterDirection.Output;
            int ReRows = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_WillAgent_Add", commandParameters);
            if (ReRows >= 0)
                intReturn = (int)commandParameters[0].Value;
            return ReRows;
        }


        /// <summary>
        /// 修改愿做代理加盟信息
        /// </summary>
        /// <param name="eui">愿做代理加盟对象<</param>
        /// <returns></returns>
        public int Update(TWillAgent eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("ID",eui.ID),
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@AgentType", eui.AgentType),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Validity", eui.Validity),
					new SqlParameter("@Count", eui.Count),
					new SqlParameter("@Investment", eui.Investment),
					new SqlParameter("@Price", eui.Price),
					new SqlParameter("@Standard", eui.Standard),
					new SqlParameter("@Detail", eui.Detail),
					new SqlParameter("@Picture", eui.Picture),
					new SqlParameter("@Obligate", eui.Obligate)

             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_WillAgent_Update", commandParameters);
        }


        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TWillAgent eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_WillAgent_UpdateVerify", commandParameters);
        }


        /// <summary>
        /// 修改推荐信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateRecommend(TWillAgent eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Recommend", eui.Recommend)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_WillAgent_UpdateRecommend", commandParameters);
        }


        /// <summary>
        /// 根据ID删除愿做代理加盟信息
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_WillAgent") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }


        /// <summary>
        /// 得到所有愿做代理加盟
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName","W_WillAgent"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }


        /// <summary>
        /// 根据愿做代理加盟类型得到愿做代理加盟信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TWillAgent us)
        {
            string str = "where 1=1";
            if (us.UserID != 0)
                str += " and UserID=" + us.UserID;
            if (us.Verify != 0)
            {
                if (us.Verify == 4)
                    str += " and (datediff(day,AddDate,getdate())>Validity)";
                else
                    str += " and Verify=" + us.Verify;
            }
            else
                str += " and Verify=" + 1;

            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "W_WillAgent"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }


        /// <summary>
        /// 根据ID得到愿做代理加盟每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TWillAgent GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_WillAgent"), 
                new SqlParameter("@strOrder", "") 
            };
            TWillAgent info = new TWillAgent();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Name = reader["Name"].ToString();

                if (reader["AgentType"].ToString() != "")
                {
                    info.AgentType = int.Parse(reader["AgentType"].ToString());
                }
                info.Title = (reader["Title"].ToString());
                info.Validity = reader["Validity"].ToString();
                if (reader["Count"].ToString() != "")
                {
                    info.Count = int.Parse(reader["Count"].ToString());
                }
                info.Investment = reader["Investment"].ToString();
                info.Price = reader["Price"].ToString();
                info.Standard = reader["Standard"].ToString();
                info.Detail = reader["Detail"].ToString();
                info.Picture = reader["Picture"].ToString();
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = int.Parse(reader["Verify"].ToString());
                }
                if (reader["Recommend"].ToString() != "")
                {
                    info.Recommend = Convert.ToBoolean(reader["Recommend"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                info.Obligate = reader["Obligate"].ToString();
            }
            return info;
        }
        #endregion
    }
}
