﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;
using Base;

/// <summary>
/// R_Product 的摘要说明
/// </summary>
namespace nspProduct
{
    public class clsRProduct:clsIProduct
    {
        #region clsIProduct 成员

        int clsIProduct.Insert(clsTProduct pro)
        {
            SqlParameter[] commentParameter = new SqlParameter[]
            {
                new SqlParameter("@name",pro.Name),
                new SqlParameter("@TypeID",pro.TypeId),
                new SqlParameter("@KeyWord",pro.KeyWord),
                new SqlParameter("@Picture",pro.Picture),
                new SqlParameter("@Detail",pro.Detail),
                new SqlParameter("@AddDate",pro.AddDate),
                new SqlParameter("@Price",pro.Price)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Product_Add", commentParameter);
        }

        int clsIProduct.Update(clsTProduct pro)
        {
            SqlParameter[] commentParameter = new SqlParameter[] { 
                new SqlParameter("@name",pro.Name),
                new SqlParameter("@TypeID",pro.TypeId),
                new SqlParameter("@KeyWord",pro.KeyWord),
                new SqlParameter("@Picture",pro.Picture),
                new SqlParameter("@Detail",pro.Detail),
                new SqlParameter("@AddDate",pro.AddDate),
                 new SqlParameter("@Price",pro.Price),
                new SqlParameter("@ID",pro.ID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Product_Update", commentParameter);
        }

        int clsIProduct.Delete(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + id + ")"), 
                new SqlParameter("@strTableName", "W_Products") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }

        DataTable clsIProduct.GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","a.ID,a.Name,a.TypeID,a.Picture,a.KeyWord,a.AddDate,a.Detail,a.Price"),
                new SqlParameter("@strwhere", ""),
                new SqlParameter("@strtableName", "W_Products as a"),
                new SqlParameter("@strOrder", "  order by a.AddDate desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        public clsTProduct GetItems(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +Convert.ToInt32( id)), 
                new SqlParameter("@strTableName", "W_Products"), 
                new SqlParameter("@strOrder", "") 
            };
            clsTProduct info = new clsTProduct();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                info.KeyWord = reader["KeyWord"].ToString();
                info.Detail = (reader["Detail"].ToString());
                info.Picture = reader["Picture"].ToString();
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeId = reader["TypeID"].ToString();
                }   
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                info.Price =float.Parse(reader["Price"].ToString());
            }
            return info;
        }

        #endregion
    }
}
