﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_Purchase 的摘要说明
/// </summary>
namespace Product
{
    public class RPurchase : IPurchase
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IPurchase 成员

        /// <summary>
        /// 添加求购信息
        /// </summary>
        /// <param name="eui">求购信息所有对象</param>
        /// <returns></returns>
        public int Insert(TPurchase eui, out int intReturn)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {   
                    new SqlParameter("@Return", SqlDbType.Int),
                    new SqlParameter("@UserID", eui.UserID), 
                    new SqlParameter ("IsUser",eui.IsUser),
					new SqlParameter("@IndType", eui.IndType),
					new SqlParameter("@Name", eui.Name),
					new SqlParameter("@Key", eui.Key),
					new SqlParameter("@Info", eui.Info),
                    new SqlParameter("@Thumbnail",eui.Thumbnail),
					new SqlParameter("@Picture_1", eui.Picture_1),
					new SqlParameter("@Picture_2", eui.Picture_2),
					new SqlParameter("@Picture_3", eui.Picture_3),
					new SqlParameter("@StartDate", eui.StartDate),
                    new SqlParameter("@EndDate", eui.EndDate),
					new SqlParameter("@Brand", eui.Brand),
					new SqlParameter("@Model", eui.Model),
					new SqlParameter("@Unit", eui.Unit),
					new SqlParameter("@Count", eui.Count),
					new SqlParameter("@Price", eui.Price),
            };
            intReturn = 0;
            commandParameters[0].Direction = ParameterDirection.Output;
            int ReRows = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_Purchase_Add", commandParameters);
            if (ReRows >= 0)
                intReturn = (int)commandParameters[0].Value;
            return ReRows;
        }
        /// <summary>
        /// 修改求购信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TPurchase eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@IndType", eui.IndType),
					new SqlParameter("@Name", eui.Name),
					new SqlParameter("@Key", eui.Key),
					new SqlParameter("@Info", eui.Info),
                    new SqlParameter("@Thumbnail",eui.Thumbnail),
					new SqlParameter("@Picture_1", eui.Picture_1),
					new SqlParameter("@Picture_2", eui.Picture_2),
					new SqlParameter("@Picture_3", eui.Picture_3),
                    new SqlParameter("@StartDate", eui.StartDate),
                    new SqlParameter("@EndDate", eui.EndDate),
			        new SqlParameter("@Brand", eui.Brand),
					new SqlParameter("@Model", eui.Model),
					new SqlParameter("@Unit", eui.Unit),
					new SqlParameter("@Count", eui.Count),
					new SqlParameter("@Price", eui.Price)
               
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Purchase_Update", commandParameters);
        }
        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TPurchase eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Purchase_UpdateVerify", commandParameters);
        }

        /// <summary>
        /// 修改推荐信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateRecommend(TPurchase eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Recommend", eui.Recommend)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Purchase_UpdateRecommend", commandParameters);
        }
        /// <summary>
        /// 根据ID删除求购信息 
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_Purchase") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据标题名称和会员名称得到所有求购信息
        /// </summary>
        /// <returns></returns>

        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","C_Purchase.*,U_UserInfo.LoginName"),
                new SqlParameter("@strWhere","on U_UserInfo.UserID = C_Purchase.UserID "+strWhere),
                new SqlParameter("@strTableName","U_UserInfo INNER JOIN C_Purchase"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据用ID和审核信息得到用户求购信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TPurchase us)
        {
            string str = "where 1=1";
            if (us.UserID != 0)
                str += " and UserID=" + us.UserID;
            if (us.Verify != 0)
                str += " and Verify=" + us.Verify;
            else
                str += " and Verify=" + 1;

            SqlParameter[] param = new SqlParameter[] 
            {
                 new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "C_Purchase"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到求购每一条求购信息
        /// </summary>
        /// <param name="ID">求购ID</param>
        /// <returns></returns>
        public TPurchase GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "C_Purchase"), 
                new SqlParameter("@strOrder", "") 
            };
            TPurchase info = new TPurchase();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = Convert.ToInt32(reader["UserID"].ToString());
                }
                if (reader["IsUser"].ToString()!="")
                {
                    info.IsUser = reader["IsUser"].ToString();
                }
                info.IndType = reader["IndType"].ToString();
                info.Name = reader["Name"].ToString();
                info.Key = reader["Key"].ToString();
                info.Info = reader["Info"].ToString();
                info.Thumbnail = reader["Thumbnail"].ToString();
                info.Picture_1 = reader["Picture_1"].ToString();
                info.Picture_2 = reader["Picture_2"].ToString();
                info.Picture_3 = reader["Picture_3"].ToString();
                if (reader["StartDate"].ToString() != "")
                {
                    info.StartDate = Convert.ToDateTime(reader["StartDate"].ToString());
                }
                else
                {
                    info.StartDate = DateTime.Now.Date;
                }
                if (reader["EndDate"].ToString() != "")
                {
                    info.EndDate = Convert.ToDateTime(reader["EndDate"].ToString());
                }
                else
                {
                    info.EndDate = DateTime.Now.Date;
                }
                info.Brand = reader["Brand"].ToString();
                info.Model = reader["Model"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                else
                {
                    info.AddDate = DateTime.Now.Date;
                }
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToInt32(reader["Verify"].ToString());
                }
                if (reader["Recommend"].ToString() != "")
                {
                    info.Recommend = Convert.ToBoolean(reader["Recommend"].ToString());
                }
                info.Obligate = reader["Obligate"].ToString();
                info.Unit = reader["Unit"].ToString();
                if (reader["Count"].ToString() != "")
                {
                    info.Count = Convert.ToInt32(reader["Count"].ToString());
                }
                info.Price = Convert.ToDouble(reader["Price"]);

            }
            return info;
        }
        #endregion

    }
}
