﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using SqlOperate;

/// <summary>
/// R_Supply 的摘要说明
/// </summary>
namespace Product
{
    public class RSupply : ISupply
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region ISupply 成员

        /// <summary>
        /// 添加供应信息
        /// </summary>
        /// <param name="eui">供应信息对象</param>
        /// <returns></returns>
        public int Insert(TSupply eui, out int intReturn)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                new SqlParameter("@Return", SqlDbType.Int),
                new SqlParameter("@UserID",eui.UserID),
                new SqlParameter("@IndType", eui.IndType),
				new SqlParameter("@Name", eui.Name),
                new SqlParameter("@Key", eui.Key),
                new SqlParameter("@Info", eui.Info),
                new SqlParameter("@Thumbnail", eui.Thumbnail),
                new SqlParameter("@Picture_1", eui.Picture_1),
                new SqlParameter("@Picture_2", eui.Picture_2),
                new SqlParameter("@Picture_3", eui.Picture_3),
				new SqlParameter("@ProType", eui.ProType),
                new SqlParameter("@Place", eui.Place),
                new SqlParameter("@Brand", eui.Brand),
				new SqlParameter("@Model", eui.Model),
                new SqlParameter("@Price", eui.Price),
                new SqlParameter("@Quantity", eui.Quantity),
				new SqlParameter("@Units", eui.Units),
                new SqlParameter("@Minimum", eui.Minimum),
                new SqlParameter("@Deadline", eui.Deadline),
                new SqlParameter("@StartDate", eui.StartDate),
                new SqlParameter("@EndDate", eui.EndDate)
             };
            intReturn = 0;
            commandParameters[0].Direction = ParameterDirection.Output;
            int ReRows = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_Supply_Add", commandParameters);
            if (ReRows >0)
                intReturn = Convert.ToInt32(commandParameters[0].Value);
            return ReRows;
        }


        /// <summary>
        /// 修改供应信息
        /// </summary>
        /// <param name="eui">供应信息对象<</param>
        /// <returns></returns>
        public int Update(TSupply eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                 new SqlParameter("@ID", eui.ID),
                new SqlParameter("@IndType", eui.IndType),
				new SqlParameter("@Name", eui.Name),
                new SqlParameter("@Key", eui.Key),
                new SqlParameter("@Info", eui.Info),
                new SqlParameter("@Thumbnail", eui.Thumbnail),
                new SqlParameter("@Picture_1", eui.Picture_1),
                new SqlParameter("@Picture_2", eui.Picture_2),
                new SqlParameter("@Picture_3", eui.Picture_3),
				new SqlParameter("@ProType", eui.ProType),
                new SqlParameter("@Place", eui.Place),
                new SqlParameter("@Brand", eui.Brand),
				new SqlParameter("@Model", eui.Model),
                new SqlParameter("@Price", eui.Price),
                new SqlParameter("@Quantity", eui.Quantity),
				new SqlParameter("@Units", eui.Units),
                new SqlParameter("@Minimum", eui.Minimum),
                new SqlParameter("@Deadline", eui.Deadline),
                new SqlParameter("@StartDate", eui.StartDate),
                new SqlParameter("@EndDate", eui.EndDate),
                new SqlParameter("@Remark", eui.Remark),
                new SqlParameter("@Document", eui.Document)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Supply_Update", commandParameters);
        }
        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TSupply eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Supply_UpdateVerify", commandParameters);
        }
        /// <summary>
        /// 修改推荐信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateRecommend(TSupply eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Recommend", eui.Recommend)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_C_Supply_UpdateRecommend", commandParameters);
        }


        /// <summary>
        /// 根据ID删除供应信息
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_Supply") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }
        /// <summary>
        /// 根据行业分类删除供应信息
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_Supply") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据标题名称和会员名称得到供应信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","U_UserInfo.LoginName,U_UserInfo.CompanyName,U_UserInfo.QQ,C_Supply.*"),
                new SqlParameter("@strWhere","ON C_Supply.UserID =U_UserInfo.UserID "+strWhere),
                new SqlParameter("@strTableName","C_Supply INNER JOIN U_UserInfo"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据用户ID和审核信息得到求购信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TSupply us)
        {
            string str = "where 1=1";
            if (us.UserID != 0)
                str += " and UserID=" + us.UserID;
            if (us.Verify != 0)
                str += " and Verify=" + us.Verify;
            else
                str += " and Verify=" + 1;

            SqlParameter[] param = new SqlParameter[] 
            {
                 new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "C_Supply"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到供应每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TSupply GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +Convert.ToInt32( ID)), 
                new SqlParameter("@strTableName", "C_Supply"), 
                new SqlParameter("@strOrder", "") 
            };
            TSupply info = new TSupply();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = Convert.ToInt32(reader["UserID"].ToString());
                }
                info.IndType = reader["IndType"].ToString();
                info.Name = reader["Name"].ToString();
                info.Key = reader["Key"].ToString();
                info.Info = (reader["Info"].ToString());
                info.Thumbnail = reader["Thumbnail"].ToString();
                info.Picture_1 = reader["Picture_1"].ToString();
                info.Picture_2 = reader["Picture_2"].ToString();
                info.Picture_3 = reader["Picture_3"].ToString();
                if (reader["ProType"].ToString() != "")
                {
                    info.ProType = Convert.ToInt32(reader["ProType"].ToString());
                }
                info.Place = reader["Place"].ToString();
                info.Brand = reader["Brand"].ToString();
                info.Model = reader["Model"].ToString();
                if (reader["Price"].ToString() != "")
                {
                    info.Price = Convert.ToDouble(reader["Price"].ToString());
                }
                if (reader["Quantity"].ToString() != "")
                {
                    info.Quantity = int.Parse(reader["Quantity"].ToString());
                }
                info.Units = (reader["Units"].ToString());
                if (reader["Minimum"].ToString() != "")
                {
                    info.Minimum = int.Parse(reader["Minimum"].ToString());
                }
                if (reader["Deadline"].ToString() != "")
                {
                    info.Deadline = int.Parse(reader["Deadline"].ToString());
                }
                if (reader["StartDate"].ToString() != "")
                {
                    info.StartDate = Convert.ToDateTime(reader["StartDate"].ToString());
                }
                if (reader["EndDate"].ToString() != "")
                {
                    info.EndDate = Convert.ToDateTime(reader["EndDate"].ToString());
                }

                info.Remark = reader["Remark"].ToString();
                info.Document = reader["Document"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                else
                {
                    info.AddDate = DateTime.Now.Date;
                }
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToInt32(reader["Verify"].ToString());
                }
                if (reader["Recommend"].ToString() != "")
                {
                    info.Recommend = Convert.ToBoolean(reader["Recommend"].ToString());
                }
            }

            return info;
        }
        public bool GetMessageExists(string messagehead,int userid)
        {
            int num = 0;
            String sql = "select count(*)  from C_Supply where Name='" + messagehead + "' and UserID="+userid;
            SqlConnection conn = new SqlConnection(SqlHelper.ConnectionString);
            conn.Open();
            SqlCommand cmmd = new SqlCommand(sql, conn);
            num = Convert.ToInt32(cmmd.ExecuteScalar());
            conn.Close();
            if (num > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        #endregion

    }
}
