﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// R_Area 的摘要说明
/// </summary>
namespace Area
{
    public class RArea :IArea
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IArea 成员
        /// <summary>
        /// 添加地区信息
        /// </summary>
        /// <param name="eui">地区信息对象</param>
        /// <returns></returns>
        public int Insert(TArea eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@ParentID", eui.ParentID),
					new SqlParameter("@Sequence", eui.Sequence)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Area_Add", commandParameters);
        }
        /// <summary>
        /// 修改地区信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TArea eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Name", eui.Name)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Area_Update", commandParameters);
        }
        /// <summary>
        /// 更新排序字段
        /// </summary>
        /// <param name="paixu">排序字段id</param>
        /// <param name="lbid">主字段id</param>
        public int UpdateSequence(int paixu, int lbid)
        {
            string updataStr = "UPDATE  W_Area SET Sequence=@Sequence where ID=@id";
            SqlParameter[] parms ={
            new SqlParameter("@ID",lbid),
            new SqlParameter("@Sequence",paixu)
            
            };
            return SqlHelper.ExecuteNonQuery(CommandType.Text, updataStr, parms);
        }
        /// <summary>
        /// 根据ID删除地区信息
        /// </summary>
        /// <param name="ID">地区ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Area") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到地区信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_Area"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据地区上级ID得到地区信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ParentID="+ParamID),
                new SqlParameter("@strtableName", "W_Area"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据地区ID字符串得到地区信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetFullData(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strSelect", " Name,ID"), 
                new SqlParameter("@strwhere", "where patindex('%,'+rtrim( ID)+',%',','+(select FullID from W_Area where ID="+ ParamID+") +',')>0 or ID="+ParamID),
                new SqlParameter("@strtableName", "W_Area"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        ///  根据ID得到地区每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TArea GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "W_Area"), 
                new SqlParameter("@strOrder", "") 
            };
            TArea info = new TArea();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                if (reader["Sequence"].ToString() != "")
                {
                    info.Sequence = Convert.ToInt32(reader["Sequence"].ToString());
                }
            }
            return info;
        }
        #endregion


    }
}
