﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// R_WebBasicInfo 的摘要说明
/// </summary>
namespace WebBasicInfo
{


    public class RWebBasicInfo : IWebBasicInfo
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IIndustryType 成员
        /// <summary>
        /// 添加网站基本信息
        /// </summary>
        /// <param name="eui">网站基本信息对象</param>
        /// <returns></returns>
        public int Insert(TWebBasicInfo eui)//暂时没用
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               		new SqlParameter("@SystemTel", eui.SystemTel),
					new SqlParameter("@HotTel", eui.HotTel),
					new SqlParameter("@FaxTel", eui.FaxTel),
					new SqlParameter("@CorporationName", eui.CorporationName),
					new SqlParameter("@Receiver", eui.Receiver),
					new SqlParameter("@Address", eui.Address),
					new SqlParameter("@PostalCode", eui.PostalCode),
					new SqlParameter("@BankAccount", eui.BankAccount),
					new SqlParameter("@BankName", eui.BankName),
					new SqlParameter("@KeyWordCount", eui.KeyWordCount),
					new SqlParameter("@Email", eui.Email),
					new SqlParameter("@EmailName", eui.EmailName),
					new SqlParameter("@EmailPass", eui.EmailPass),
					new SqlParameter("@SMTP", eui.SMTP)
                    

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_WebBasicInfo_Add ", commandParameters);
        }


        /// <summary>
        /// 修改网站邮件信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TWebBasicInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
			    new SqlParameter("@Email", eui.Email),
			    new SqlParameter("@EmailName", eui.EmailName),
			    new SqlParameter("@EmailPass", eui.EmailPass),
			    new SqlParameter("@SMTP", eui.SMTP)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_WebBasic_EmailInfo_Update", commandParameters);
        }


        /// <summary>
        /// 修改网站系统信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateSystemInfo(TWebBasicInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@SystemTel", eui.SystemTel),
                    new SqlParameter("@HotTel", eui.HotTel),
                    new SqlParameter("@FaxTel", eui.FaxTel),
                    new SqlParameter("@CorporationName", eui.CorporationName),
                    new SqlParameter("@Receiver", eui.Receiver),
                    new SqlParameter("@Address", eui.Address),
                    new SqlParameter("@PostalCode", eui.PostalCode),
                    new SqlParameter("@BankAccount", eui.BankAccount),
                    new SqlParameter("@BankName", eui.BankName),
                    new SqlParameter("@State", eui.State),
                    new SqlParameter("@StopReadme",eui.StopReadme),
					new SqlParameter("@WebName", eui.WebName),
					new SqlParameter("@WebURL", eui.WebURL),
					new SqlParameter("@Catalog", eui.Catalog),
					new SqlParameter("@isBlog", eui.isBlog),
					new SqlParameter("@isSecondURL", eui.isSecondURL),
					new SqlParameter("@isForum", eui.isForum),
                    new SqlParameter("@Copyright", eui.Copyright),
                    new SqlParameter("@Record", eui.Record),
                    new SqlParameter("@WebLOGO",eui.WebLOGO),
                    new SqlParameter("@Rewrite",eui.Rewrite)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_WebBasic_SystemInfo_Update", commandParameters);
        }


        /// <summary>
        /// 修改网站过滤字信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateFilter(TWebBasicInfo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    
                    new SqlParameter("@Filter", eui.Filter)
                   
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_WebBasic_Filter_Update", commandParameters);
        }


        /// <summary>
        /// 根据ID删除网站基本信息
        /// </summary>
        /// <param name="ID">行业类别ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_WebBasic") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }


        /// <summary>
        /// 得到网站基本信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_WebBasic"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }


        /// <summary>
        ///根据网站id得到网站基本信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID=" + ParamID),
                new SqlParameter("@strtableName", "W_WebBasic"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }


        /// <summary>
        ///  根据 ID得到行业分类每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TWebBasicInfo GateItem()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""), 
                new SqlParameter("@strTableName", "W_WebBasic"), 
                new SqlParameter("@strOrder", "") 
            };
            TWebBasicInfo info = new TWebBasicInfo();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.SystemTel = reader["SystemTel"].ToString();
                info.HotTel = reader["HotTel"].ToString();
                info.FaxTel = reader["FaxTel"].ToString();
                info.CorporationName = reader["CorporationName"].ToString();
                info.Receiver = reader["Receiver"].ToString();
                info.Address = reader["Address"].ToString();
                info.PostalCode = reader["PostalCode"].ToString();
                info.BankAccount = reader["BankAccount"].ToString();
                info.BankName = reader["BankName"].ToString();
                if (reader["KeyWordCount"].ToString() != "")
                {
                    info.KeyWordCount = int.Parse(reader["KeyWordCount"].ToString());
                }
                info.Email = reader["Email"].ToString();
                info.EmailName = reader["EmailName"].ToString();
                info.EmailPass = reader["EmailPass"].ToString();
                info.SMTP = reader["SMTP"].ToString();
                if (reader["State"].ToString() != "")
                {
                    info.State = int.Parse(reader["State"].ToString());
                }
                info.StopReadme = reader["StopReadme"].ToString();
                info.WebName = reader["WebName"].ToString();
                info.WebURL = reader["WebURL"].ToString();
                info.Catalog = reader["Catalog"].ToString();
                if (reader["isBlog"].ToString() != "")
                {
                    info.isBlog = Convert.ToBoolean(reader["isBlog"].ToString());
                }
                if (reader["isSecondURL"].ToString() != "")
                {
                    info.isSecondURL = Convert.ToBoolean(reader["isSecondURL"].ToString());
                }
                if (reader["isForum"].ToString() != "")
                {
                    info.isForum = Convert.ToBoolean(reader["isForum"].ToString());
                }
                info.Copyright = reader["Copyright"].ToString();
                info.Record = reader["Record"].ToString();
                info.WebLOGO = reader["WebLOGO"].ToString();
                info.Rewrite = reader["Rewrite"].ToString();
                info.Encryption = reader["Encryption"].ToString();
            }
            return info;
        }
        #endregion
    }
}
