﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// 网站基本设置
/// </summary>
namespace WebBasicInfo
{
    /// <summary>
    /// 网站基本设置接口
    /// </summary>
    public interface IWebBasicInfo
    {
        int Insert(TWebBasicInfo us);           //添加网站基本信息--暂时没用
        int Update(TWebBasicInfo us);           //修改网站邮件信息
        int UpdateSystemInfo(TWebBasicInfo eui);//修改网站系统信息
        int UpdateFilter(TWebBasicInfo eui);    //修改网站过滤信息
        int Delete(int id);                     //根据网站id删除网站基本信息
        DataTable GetDataTable();               //得到网站信息
        DataTable GetDataTable(int id);         //根据id得到网站信息
        TWebBasicInfo GateItem();               //根据id得到网站每一条基本信息
    }

    /// <summary>
    /// 网站基本设置属性
    /// </summary>
    public class TWebBasicInfo
    {
        #region Model
        private int _id;
        private string _systemtel;
        private string _hottel;
        private string _faxtel;
        private string _corporationname;
        private string _receiver;
        private string _address;
        private string _postalcode;
        private string _bankaccount;
        private string _bankname;
        private int _keywordcount;
        private string _email;
        private string _emailname;
        private string _emailpass;
        private string _smtp;
        private int _state;
        private string _storpreadme;
        private string _webname;
        private string _weburl;
        private string _catalog;
        private bool _isblog;
        private bool _issecondurl;
        private bool _isforum;
        private string _weblogo;
        private string _filter;
        private string _copyright;
        private string _record;
        private string _rewrite;
        private string _Encryption;

        /// <summary>
        /// MD5-Salt
        /// </summary>
        public string Encryption
        {
            set { this._Encryption = value; }
            get { return _Encryption; }
        }

        /// <summary>
        /// 
        /// </summary>
        public int ID
        {
            set { _id = value; }
            get { return _id; }
        }
        /// <summary>
        /// 普通电话
        /// </summary>
        public string SystemTel
        {
            set { _systemtel = value; }
            get { return _systemtel; }
        }
        /// <summary>
        /// 热线电话
        /// </summary>
        public string HotTel
        {
            set { _hottel = value; }
            get { return _hottel; }
        }
        /// <summary>
        /// 传真
        /// </summary>
        public string FaxTel
        {
            set { _faxtel = value; }
            get { return _faxtel; }
        }
        /// <summary>
        /// 公司名称
        /// </summary>
        public string CorporationName
        {
            set { _corporationname = value; }
            get { return _corporationname; }
        }
        /// <summary>
        /// 收信人
        /// </summary>
        public string Receiver
        {
            set { _receiver = value; }
            get { return _receiver; }
        }
        /// <summary>
        /// 公司地址
        /// </summary>
        public string Address
        {
            set { _address = value; }
            get { return _address; }
        }
        /// <summary>
        /// 邮政编码
        /// </summary>
        public string PostalCode
        {
            set { _postalcode = value; }
            get { return _postalcode; }
        }
        /// <summary>
        /// 银行账号
        /// </summary>
        public string BankAccount
        {
            set { _bankaccount = value; }
            get { return _bankaccount; }
        }
        /// <summary>
        /// 银行名称
        /// </summary>
        public string BankName
        {
            set { _bankname = value; }
            get { return _bankname; }
        }
        /// <summary>
        /// 关键字搜索保留记量最大条数
        /// </summary>
        public int KeyWordCount
        {
            set { _keywordcount = value; }
            get { return _keywordcount; }
        }
        /// <summary>
        /// Email
        /// </summary>
        public string Email
        {
            set { _email = value; }
            get { return _email; }
        }
        /// <summary>
        /// 邮箱的用户名
        /// </summary>
        public string EmailName
        {
            set { _emailname = value; }
            get { return _emailname; }
        }
        /// <summary>
        /// 邮箱密码
        /// </summary>
        public string EmailPass
        {
            set { _emailpass = value; }
            get { return _emailpass; }
        }
        /// <summary>
        /// 邮箱服务器
        /// </summary>
        public string SMTP
        {
            set { _smtp = value; }
            get { return _smtp; }
        }
        /// <summary>
        /// 维护说明
        /// </summary>
        public string StopReadme
        {
            set { _storpreadme = value; }
            get { return _storpreadme; }
        }
        /// <summary>
        /// 网站当前状态
        /// </summary>
        public int State
        {
            set { _state = value; }
            get { return _state; }
        }
        /// <summary>
        /// 网站名称
        /// </summary>
        public string WebName
        {
            set { _webname = value; }
            get { return _webname; }
        }
        /// <summary>
        /// 网站网址
        /// </summary>
        public string WebURL
        {
            set { _weburl = value; }
            get { return _weburl; }
        }
        /// <summary>
        /// 网站后台管理目录
        /// </summary>
        public string Catalog
        {
            set { _catalog = value; }
            get { return _catalog; }
        }
        /// <summary>
        /// 是否整合网商博客
        /// </summary>
        public bool isBlog
        {
            set { _isblog = value; }
            get { return _isblog; }
        }
        /// <summary>
        /// 是否开启用户二级域名
        /// </summary>
        public bool isSecondURL
        {
            set { _issecondurl = value; }
            get { return _issecondurl; }
        }
        /// <summary>
        /// 是否整合论坛
        /// </summary>
        public bool isForum
        {
            set { _isforum = value; }
            get { return _isforum; }
        }
        /// <summary>
        /// 网站LOGO
        /// </summary>
        public string WebLOGO
        {
            set { _weblogo = value; }
            get { return _weblogo; }
        }
        /// <summary>
        /// 过滤管理
        /// </summary>
        public string Filter
        {
            set { _filter = value; }
            get { return _filter; }
        }
        /// <summary>
        /// 网站版权
        /// </summary>
        public string Copyright
        {
            set { _copyright = value; }
            get { return _copyright; }
        }
        /// <summary>
        /// 网站备案
        /// </summary>
        public string Record
        {
            set { _record = value; }
            get { return _record; }
        }
        /// <summary>
        /// 伪静态
        /// </summary>
        public string Rewrite
        {
            set { _rewrite = value; }
            get { return _rewrite; }
        }
        #endregion Model
    }
}
