﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.IO;
using System.Web.SessionState;


namespace Base
{
    /// <summary>
    /// BasePage 的摘要说明
    /// </summary>
    public class BasePage : System.Web.UI.Page
    {
        public  BasePage()
        {
            _Config = new Base.Core.WebConfig();
        }

        #region 属性

        private static Base.Core.WebConfig _Config = new Base.Core.WebConfig();
        private static string[] _Err = new string[3];

        /// <summary>
        /// 网站基本信息
        /// </summary>
        public static Base.Core.WebConfig Config
        {
           // set { _Config = value; }
            get { return _Config; }
        }
 
        /// <summary>
        /// 错误信息
        /// </summary>
        public static string[] Err
        {
            get { return _Err; }
        }

        #endregion attribute

    
        #region  方法

        /// <summary>
        /// 检测管理员是否拥有权限
        /// </summary>
        /// <param name="strType">类别[basic:基本设置，column:栏目，model:模块，user:会员管理，template:模板，system:系统设置]</param>
        /// <param name="strOperate">允许执行的条件</param>
        public static bool CheckRights(string strType, string strOperate)
        {
            string strRights = "";
            if (HttpContext.Current.Session["ManagerName"] != null )
            {
                if (strType != null && strType != "")
                {
                    AdminRights.TRole tr = new AdminRights.TRole();
                    AdminRights.IRole ir = new AdminRights.RRole();
                    tr = ir.GetItem(int.Parse(HttpContext.Current.Session["RoleID"].ToString()));
                    switch (strType.ToLower())
                    {
                        case "basic":
                            strRights = tr.Basic.ToString();
                            break;
                        case "column":
                            strRights = tr.Column.ToString();
                            break;
                        case "user":
                            strRights = tr.User.ToString();
                            break;
                        case "template":
                            strRights = tr.Template.ToString();
                            break;
                        case "system":
                            strRights = tr.System.ToString();
                            break;
                    }
                    if (strRights.Contains(strOperate))
                    {
                        return true;
                    }
                    else
                    {
                        HandleErr("1", "../index_center.aspx");
                        return false;
                    }                  
                }
                return true;
            }
            else
            {
                HandleErr("0", "../login.aspx");
                return false;
            }
        }


        /// <summary>
        /// 处理图片路径
        /// </summary>
        /// <param name="strImageURL"></param>
        /// <returns></returns>
        public static string ProcessImageUrl(string strImageURL)
        {
            string strURL = "";
            if (strImageURL != "")
            {
                strURL = strImageURL.Replace("../../../", "~/").Replace("../../", "~/").Replace("../", "~/");
            }
            return strURL;
        }


        /// <summary>
        /// 处理图片为绝对路径
        /// </summary>
        /// <param name="strImageURL"></param>
        /// <returns></returns>
        public static string ProcessAbsoluteUrl(string strImageURL)
        {
            string strURL = "";
            if (strImageURL != "")
            {
                
                strURL = strImageURL.Replace("~/", Config.WebURL).Replace("../../../", Config.WebURL).Replace("../../", Config.WebURL).Replace("../", Config.WebURL);
            }
            return strURL;
        }


        /// <summary>
        /// 检测文件是否存在
        /// </summary>
        /// <param name="FileUrl">文件路径</param>
        /// <returns></returns>
        public static bool CheckFile(string FileUrl)
        {
            if (File.Exists(FileUrl))
                return true;
            else
                return false;
        }


        /// <summary>
        /// 检测用户是否登陆系统和Cookies是否过时
        /// </summary>
        /// <param name="strName">用户名</param>
        /// <param name="strPas">密码</param>
        /// <param name="GradeI">等级</param>
        /// <returns></returns>
        public static bool CheckCookies()
        {
            if (GetCookie("LoginName") != null && GetCookie("UserId") != null && GetCookie("GradeID") != null)
                return true;
            else
                return false;
        }


        /// <summary>
        /// 读取Cookies
        /// </summary>
        /// <param name="strName">Cookie 主键</param>
        /// <code>Cookie ck = new Cookie();</code>
        /// <code>ck.getCookie("主键");</code>
        public static string GetCookie(string strName)
        {
            HttpCookie Cookie = HttpContext.Current.Request.Cookies[strName];
            if (Cookie != null)
            {
                return Cookie.Value.ToString();
            }
            else
            {
                return null;
            }
        }


        /// <summary>
        /// 清除Cookies
        /// </summary>
        /// <param name="strName"></param>
        public static bool ClearCookie()
        {

            if (ClearCookie("LoginName") && ClearCookie("UserID") && ClearCookie("GradeID"))
                return true;
            else
                return false;
        }


        /// <summary>
        /// 清除Cookies
        /// </summary>
        /// <param name="strName"></param>
        public static bool ClearCookie(string strName)
        {
            HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
            if (cookie != null)
            {
                cookie.Value = null;
                cookie.Expires = DateTime.Now.AddDays(-1.0);
                cookie.Values.Clear();
                HttpContext.Current.Response.Cookies.Set(cookie);
            }
            return true;
        }



        /// <summary>
        /// 提示错误信息
        /// </summary>
        /// <param name="Str"></param>
        public static void ShowMessage(string Str)
        {
            HttpContext.Current.Response.Write("<script>alert(\"" + Str + "\"); history.go(-1); </script>");
        }


        /// <summary>
        /// 提示错误信息并转向
        /// </summary>
        /// <param name="Str"></param>
        /// <param name="Url"></param>
        public static void ShowMessage(string Str, string Url)
        {
            //HttpContext.Current.Response.Write("<script>alert(\"" + Str + "\");location = '" + Url + "'</script>");
            //HttpContext.Current.Response.Redirect( "http://192.168.0.131:8080/admin/SendMessage.aspx?path=" + Url + "&msg=" + Str);
            HttpContext.Current.Response.Write("<script>location = '"+Base.BasePage.Config.WebURL+"admin/SendMessage.aspx?path=" + Url + "&msg=" + Str + "'</script>");
            return;
        }


        /// <summary>
        /// 转到错误信息处理页面
        /// </summary>
        /// <param name="strErrMessage">要提示的错误信息</param>
        /// <param name="strErrURL">转向的地址</param>
        /// <param name="intErrID"></param>
        public static void HandleErr(string strErrMessage,string strErrURL,string strErrID)
        {
            _Err[0] = strErrMessage;
            _Err[1] = strErrURL;
            _Err[2] = strErrID;
            HttpContext.Current.Response.Redirect(_Config.WebURL+ _Config.AdminFolder + "/Error.aspx");
        }


        /// <summary>
        /// 转到错误信息处理页面
        /// </summary>
        /// <param name="strErrMessage">要提示的错误信息</param>
        /// <param name="strErrURL">转向的地址</param>
        /// <param name="intErrID"></param>
        public static void HandleErr(string strErrMessage, string strErrURL)
        {
            _Err[0] = strErrMessage;
            _Err[1] = strErrURL;
            HttpContext.Current.Response.Redirect(_Config.WebURL + _Config.AdminFolder + "/Error.aspx");
        }



        /// <summary>
        /// 检测输入的验证码是否正确
        /// </summary>
        /// <param name="str">输入的验证码</param>
        /// <returns></returns>
        public static bool CheckCode(string str)
        {
            string Code = GetCookie("CheckCode");
            if (string.IsNullOrEmpty(Code))
            {
                return false;
            }
            else if (Code.ToLower() != str.ToLower())
            {
                return false;
            }
            else
            {
                return true;
            }
        }


        /// <summary>
        /// 检测管理员是否在线
        /// </summary>
        /// <returns></returns>
        public static bool CheckSession()
        {
            if (HttpContext.Current.Session["ManagerName"] =="")
            {
                //HttpContext.Current.Response.Write("<script>alert(\"您登陆时间到期，请重新登陆\");parent.location = '" + Url + "'</script>");
                return true;
            }
            return false;
        }

        #endregion method
    }
}
