﻿using System;
using System.Data;
using System.Configuration;
using Product;
using System.Text;

namespace Base
{
    /// <summary>
    /// CreateJS 的摘要说明
    /// </summary>
    public class CreateJS
    {


        /// <summary>
        /// 创建地区JS
        /// </summary>
        /// <param name="strType"></param>
        /// <returns></returns>
        public static string CreateArea()
        {
            string strStart = AreaStart();
            string strDate = GateAreaDate(0,"中国");
            string strEnd = AreaEnd();
            string str = strStart + strDate + strEnd;
            return str;
        }

        /// <summary>
        /// 地区起始内容
        /// </summary>
        /// <returns></returns>
        private static string AreaStart()
        {
            StringBuilder bd = new StringBuilder();
            bd.Append("function Dsy()\r\n");
            bd.Append("{\r\n");
            bd.Append("    this.Items = {};\r\n");
            bd.Append("}\r\n");
            bd.Append("Dsy.prototype.add = function(id,iArray)\r\n");
            bd.Append("{\r\n");
            bd.Append("    this.Items[id] = iArray;\r\n");
            bd.Append("}\r\n");
            bd.Append("Dsy.prototype.Exists = function(id)\r\n");
            bd.Append("{\r\n");
            bd.Append("    if(typeof(this.Items[id]) == \"undefined\") return false;\r\n");
            bd.Append("    return true;\r\n");
            bd.Append("}\r\n");
            bd.Append("\r\n");
            bd.Append("function change(v,Flag)\r\n");
            bd.Append("{\r\n");
            bd.Append("   if(Flag==1)\r\n");
            bd.Append("   {  \r\n");
            bd.Append("     str0 = \"ctl00$ContInfo$\";\r\n");
            bd.Append("     str1 = \"ctl00_ContInfo_\";\r\n");
            bd.Append("   }\r\n");
            bd.Append("   else\r\n");
            bd.Append("   {  \r\n");
            bd.Append("      str0 = \"\";\r\n");
            bd.Append("      str1 = \"\";\r\n");
            bd.Append("   } \r\n");
            bd.Append("   var str=\"中国\";\r\n");
            bd.Append("   var ss=document.getElementById(str0+s[v]);\r\n");
            bd.Append("   with(ss)\r\n");
            bd.Append("   {\r\n");
            bd.Append("      length = 0;\r\n");
            bd.Append("      for(i=0;i<v;i++){ str += \"-\"+document.getElementById(str0+s[i]).options[document.getElementById(str0+s[i]).selectedIndex].value;};\r\n");
            bd.Append("      options[0]=new Option(opt0[v],opt0[v]);    \r\n");
            bd.Append("      if(dsy.Exists(str))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         ar = dsy.Items[str];\r\n");
            bd.Append("         for(i=0;i<ar.length;i++)options[length]=new Option(ar[i],ar[i]);\r\n");
            bd.Append("         options[1].selected = true;\r\n");
            bd.Append("      }\r\n");
            bd.Append("   }\r\n");
            bd.Append("	  if(++v<s.length){change(v,Flag);}\r\n");
            bd.Append("}\r\n");
            bd.Append("\r\n");
            bd.Append("\r\n");
            bd.Append("var dsy = new Dsy();\r\n");
            bd.Append("\r\n");
            String str = bd.ToString();
            return str;
        }


        /// <summary>
        /// 地区循环内容
        /// </summary>
        /// <param name="ID">ID</param>
        /// <param name="Flag">属于第几级</param>
        /// <returns></returns>
        private static string GateAreaDate(int ID,string ParentName)
        {
            StringBuilder bd = new StringBuilder();
            DataTable table = new DataTable();
            bd.Append("dsy.add(\"");
            bd.Append(ParentName);
            bd.Append("\",");
            Area.IArea ar = new Area.RArea();
            table = ar.GetDataTable(ID);
            bd.Append("[");
            for (int i = 0; i < table.Rows.Count; i++)
            {
                bd.Append("\"");
                bd.Append(table.Rows[i]["Name"]);
                //bd.Append(",");
                //bd.Append(table.Rows[i]["ID"]);
                bd.Append("\"");
                if (i == table.Rows.Count - 1)
                    bd.Append(" ");
                else
                    bd.Append(",");
            }
            bd.Append("]");
            bd.Append(");\r\n");
            for (int i = 0; i < table.Rows.Count; i++)
            {
                String str1 = "";
                if (Convert.ToBoolean(table.Rows[i]["UnderlingFlag"].ToString()))
                    str1 = GateAreaDate(Convert.ToInt32(table.Rows[i]["ID"]), ParentName+"-"+table.Rows[i]["Name"].ToString());
                bd.Append(str1);
            }
            String str = bd.ToString();
            return str;
        }


        /// <summary>
        /// 地区结束内容
        /// </summary>
        /// <returns></returns>
        private static string AreaEnd()
        {
            StringBuilder bd = new StringBuilder();
            bd.Append(" \r\n");
            bd.Append("var s=[\"province\",\"city\",\"county\"];\r\n");
            bd.Append("var opt0 = [\"省份\",\"地级市\",\"市、县级市、县\"];\r\n");
            bd.Append("function setupArea(Flag)\r\n");
            bd.Append("{\r\n");
            bd.Append("   if(Flag==1)\r\n");
            bd.Append("     str0 = \"ctl00$ContInfo$\";\r\n");
            bd.Append("   else\r\n");
            bd.Append("      str0 = \"\";\r\n");
            bd.Append("   for(i=0;i<s.length-1;i++)\r\n");
            bd.Append("   document.getElementById(str0+s[i]).onchange=new Function(\"change(\"+(i+1)+\",\"+Flag+\")\");\r\n");
            bd.Append("   change(0,Flag);\r\n");
            bd.Append("}\r\n");
            bd.Append("\r\n");
            bd.Append("function initializeArea(Flag)\r\n");
            bd.Append("{\r\n");
            bd.Append("   if(Flag==1)\r\n");
            bd.Append("   {  \r\n");
            bd.Append("     str0 = \"ctl00$ContInfo$\";\r\n");
            bd.Append("     str1 = \"ctl00_ContInfo_\";\r\n");
            bd.Append("   }\r\n");
            bd.Append("   else\r\n");
            bd.Append("   {  \r\n");
            bd.Append("      str0 = \"\";\r\n");
            bd.Append("      str1 = \"\";\r\n");
            bd.Append("   } \r\n");
            bd.Append("   for(i=0;i<s.length-1;i++)document.getElementById(str0+s[i]).onchange=new Function(\"change(\"+(i+1)+\",\"+Flag+\")\");\r\n");
            bd.Append("   s1=document.getElementById(str1+s[0]);\r\n");
            bd.Append("   s2=document.getElementById(str1+s[1]);\r\n");
            bd.Append("   s3=document.getElementById(str1+s[2]);\r\n");
            bd.Append("   ProvinceID = document.getElementById(str1 + \"txtProvince\").value;\r\n");
            bd.Append("   CityID = document.getElementById(str1 + \"txtcity\").value;\r\n");
            bd.Append("   CountyID = document.getElementById(str1 + \"txtcounty\").value;\r\n");
            bd.Append("   var length = 0;\r\n");
            bd.Append("   var str = \"中国\";\r\n");
            bd.Append("   with(s1)\r\n");            
            bd.Append("   {\r\n");
            bd.Append("      if(dsy.Exists(str))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         arr = dsy.Items[str];\r\n");
            bd.Append("         options[0]=new Option(opt0[0],\"\");\r\n");
            bd.Append("         for(i=0;i<arr.length;i++)\r\n");
            bd.Append("         {\r\n");
            bd.Append("            options[length]=new Option(arr[i],arr[i]);\r\n");
            bd.Append("            if(options[i].value==ProvinceID)options[i].selected = true;\r\n");
            bd.Append("         } \r\n");
            bd.Append("      }\r\n");
            bd.Append("   };\r\n");
            bd.Append("   str += \"-\"+ProvinceID;\r\n");
            bd.Append("   with(s2)\r\n");            
            bd.Append("   {\r\n");
            bd.Append("      if(dsy.Exists(str))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         arr = dsy.Items[str];\r\n");
            bd.Append("         options[0]=new Option(opt0[0],\"\");\r\n");
            bd.Append("         for(i=0;i<arr.length;i++)\r\n");
            bd.Append("         {\r\n");
            bd.Append("            options[length]=new Option(arr[i],arr[i]);\r\n");
            bd.Append("            if(options[i].value==CityID)options[i].selected = true;\r\n");
            bd.Append("         } \r\n");
            bd.Append("      }\r\n");
            bd.Append("   };\r\n");
            bd.Append("   str += \"-\"+CityID;\r\n");
            bd.Append("   with(s3)\r\n");            
            bd.Append("   {\r\n");
            bd.Append("      if(dsy.Exists(str))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         arr = dsy.Items[str];\r\n");
            bd.Append("         options[0]=new Option(opt0[0],\"\");\r\n");
            bd.Append("         for(i=0;i<arr.length;i++)\r\n");
            bd.Append("         {\r\n");
            bd.Append("            options[length]=new Option(arr[i],arr[i]);\r\n");
            bd.Append("            if(options[i].value==CountyID)options[i].selected = true;\r\n");
            bd.Append("         } \r\n");
            bd.Append("      }\r\n");
            bd.Append("   };\r\n");
            bd.Append("};\r\n");
            String str = bd.ToString();
            return str;
        }



        /// <summary>
        /// 创建行业JS
        /// </summary>
        /// <param name="strType"></param>
        /// <returns></returns>
        public static string CreateIndustry()
        {
            string strStart = IndustryStart();
            string strDate = GateIndustryDate(0);
            string strEnd = IndustryEnd();
            string str = strStart + strDate + strEnd;
            return str;
        }


        /// <summary>
        /// 行业起始内容
        /// </summary>
        /// <returns></returns>
        private static string IndustryStart()
        {
            StringBuilder bd = new StringBuilder();
            bd.Append("function Dsy()\r\n");
            bd.Append("{\r\n");
            bd.Append("    this.Items = {};\r\n");
            bd.Append("}\r\n");
            bd.Append("Dsy.prototype.add = function(id,iArray)\r\n");
            bd.Append("{\r\n");
            bd.Append("    this.Items[id] = iArray;\r\n");
            bd.Append("}\r\n");
            bd.Append("Dsy.prototype.Exists = function(id)\r\n");
            bd.Append("{\r\n");
            bd.Append("    if(typeof(this.Items[id]) == \"undefined\") return false;\r\n");
            bd.Append("    return true;\r\n");
            bd.Append("}\r\n");
            bd.Append("\r\n");
            bd.Append("function change(v,Flag)\r\n");
            bd.Append("{\r\n");
            bd.Append("   if(Flag==1)\r\n");
            bd.Append("   {  \r\n");
            bd.Append("     str0 = \"ctl00$ContInfo$\";\r\n");
            bd.Append("     str1 = \"ctl00_ContInfo_\";\r\n");
            bd.Append("   }\r\n");
            bd.Append("   else\r\n");
            bd.Append("   {  \r\n");
            bd.Append("      str0 = \"\";\r\n");
            bd.Append("      str1 = \"\";\r\n");
            bd.Append("   } \r\n");
            bd.Append("   var str=\"0\";\r\n");
            bd.Append("   var ss=document.getElementById(str0+s[v]);\r\n");
            bd.Append("   with(ss)\r\n");
            bd.Append("   {\r\n");
            bd.Append("      length = 0;\r\n");
            bd.Append("      if(v && document.getElementById(str0+s[v-1]).selectedIndex>=0)\r\n");
            bd.Append("         str=document.getElementById(str0+s[v-1]).options[document.getElementById(str0+s[v-1]).selectedIndex].value;\r\n");
            bd.Append("      if(dsy.Exists(str))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         ar = dsy.Items[str];\r\n");
            bd.Append("         for (i = 0; i < ar.length; i++)\r\n");
            bd.Append("         {\r\n");
            bd.Append("            var ss = ar[i].split(\",\");\r\n");
            bd.Append("            options[length] = new Option(ss[0], ss[1]);\r\n");
            bd.Append("         }\r\n");
            bd.Append("      }\r\n");
            bd.Append("\r\n");
            bd.Append("   }\r\n");
            bd.Append("	  if(v==\"1\")\r\n");
            bd.Append("	  {\r\n");
            bd.Append("	     var len = document.getElementById(str0+s[v+1]).options.length;\r\n");
            bd.Append("		 for (var i=len-1;i>=0;i--)document.getElementById(str0+s[v+1]).options[i]=null;\r\n");
            bd.Append("	  }\r\n");
            bd.Append("}\r\n");
            bd.Append("\r\n");
            bd.Append("var dsy = new Dsy();\r\n");
            bd.Append("\r\n");
            String str = bd.ToString();
            return str;
        }



        /// <summary>
        ///  行业循环内容
        /// </summary>
        /// <param name="ID">ID</param>
        /// <param name="Flag">属于第几级</param>
        /// <returns></returns>
        private static string GateIndustryDate(int ID)
        {
            StringBuilder bd = new StringBuilder();
            DataTable table=new DataTable();
            bd.Append("dsy.add(\"");
            bd.Append(ID);
            bd.Append("\",");
            IIndustryType DT = new RIndustryType();
            table = DT.GetDataTable(ID);
            bd.Append("[");
            for (int i = 0; i < table.Rows.Count; i++)
            {
                bd.Append("\"");
                bd.Append(table.Rows[i]["Type"]);
                bd.Append(",");
                bd.Append(table.Rows[i]["ID"]);
                bd.Append("\"");
                if (i == table.Rows.Count - 1)
                    bd.Append(" ");
                else
                    bd.Append(",");
            }
            bd.Append("]");
            bd.Append(");\r\n");
            for (int i = 0; i < table.Rows.Count; i++)
            {
                String str1 = "";
                if (table.Rows[i]["UnderlingFlag"].ToString() == "1")
                    str1 = GateIndustryDate(Convert.ToInt32(table.Rows[i]["ID"]));
                bd.Append(str1);
            }
            String str = bd.ToString();
            return str;
        }



        /// <summary>
        /// 行业结束内容
        /// </summary>
        /// <returns></returns>
        private static string IndustryEnd()
        {
            StringBuilder bd = new StringBuilder();
            bd.Append("var s=[\"SortB\",\"SortM\",\"SortS\"];\r\n");
            bd.Append("function setup(Flag)\r\n");
            bd.Append("{\r\n");
            bd.Append("   if(Flag==1)\r\n");
            bd.Append("     str0 = \"ctl00$ContInfo$\";\r\n");
            bd.Append("   else\r\n");
            bd.Append("      str0 = \"\";\r\n");
            bd.Append("   for(i=0;i<s.length-1;i++)\r\n");
            bd.Append("   document.getElementById(str0+s[i]).onchange=new Function(\"change(\"+(i+1)+\",\"+Flag+\")\");\r\n");
            bd.Append("   change(0,Flag);\r\n");
            bd.Append("}\r\n");
            bd.Append("\r\n");
            bd.Append("function initialize(Flag)\r\n");
            bd.Append("{\r\n");
            bd.Append("   if(Flag==1)\r\n");
            bd.Append("   {  \r\n");
            bd.Append("     str0 = \"ctl00$ContInfo$\";\r\n");
            bd.Append("     str1 = \"ctl00_ContInfo_\";\r\n");
            bd.Append("   }\r\n");
            bd.Append("   else\r\n");
            bd.Append("   {  \r\n");
            bd.Append("      str0 = \"\";\r\n");
            bd.Append("      str1 = \"\";\r\n");
            bd.Append("   } \r\n");
            bd.Append("   for(i=0;i<s.length-1;i++)document.getElementById(str0+s[i]).onchange=new Function(\"change(\"+(i+1)+\",\"+Flag+\")\");\r\n");
            bd.Append("   var v=\"0\";\r\n");
            bd.Append("   s1=document.getElementById(str1+s[0]);\r\n");
            bd.Append("   s2=document.getElementById(str1+s[1]);\r\n");
            bd.Append("   s3=document.getElementById(str1+s[2]);\r\n");
            bd.Append("   var ProvinceID=document.getElementById(str1+\"txtSortB\").value;\r\n");
            bd.Append("   var cityID=document.getElementById(str1+\"txtSortM\").value;\r\n");
            bd.Append("   var CountyID=document.getElementById(str1+\"txtSortS\").value;\r\n");
            bd.Append("\r\n");
            bd.Append("\r\n");
            bd.Append("   with(s1)\r\n");
            bd.Append("   {\r\n");
            bd.Append("      if(dsy.Exists(0))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         arr = dsy.Items[0];\r\n");
            bd.Append("         for(i=0;i<arr.length;i++)\r\n");
            bd.Append("         {\r\n");
            bd.Append("            var ss = arr[i].split(\",\");\r\n");
            bd.Append("            options[length] = new Option(ss[0], ss[1]);\r\n");
            bd.Append("            if(options[i].value==ProvinceID)\r\n");
            bd.Append("               options[i].selected = true;\r\n");
            bd.Append("            }\r\n");
            bd.Append("         }\r\n");
            bd.Append("       };\r\n");
            bd.Append("   with(s2)\r\n");
            bd.Append("   {\r\n");
            bd.Append("      if(dsy.Exists(ProvinceID))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         arr = dsy.Items[ProvinceID];\r\n");
            bd.Append("         for(i=0;i<arr.length;i++) \r\n");
            bd.Append("         {\r\n");
            bd.Append("            var ss = arr[i].split(\",\");\r\n");
            bd.Append("            options[length] = new Option(ss[0], ss[1]);\r\n");
            bd.Append("            if(options[i].value==cityID)\r\n");
            bd.Append("               options[i].selected = true;\r\n");
            bd.Append("         }\r\n");
            bd.Append("      }\r\n");
            bd.Append("   };\r\n");
            bd.Append("   with(s3)\r\n");
            bd.Append("   {\r\n");
            bd.Append("      if(dsy.Exists(cityID))\r\n");
            bd.Append("      {\r\n");
            bd.Append("         arr = dsy.Items[cityID];\r\n");
            bd.Append("         for(i=0;i<arr.length;i++)\r\n");
            bd.Append("         {\r\n");
            bd.Append("            var ss = arr[i].split(\",\");\r\n");
            bd.Append("            options[length] = new Option(ss[0], ss[1]);\r\n");
            bd.Append("            if(options[i].value==CountyID)\r\n");
            bd.Append("               options[i].selected = true;\r\n");
            bd.Append("         }\r\n");
            bd.Append("      }\r\n");
            bd.Append("   }\r\n");
            bd.Append("}\r\n");
            String str = bd.ToString();
            return str;
        }







    }
}