﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
namespace nspBase
{
    /// <summary>
    /// MemberBasePge 的摘要说明
    /// </summary>
    public class MemberBasePge:System.Web.UI.Page
    {
        public MemberBasePge()
        {

        }


        /// <summary>
        /// 检测用户是否登陆系统和Cookies是否过时
        /// </summary>
        /// <param name="strName">用户名</param>
        /// <param name="strPas">密码</param>
        /// <param name="GradeI">等级</param>
        /// <returns></returns>
        public static bool CheckCookies()
        {
            if (GetCookie("LoginName") != null && GetCookie("UserId") != null && GetCookie("GradeID") != null)
                return true;
            else
                return false;
        }


        /// <summary>
        /// 读取Cookies
        /// </summary>
        /// <param name="strName">Cookie 主键</param>
        /// <code>Cookie ck = new Cookie();</code>
        /// <code>ck.getCookie("主键");</code>
        public static string GetCookie(string strName)
        {
            HttpCookie Cookie = HttpContext.Current.Request.Cookies[strName];
            if (Cookie != null)
            {
                return Cookie.Value.ToString();
            }
            else
            {
                return null;
            }
        }


        /// <summary>
        /// 清除Cookies
        /// </summary>
        /// <param name="strName"></param>
        public static bool ClearCookie()
        {

            if (ClearCookie("LoginName") && ClearCookie("UserID") && ClearCookie("GradeID"))
                return true;
            else
                return false;
        }


        /// <summary>
        /// 清除Cookies
        /// </summary>
        /// <param name="strName"></param>
        public static bool ClearCookie(string strName)
        {
            HttpCookie cookie = HttpContext.Current.Request.Cookies[strName];
            if (cookie != null)
            {
                cookie.Value = null;
                cookie.Expires = DateTime.Now.AddDays(-1.0);
                cookie.Values.Clear();
                HttpContext.Current.Response.Cookies.Set(cookie);
            }
            return true;
        }


        /// <summary>
        /// 提示错误信息
        /// </summary>
        /// <param name="Str"></param>
        public static void ShowMessage(string Str)
        {
            HttpContext.Current.Response.Write("<script>alert(\"" + Str + "\"); history.go(-2); </script>");
        }


        /// <summary>
        /// 提示错误信息并转向
        /// </summary>
        /// <param name="Str"></param>
        /// <param name="Url"></param>
        public static void ShowMessage(string Str, string Url)
        {
            HttpContext.Current.Response.Write("<script>location = '" + Base.BasePage.Config.WebURL + "Member/Message.aspx?path=" + Url + "&msg=" + Str+"'</script>");
            //HttpContext.Current.Response.Redirect(Base.BasePage.Config.WebURL+ "Member/Message.aspx?path=" + Url + "&msg=" + Str);
        }

        /// <summary>
        /// 处理图片为绝对路径
        /// </summary>
        /// <param name="strImageURL"></param>
        /// <returns></returns>
        public static string ProcessAbsoluteUrl(string strImageURL)
        {
            string strURL = "";
            if (strImageURL != "")
            {

                strURL = strImageURL.Replace("~/", Base.BasePage.Config.WebURL).Replace("../../../", Base.BasePage.Config.WebURL).Replace("../../", Base.BasePage.Config.WebURL).Replace("../", Base.BasePage.Config.WebURL);
            }
            return strURL;
        }

        /// <summary>
        /// 处理图片路径
        /// </summary>
        /// <param name="strImageURL"></param>
        /// <returns></returns>
        public static string ProcessImageUrl(string strImageURL)
        {
            string strURL = "";
            if (strImageURL != "")
            {
                strURL = strImageURL.Replace("../../../", "~/").Replace("../../", "~/").Replace("../", "~/");
            }
            return strURL;
        }

    }
}
