﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;
namespace Base.Core
{
    /// <summary>
    /// 网站基本设置信息
    /// </summary>
    public class WebConfig
    {
        public WebConfig()
        { 
            Init();
        }

        #region Fields
        private string _WebURL = "http://localhost/";
        private string _WebLogo;
        private string _Template;
        private string _AdminFolder="admin";
        private string _Rewrite;
        private string _Imgfolder="img";
        private bool _isClosed;
        private string _ClosedMessage;
        private string _Encryption;
        private string _WebName;
        private bool _IsSecondUrl;
        /// <summary>
        /// 网站名称
        /// </summary>
        public string WebName
        {
            get
            {
                if (_WebName != "")
                    return _WebName;
                else
                    return "网胜科技";
            }
        }

        /// <summary>
        /// MD5-Salt
        /// </summary>
        public string Encryption
        {
            get { return _Encryption; }
        }

        /// <summary>
        /// 网站后台文件名
        /// </summary>
        public string AdminFolder 
        {
            get { return _AdminFolder; }
        }

        /// <summary>
        /// 网站LOGO
        /// </summary>
        public string WebLogo
        {
            set { _WebLogo = value; }
            get { return _WebLogo; }
        }

        /// <summary>
        /// 网站域名
        /// </summary>
        public string WebURL
        {
            set { _WebURL = value; }
            get { return _WebURL; }
        }

        /// <summary>
        /// 模板
        /// </summary>
        public string Template
        {
            get { return _Template; }
        }

        /// <summary>
        /// 伪静态后缀名
        /// </summary>
        public string Rewrite
        {
            set { _Rewrite = value; }
            get { return _Rewrite; }
        }

        /// <summary>
        /// 图片文件夹
        /// </summary>
        public string ImgFolder
        {
            get { return _Imgfolder; }
        }

        /// <summary>
        /// 网站关闭
        /// </summary>
        public bool isClosed
        {
            get { return _isClosed; }
        }

        /// <summary>
        /// 图片文件夹
        /// </summary>
        public string ClosedMessage
        {
            get { return _ClosedMessage; }
        }

        /// <summary>
        /// 启用二级域名
        /// </summary>
        public bool IsSecondUrl	
        {
            get { return _IsSecondUrl; }
        }



        #endregion Fields




        /// <summary>
        /// 初始化网站基本信息
        /// </summary>
        private void Init()
        {
            WebBasicInfo.TWebBasicInfo tw = new WebBasicInfo.TWebBasicInfo();
            WebBasicInfo.IWebBasicInfo iw = new WebBasicInfo.RWebBasicInfo();
             tw = iw.GateItem();
            _WebLogo = tw.WebLOGO; 
            _Rewrite = tw.Rewrite;
            _WebURL = tw.WebURL;
            //_WebURL = "http://localhost/";
            _isClosed =Convert.ToBoolean( tw.State);
            _ClosedMessage = tw.StopReadme;
            _Encryption = tw.Encryption;
            _WebName = tw.WebName;
            _IsSecondUrl = tw.isSecondURL;
        }

    }
}