﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// R_IndustryType 的摘要说明
/// </summary>
namespace Product
{
    public class RIndustryType : IIndustryType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IIndustryType 成员
        /// <summary>
        /// 添加行业分类信息
        /// </summary>
        /// <param name="eui">行业信息对象</param>
        /// <returns></returns>
        public int Insert(TIndustryType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               
                  
					new SqlParameter("@Type", eui.Type),
					new SqlParameter("@ToRelease", eui.ToRelease),
					new SqlParameter("@ID", eui.ID),
			        new SqlParameter("@Sequence", eui.Sequence)

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_IndustryType_ADD ", commandParameters);
        }
        /// <summary>
        /// 修改行业分类信息--暂时没做修改
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TIndustryType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Type", eui.Type),
                new SqlParameter("@Sequence", eui.Sequence)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_IndustryType_Update", commandParameters);
        }
        /// <summary>
        /// 更新排序字段
        /// </summary>
        /// <param name="paixu">排序字段id</param>
        /// <param name="lbid">主字段id</param>
        public int UpdateSequence(int paixu, int lbid)
        {
            string updataStr = "UPDATE  W_IndustryType SET Sequence=@Sequence where ID=@id";
            SqlParameter[] parms ={
            new SqlParameter("@ID",lbid),
            new SqlParameter("@Sequence",paixu)
            
            };
            return SqlHelper.ExecuteNonQuery(CommandType.Text, updataStr, parms);
        }
        /// <summary>
        /// 修改行业分类发布信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateToRelease(TIndustryType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                new SqlParameter("@ToRelease", eui.ToRelease)
			
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_IndustryType_UpdateToRelease", commandParameters);
        }
        /// <summary>
        /// 根据ID删除行业分类信息
        /// </summary>
        /// <param name="ID">行业类别ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_IndustryType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_IndustryType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到行业分类信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_IndustryType"), 
                new SqlParameter("@strOrder", "order by Sequence,ID asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据行业分类上级ID得到行业分类信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where SuperiorsID=" + ParamID),
                new SqlParameter("@strtableName", "W_IndustryType"), 
                new SqlParameter("@strOrder", "order by Sequence,ID asc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据父级ID字符串得到行业分类信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where Superiors in ( "+ ParamID+") order by SuperiorsFlag "),
                new SqlParameter("@strtableName", "W_IndustryType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        ///  根据 ID得到行业分类每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TIndustryType GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +Convert.ToInt32( id)), 
                new SqlParameter("@strTableName", "W_IndustryType"), 
                new SqlParameter("@strOrder", "") 
            };
            TIndustryType info = new TIndustryType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Type = reader["Type"].ToString();
                if (reader["ToRelease"].ToString() != "")
                {
                    info.ToRelease = Convert.ToBoolean(reader["ToRelease"].ToString());
                }
                if (reader["Sequence"].ToString() != "")
                {
                    info.Sequence = Convert.ToInt32(reader["Sequence"].ToString());
                }
                info.Superiors = reader["Superiors"].ToString();
            }
            return info;
        }
        #endregion
    }
}
