﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// R_Keywords 的摘要说明
/// </summary>
namespace Keywords
{
    public class RKeywords:IKeywords
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IKeywords 成员

        /// <summary>
        /// 添加热门关键词
        /// </summary>
        /// <param name="eui">热门关键词对象</param>
        /// <returns></returns>
        public int Insert(TKeywords eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@Name", eui.Name),
					new SqlParameter("@Type", eui.Type),
					new SqlParameter("@Count",eui.Count),
					new SqlParameter("@IsCommend", eui.IsCommend),
                    new SqlParameter("@EditDate", eui.EditDate)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Keyword_Add", commandParameters);
        }
        /// <summary>
        /// 修改热门关键词
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TKeywords eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Name", eui.Name),
                    new SqlParameter("@Count",eui.Count),
					new SqlParameter("@IsCommend", eui.IsCommend),
                    new SqlParameter("@EditDate", eui.EditDate)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Keyword_Update", commandParameters);
        }
        /// <summary>
        /// 修改推荐信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateReCommend(TKeywords eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@IsCommend", eui.IsCommend)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Keyword_UpdateRecommend", commandParameters);
        }
        /// <summary>
        /// 根据ID删除热门关键词 
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Keyword") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有热门关键词
        /// </summary>
        /// <returns></returns>

        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "W_Keyword"), 
                new SqlParameter("@strOrder", " order by EditDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据strWhere得到所有热门关键词
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", strWhere),
                new SqlParameter("@strtableName", "W_Keyword"), 
                new SqlParameter("@strOrder", " order by EditDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到所有热门关键词每一条信息
        /// </summary>
        /// <param name="ID">求购ID</param>
        /// <returns></returns>
        public TKeywords GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_Keyword"), 
                new SqlParameter("@strOrder", "") 
            };
            TKeywords info = new TKeywords();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                info.Type = reader["Type"].ToString();
                if (reader["Count"].ToString() != "")
                {
                    info.Count = Convert.ToInt32(reader["Count"].ToString());
                }
                if (reader["IsCommend"].ToString() != "")
                {
                    info.IsCommend = Convert.ToBoolean(reader["IsCommend"].ToString());
                }
                if (reader["IsStatic"].ToString() != "")
                {
                    info.IsStatic = Convert.ToBoolean(reader["IsStatic"].ToString());
                }
                if (reader["EditDate"].ToString() != "")
                {
                    info.EditDate = Convert.ToDateTime(reader["EditDate"].ToString());
                }
            }
            return info;
        }
        #endregion

    }
}
