﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// R_Links 的摘要说明
/// </summary>
namespace Links
{
    public class RLinks : ILinks
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region ILinks 成员
        /// <summary>
        /// 添加友情链接
        /// </summary>
        /// <param name="eui">友情链接对象</param>
        /// <returns></returns>
        public int Insert(TLinks eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               
                    new SqlParameter("@LinkType", eui.LinkType),
					new SqlParameter("@WebName", eui.WebName),
					new SqlParameter("@WebURL", eui.WebURL),
					new SqlParameter("@WebLOGO", eui.WebLOGO),
					new SqlParameter("@WebIntro", eui.WebIntro),
					new SqlParameter("@WebAdmin", eui.WebAdmin),
					new SqlParameter("@Email", eui.Email),
					new SqlParameter("@Verify", eui.Verify),
					new SqlParameter("@Sequence", eui.Sequence),

               

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Links_Add", commandParameters);
        }
        /// <summary>
        /// 修改友情链接
        /// </summary>
        /// <param name="eui">友情链接对象<</param>
        /// <returns></returns>
        public int Update(TLinks eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("ID",eui.ID),
                    new SqlParameter("@LinkType", eui.LinkType),
					new SqlParameter("@WebName", eui.WebName),
					new SqlParameter("@WebURL", eui.WebURL),
					new SqlParameter("@WebLOGO", eui.WebLOGO),
					new SqlParameter("@WebIntro", eui.WebIntro),
					new SqlParameter("@WebAdmin", eui.WebAdmin),
					new SqlParameter("@Email", eui.Email),
					new SqlParameter("@Sequence", eui.Sequence)

             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Links_Update", commandParameters);
        }
        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TLinks eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Links_UpdateVerify", commandParameters);
        }

        /// <summary>
        /// 根据ID删除友情链接
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Links") 
            };
            try
            {
                // if (!GateItem(ID).WebLOGO.ToString().Contains("wutu.gif"))
                //{ 
                //ThumNail.FileDelete(GateItem(ID).WebLOGO.ToString());
                //}
            }
            catch { }
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有友情链接
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName","W_Links"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据链接类型得到友情链接
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TLinks eui)
        {
            string str = "where 1=1 ";
            if (eui.WebName != "")
                str += " and WebName like '%" + eui.WebName + "%'";
            if (eui.LinkType != 3)
                str += " and LinkType='" + eui.LinkType + "'";
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "W_Links"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到友情链接每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TLinks GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_Links"), 
                new SqlParameter("@strOrder", "") 
            };
            TLinks info = new TLinks();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["LinkType"].ToString() != "")
                {
                    info.LinkType = int.Parse(reader["LinkType"].ToString());
                }
                info.WebName = reader["WebName"].ToString();
                info.WebURL = reader["WebURL"].ToString();
                info.WebLOGO = reader["WebLOGO"].ToString();
                info.WebIntro = (reader["WebIntro"].ToString());
                info.WebAdmin = reader["WebAdmin"].ToString();
                info.Email = reader["Email"].ToString();
                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToBoolean(reader["Verify"].ToString());
                }
                info.Sequence = reader["Sequence"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}
