﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_Manager 的摘要说明
/// </summary>
namespace AdminRights
{
    public class RManager : IManager
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IManager 成员
        /// <summary>
        /// 添加网站管理员
        /// </summary>
        /// <param name="eui">网站管理员对象</param>
        /// <returns></returns>
        public int Insert(TManager eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
				new SqlParameter("@ManagerName", eui.ManagerName),
				new SqlParameter("@PassWord", eui.PassWord),
				new SqlParameter("@RoleID", eui.RoleID),
				new SqlParameter("@Lockedup", eui.Lockedup)
	
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Manager_Add", commandParameters);
        }
        /// <summary>
        /// 修改网站管理员
        /// </summary>
        /// <param name="eui">网站管理员对象<</param>
        /// <returns></returns>
        public int Update(TManager eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
 					new SqlParameter("@ManagerName", eui.ManagerName),
					new SqlParameter("@PassWord", eui.PassWord),
					new SqlParameter("@RoleID", eui.RoleID),
					new SqlParameter("@Lockedup", eui.Lockedup)

            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Manager_Update", commandParameters);
        }
        /// <summary>
        /// 修改网站管理员IP和最后登录时间信息
        /// </summary>
        /// <param name="eui">网站管理员对象<</param>
        /// <returns></returns>
        public int UpdateIP(TManager eui,int Flag,string name)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
 					new SqlParameter("@LastIP", eui.LastIP),
					new SqlParameter("@LastDate", eui.LastDate),
                    new SqlParameter("@Flag", Flag),
                    new SqlParameter("@ManagerName",name)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Manager_UpdateIP", commandParameters);
        }
        /// <summary>
        /// 修改锁定信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateLockedup(TManager eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Lockedup", eui.Lockedup)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Manager_UpdateLocked", commandParameters);
        }
        /// <summary>
        /// 根据ID删除网站管理员
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Manager") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到网站管理员
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "W_Manager"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据strWhere条件得到网站管理员
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strSelect"," W_Manager.*,W_Role.RoleName "),
                new SqlParameter("@strwhere",strWhere),
                new SqlParameter("@strtableName", " W_Manager left join W_Role on W_Manager.RoleID=W_Role.ID"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据管理员名和密码得到管理员信息
        /// </summary>
        /// <param name="LoginName"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string Name, string Password)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ManagerName='" + Name + "'and Password='" + Password +"'"), 
                new SqlParameter("@strtableName", "W_Manager"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        
        /// <summary>
        /// 根据ID取得网站管理员每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TManager GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_Manager"), 
                new SqlParameter("@strOrder", "") 
            };
            TManager info = new TManager();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.ManagerName = reader["ManagerName"].ToString();
                info.PassWord = reader["PassWord"].ToString();
                if (reader["RoleID"].ToString() != "")
                {
                    info.RoleID = Convert.ToInt32(reader["RoleID"].ToString());
                }
                if (reader["RoleID"].ToString() != "")
                {
                    info.Lockedup = Convert.ToBoolean(reader["Lockedup"].ToString());
                }
                info.LastIP = reader["LastIP"].ToString();
                if (reader["LastDate"].ToString() != "")
                {
                    info.LastDate = Convert.ToDateTime(reader["LastDate"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
            }
            return info;
        }
        #endregion
    }
}
