﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_ManagerCount 的摘要说明
/// </summary>
namespace AdminRights
{
    public class RManagerCount:IManagerCount
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IManagerCount 成员
        /// <summary>
        /// 删除管理员后台日志
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_ManagerCount") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到网站管理员后台日志
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "W_ManagerCount"), 
                new SqlParameter("@strOrder", " order by ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 取得一条数据信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TManagerCount GateItem(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", strWhere), 
                new SqlParameter("@strTableName", "W_ManagerCount"), 
                new SqlParameter("@strOrder"," order by LastDate desc") 
            };
            TManagerCount info = new TManagerCount();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                if (reader["IP"].ToString() != "" && reader["IP"] != null)
                    info.IP = reader["IP"].ToString();
                else
                    info.IP = Base.GetRequest.GetIP();
                if (reader["StartDate"].ToString() != "")
                    info.StartDate = Convert.ToDateTime(reader["StartDate"].ToString());
                if (reader["LastDate"].ToString() != "" && reader["LastDate"] != null)
                    info.LastDate = Convert.ToDateTime(reader["LastDate"].ToString());
                else
                    info.LastDate = DateTime.Now;
                if (reader["SuccessCount"].ToString() != "")
                    info.SuccessCount = Convert.ToInt32(reader["SuccessCount"].ToString());
                if (reader["DefeatCount"].ToString() != "")
                    info.DefeatCount = Convert.ToInt32(reader["DefeatCount"].ToString());
                info.ManagerName = reader["ManagerName"].ToString();

            }
            return info;
        }
        #endregion
    }
}
