﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// RRole 的摘要说明
/// </summary>
namespace AdminRights
{


    /// <summary>
    /// 网站角色接口实现
    /// </summary>
    public class RRole:IRole
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IRole 成员

        /// <summary>
        /// 添加网站角色
        /// </summary>
        /// <param name="eui">网站角色对象</param>
        /// <returns></returns>
        public int Insert(TRole eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                new SqlParameter("@RoleName",eui.RoleName),
				new SqlParameter("@Basic", eui.Basic),
				new SqlParameter("@Column", eui.Column),
				new SqlParameter("@User", eui.User),
				new SqlParameter("@Template", eui.Template),
				new SqlParameter("@System", eui.System),
                new SqlParameter("@Describe",eui.Describe)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Role_Add", commandParameters);
        }


        /// <summary>
        /// 修改网站角色
        /// </summary>
        /// <param name="eui">网站角色对象<</param>
        /// <returns></returns>
        public int Update(TRole eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID",eui.ID),
                new SqlParameter("@RoleName",eui.RoleName),
				new SqlParameter("@Basic", eui.Basic),
				new SqlParameter("@Column", eui.Column),
				new SqlParameter("@User", eui.User),
				new SqlParameter("@Template", eui.Template),
				new SqlParameter("@System", eui.System),
                new SqlParameter("@Describe",eui.Describe)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Role_Update", commandParameters);
        }


        /// <summary>
        /// 修改禁用设置
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TRole eui)
        {
            int IsUse = 0;
            if (eui.Authorize)
            {
                IsUse = 1;
            }
            else
            {
                IsUse = 0;
            }
            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@strTableName", "W_Role"), 

                new SqlParameter("@strData", "Authorize="+IsUse+""), 
                new SqlParameter("@strWhere", "ID="+eui.ID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_P_UpdateByWhere", param);         
        }


        /// <summary>
        /// 根据ID删除网站角色
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            int Result = 0;
            if (deleteManager(ID))
            {
                SqlParameter[] param = new SqlParameter[] 
                {
                    new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                    new SqlParameter("@strTableName", "W_Role") 
                };
                Result= SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
            }
            return Result;
        }


        /// <summary>
        /// 删除相应角色下的管理员
        /// </summary>
        /// <param name="RoleID">角色ID</param>
        /// <returns></returns>
        private bool deleteManager(int RoleID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where RoleID =" + RoleID), 
                new SqlParameter("@strTableName", "W_Manager") 
            };
            SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
            return true;
        }

        /// <summary>
        /// 根据属性得到网站角色信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
           SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "W_Role"), 
                new SqlParameter("@strOrder", " order by ID asc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }


        /// <summary>
        /// 根据ID取得网站角色每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TRole GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_Role"), 
                new SqlParameter("@strOrder", "") 
            };
            TRole info = new TRole();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.RoleName = reader["RoleName"].ToString();
                info.Basic = reader["Basic"].ToString();
                info.Column = (reader["Column"].ToString());
                info.User = reader["User"].ToString();
                info.Template = reader["Template"].ToString();
                info.System = reader["System"].ToString();
                info.Describe = reader["Describe"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
                
            }
            return info;
        }

        #endregion
    }


}
