﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// T_Role 的摘要说明
/// </summary>
namespace AdminRights
{

    /// <summary>
    ///  网站角色接口
    /// </summary>
    public interface IRole
    {
        int Insert(TRole us);                             //添加网站角色
        int Update(TRole us);                             //修改网站角色
        int UpdateVerify(TRole eui);                      //修改审核
        int Delete(int ID);                               //根据ID删除网站角色
        DataTable GetDataTable();                         //根据属性得到网站角色信息
        TRole GetItem(int ID);                           //根据ID取得网站角色每一条信息
    }


    /// <summary>
    /// 网站角色属性
    /// </summary>
    public class TRole
    {
        #region Model
        private int _id;
        private string _rolename;
        private string _basic;
        private string _column;
        private string _user;
        private string _template;
        private string _system;
        private bool _authorize; 
        private string _describe;
        private DateTime _adddate;
    

        /// <summary>
        /// 角色ID
        /// </summary>
        public int ID
        {
            set { _id = value; }
            get { return _id; }
        }

        /// <summary>
        /// 角色名称
        /// </summary>
        public string RoleName
        {
            set { _rolename = value; }
            get { return _rolename; }
        }

        /// <summary>
        /// 常规管理
        /// </summary>
        public string Basic
        {
            set { _basic = value; }
            get { return _basic; }
        }

        /// <summary>
        /// 栏目管理
        /// </summary>
        public string Column
        {
            set { _column = value; }
            get { return _column; }
        }


        /// <summary>
        /// 会员管理
        /// </summary>
        public string User
        {
            set { _user = value; }
            get { return _user; }
        }

        /// <summary>
        /// 模板风格
        /// </summary>
        public string Template
        {
            set { _template = value; }
            get { return _template; }
        }

        /// <summary>
        /// 系统设置
        /// </summary>
        public string System
        {
            set { _system = value; }
            get { return _system; }
        }

        /// <summary>
        /// 描述
        /// </summary>
        public string Describe
        {
            set { _describe = value; }
            get { return _describe; }
        }

        /// <summary>
        /// 是否禁用
        /// </summary>
        public bool Authorize
        {
            set { _authorize = value; }
            get { return _authorize; }
        }

        /// <summary>
        /// 加入日期
        /// </summary>
        public DateTime AddDate
        {
            set { _adddate = value; }
            get { return _adddate; }
        }
        #endregion Model
    }
}
