﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;
namespace Solely
{
    /// <summary>
    /// Registr 的摘要说明
    /// </summary>
    public class UserRegistr
    {
        public UserRegistr()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }

        private bool _isRegister=false;
        private bool _ManageRegister=false;
        private int _VipGrade=0;
        private bool _isCode=false;
        private bool _isQuestion=false;
        private string _Question="";
        private string _Answer="";
        private string _BannedIP="";
        private string _BannedUser="";
        private bool _Code_Login=false;
        private bool _Code_GetPass=false;
        private int _GetPass_Count=0;
        private int _Minimum=0;
        private int _Longest=0;
        private int _MinTimeRegister=0;
        private int _Gocipher_Method=0;
        private bool _OnlyUser_Email=false;
        private bool _ToMessage=false;
        private string _MessageInfo="";
        private bool _ToEmail=false;
        private string _EmailInfo="";
        private string _MessageTitle = "";
        private string _EmailTitle = "";

        /// <summary>
        /// 是否允许注册
        /// </summary>
        public bool isRegister
        {
            set { _isRegister = value; }
            get { return _isRegister; }
        }

        /// <summary>
        ///  是否需要审核
        /// </summary>
        public bool ManageRegister
        {
            set { _ManageRegister = value; }
            get { return _ManageRegister; }
        }

        /// <summary>
        /// 默认的注册等级
        /// </summary>
        public int VipGrade
        {
            set { _VipGrade = value; }
            get { return _VipGrade; }
        }

        /// <summary>
        /// 是否启用验证码
        /// </summary>
        public bool isCode
        {
            set { _isCode = value; }
            get { return _isCode; }
        }

        /// <summary>
        /// 是否启用验证问题
        /// </summary>
        public bool isQuestion
        {
            set { _isQuestion = value; }
            get { return _isQuestion; }
        }

        /// <summary>
        /// 验证问题
        /// </summary>
        public string Question
        {
            set { _Question = value; }
            get { return _Question; }
        }

        /// <summary>
        /// 验证答案
        /// </summary>
        public string Answer
        {
            set { _Answer = value; }
            get { return _Answer; }
        }

        /// <summary>
        /// 非法IP 
        /// </summary>
        public string BannedIP
        {
            set { _BannedIP = value; }
            get { return _BannedIP; }
        }

        /// <summary>
        /// 不允许注册的会员名 
        /// </summary>
        public string BannedUser
        {
            set { _BannedUser = value; }
            get { return _BannedUser; }
        }

        /// <summary>
        /// 会员登陆是否需要验证码
        /// </summary>
        public bool Code_Login
        {
            set { _Code_Login = value; }
            get { return _Code_Login; }
        }

        /// <summary>
        /// 取回密码是否需要验证码
        /// </summary>
        public bool Code_GetPass
        {
            set { _Code_GetPass = value; }
            get { return _Code_GetPass; }
        }

        /// <summary>
        ///  取回密码的次数
        /// </summary>
        public int GetPass_Count
        {
            set { _GetPass_Count = value; }
            get { return _GetPass_Count; }
        }

        /// <summary>
        /// 用户名最小长度 
        /// </summary>
        public int Minimum
        {
            set { _Minimum = value; }
            get { return _Minimum; }
        }

        /// <summary>
        /// 用户名最长长度 
        /// </summary>
        public int Longest
        {
            set { _Longest = value; }
            get { return _Longest; }
        }

        /// <summary>
        ///  同一IP注册用户名的间隔时间 
        /// </summary>
        public int MinTimeRegister
        {
            set { _MinTimeRegister = value; }
            get { return _MinTimeRegister; }
        }


        /// <summary>
        /// 取回密码的方法 
        /// </summary>
        public int Gocipher_Method
        {
            set { _Gocipher_Method = value; }
            get { return _Gocipher_Method; }
        }

        /// <summary>
        /// 一个邮箱是否只能注册一个用户
        /// </summary>
        public bool OnlyUser_Email
        {
            set { _OnlyUser_Email = value; }
            get { return _OnlyUser_Email; }
        }

        /// <summary>
        /// 注册成功是否发送短信 
        /// </summary>
        public bool ToMessage
        {
            set { _ToMessage = value; }
            get { return _ToMessage; }
        }

        /// <summary>
        /// 短信内容
        /// </summary>
        public string MessageInfo
        {
            set { _MessageInfo = value; }
            get { return _MessageInfo; }
        }

        /// <summary>
        /// 注册成功是否发送邮件 
        /// </summary>
        public bool ToEmail
        {
            set { _ToEmail = value; }
            get { return _ToEmail; }
        }

        /// <summary>
        /// 邮件内容
        /// </summary>
        public string EmailInfo
        {
            set { _EmailInfo = value; }
            get { return _EmailInfo; }
        }
        /// <summary>
        /// 短信标题
        /// </summary>
        public string MessageTitle 
        {
            set { _MessageTitle = value; }
            get { return _MessageTitle; }
        }
        /// <summary>
        /// 邮件标题
        /// </summary>
        public string EmailTitle 
        {
            set { _EmailTitle = value; }
            get { return _EmailTitle; }
        }
        /// <summary>
        ///  取得注册设置信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static UserRegistr GateItem()
        {
            SqlParameter[] param = new SqlParameter[] { 
           new SqlParameter("@strWhere",""), new SqlParameter("@strTableName", "U_Register"),   new SqlParameter("@strOrder", "") 
        };
            UserRegistr info = new UserRegistr();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                    return info;
                info.isRegister = Convert.ToBoolean(reader["isRegister"].ToString());
                info.ManageRegister = Convert.ToBoolean(reader["ManageRegister"].ToString());
                info.VipGrade = Convert.ToInt16(reader["VipGrade"].ToString());
                info.isCode = Convert.ToBoolean(reader["isCode"].ToString());
                info.isQuestion = Convert.ToBoolean(reader["isQuestion"].ToString());
                info.Question = reader["Question"].ToString();
                info.Answer = reader["Answer"].ToString();
                info.BannedIP = reader["BannedIP"].ToString();
                info.BannedUser = reader["bannedUser"].ToString();
                info.Code_Login = Convert.ToBoolean(reader["Code_Login"].ToString());
                info.Code_GetPass = Convert.ToBoolean(reader["Code_GetPass"].ToString());
                info.GetPass_Count = Convert.ToInt32(reader["GetPass_Count"].ToString());
                info.Minimum = Convert.ToInt32(reader["Minimum"].ToString());
                info.Longest = Convert.ToInt32(reader["Longest"].ToString());
                info.MinTimeRegister = Convert.ToInt32(reader["MinTimeRegister"].ToString());
                info.Gocipher_Method = Convert.ToInt32(reader["Gocipher_Method"].ToString());
                info.OnlyUser_Email = Convert.ToBoolean(reader["OnlyUser_Email"].ToString());
                info.ToMessage = Convert.ToBoolean(reader["ToMessage"].ToString());
                info.MessageInfo = reader["MessageInfo"].ToString();
                info.ToEmail = Convert.ToBoolean(reader["ToEmail"].ToString());
                info.EmailInfo = reader["EmailInfo"].ToString();
                info.MessageTitle = reader["MessageTitle"].ToString();
                info.EmailTitle = reader["EmailTitle"].ToString();
            }
            return info;
        }


        /// <summary>
        /// 修改会员注册设置
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(UserRegistr ui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {   
                new SqlParameter("@isRegister", ui.isRegister),
				new SqlParameter("@ManageRegister",ui.ManageRegister),
				new SqlParameter("@VipGrade",ui.VipGrade),
				new SqlParameter("@isQuestion",ui.isQuestion),
				new SqlParameter("@Question",ui.Question),
				new SqlParameter("@Answer",ui.Answer),
				new SqlParameter("@BannedIP",ui.BannedIP),
				new SqlParameter("@BannedUser",ui.BannedUser),
				new SqlParameter("@Code_Login",ui.Code_Login),
				new SqlParameter("@Code_GetPass",ui.Code_GetPass),
				new SqlParameter("@GetPass_Count",ui.GetPass_Count),
				new SqlParameter("Minimum ",ui.Minimum),
				new SqlParameter("@Longest",ui.Longest),
				new SqlParameter("@MinTimeRegister",ui.MinTimeRegister),
    			new SqlParameter("@Gocipher_Method",ui.Gocipher_Method),
				new SqlParameter("@OnlyUser_Email",ui.OnlyUser_Email),
    			new SqlParameter("@ToMessage",ui.ToMessage),
				new SqlParameter("@MessageInfo",ui.MessageInfo),
            	new SqlParameter("@ToEmail",ui.ToEmail),
				new SqlParameter("@EmailInfo",ui.EmailInfo),
                new SqlParameter("@IsCode",ui.isCode),
                new SqlParameter("@MessageTitle",ui.MessageTitle),
                new SqlParameter("@EmailTitle",ui.EmailTitle)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_Register_Update", commandParameters);
        }


        /// <summary>
        /// 检测同一IP时间间隔
        /// </summary>
        /// <returns></returns>
        public static int CheckIP(string strIP, out int intReturn)
        {
            SqlParameter[] commandParameters = new SqlParameter[]{
                new SqlParameter("@Return", SqlDbType.Int), 
                new SqlParameter("@IP", strIP),
          };
            intReturn = 0;
            commandParameters[0].Direction = ParameterDirection.Output;
            int ReRows= SqlHelper.ExecuteNonQuery("SP_U_RegisterIP_Check", commandParameters);
            if (ReRows >= 0)
                intReturn = (int)commandParameters[0].Value;
            return ReRows;
        }

        /// <summary>
        /// 检测同一IP时间间隔
        /// </summary>
        /// <returns></returns>
        public static int CheckIP(string strIP)
        {
            SqlParameter[] commandParameters = new SqlParameter[]{
                new SqlParameter("@IP", strIP),
            };
            int ReRows = SqlHelper.ExecuteNonQuery("SP_U_RegisterIP_Check", commandParameters);
            return ReRows;
        }
    }
}