﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using SqlOperate;
using System.Data.SqlClient;
using VipGrade;
using Base;
using System.IO;

namespace Solely
{
    /// <summary>
    /// other 的摘要说明
    /// </summary>
    public class Other
    {


        /// <summary>
        /// 取得发送Email需要的信息
        /// </summary>
        /// <param name="strType">类别</param>
        /// <param name="intUserID">会员ID</param>
        /// <returns>返回Email需要的信息</returns>
        public static DataTable GetEmailValue(string strType, int intUserID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                //new SqlParameter("@strTo", "") ,
                //new SqlParameter("@strTitle", "") ,
                //new SqlParameter("@strInfo", "") ,
                //new SqlParameter("@strFrom", "") ,
                //new SqlParameter("@strLoginName", "") ,
                //new SqlParameter("@strPassWord", "") ,
                //new SqlParameter("@strSMTP", "") ,
                new SqlParameter("@strType", strType), 
                new SqlParameter("@intUserID", intUserID) 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_P_GetEmailInfo", param);
        }


        /// <summary>
        /// 根据UserID更新UserOperate中的最后登陆时间和IP
        /// </summary>
        /// <param name="UserID">会员ID</param>
        /// <param name="strIP">会员登陆的IP</param>
        /// <returns>返回是否更新成功</returns>
        public static bool UserOperate_Update_login(int UserID, string strIP)
        {
            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@strTableName", "U_UserOperate"), 
                new SqlParameter("@strData", "LastLoginTime="+DateTime.Now.Date + " LastLoginIP='" + strIP + "' "), 
                new SqlParameter("@strWhere", "UserID="+UserID), 
            };
            int Reint = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_P_UpdateByWhere", param);
            if (Reint == 1)
                return true;
            else
                return false;
        }


        /// <summary>
        /// 检测用户是否还能发布商机
        /// </summary>
        /// <param name="VipGrade"></param>
        /// <returns>返回True能继续发布，返回False不能在发布</returns>
        public static bool CheckUserBussinessCount(int gradeid, string product, int userid)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
        
                new SqlParameter("@ManageRights",SqlDbType.NVarChar,10) ,
                new SqlParameter("@AddProduct", SqlDbType.Int) ,
                new SqlParameter("@ProductCount",SqlDbType.Int) ,
                new SqlParameter("@GradeID", gradeid),
                new SqlParameter("@Product", product),
                new SqlParameter("@UserID",  userid)
              
            };
            param[0].Direction = ParameterDirection.Output;
            param[1].Direction = ParameterDirection.Output;
            param[2].Direction = ParameterDirection.Output;
            SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_P_CheckBusinessCount", param);
            string ManageRights = param[0].Value.ToString();
            if (ManageRights.Equals("3"))
            {
                return true;
            }
            int AddProduct = 0, ProductCount = 0;
            if (param[1].Value.ToString() != "")
            {
                AddProduct = int.Parse(param[1].Value.ToString());
            }
            if (param[2].Value.ToString() != "")
            {
                ProductCount = int.Parse(param[2].Value.ToString());
            }
            if (ManageRights != "3")
            {
                if (ProductCount > AddProduct)
                    return true;
            }
            return false;
        }


        /// <summary>
        /// 检测用户发布的商机信息
        /// </summary>
        /// <param name="UnreadMessageCount">未读留言数量</param>
        /// <param name="PastDueCount">商机过期数量</param>
        /// <param name="PastDueCount">商机过期数量</param>
        /// <param name="UserID">用户ID</param>
        /// <returns></returns>
        public static int CheckUserProductCount(int UserID, out int UnreadMessageCount, out int PastDueCount, out int UnauditedCount)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
        
                
                new SqlParameter("@UnreadMessageCount", SqlDbType.Int) ,
                new SqlParameter("@PastDueCount",SqlDbType.Int) ,
                new SqlParameter("@UnauditedCount", SqlDbType.Int),
                new SqlParameter("@UserID",UserID) 
              
            };
            param[0].Direction = ParameterDirection.Output;
            param[1].Direction = ParameterDirection.Output;
            param[2].Direction = ParameterDirection.Output;
            int ReRows = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_P_CheckProductCount", param);
            UnreadMessageCount = (int)param[0].Value;
            PastDueCount = (int)param[1].Value;
            UnauditedCount = (int)param[2].Value;
            return ReRows;
        }


        /// <summary>
        /// 删除上传的图片
        /// </summary>
        /// <param name="path">图片的虚拟路径</param>
        /// <returns></returns>
        public static bool FileDelete(string path)
        {

            bool ret = false;
            path = BasePage.ProcessImageUrl(path);
            string url = HttpContext.Current.Server.MapPath(path);
            System.IO.FileInfo file = new System.IO.FileInfo(url);
            if (File.Exists(url))
            {
                file.Delete();
                ret = true;
            }

            return ret;
        }


        /// <summary>
        /// 网站后台首页获取统计信息
        /// </summary>
        /// <returns></returns>
        public static DataTable GetCount()
        {
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_P_SelectDatetoIndex", null);
        }


        /// <summary>
        /// 更新数据
        /// </summary>
        /// <param name="strTableName">表名</param>
        /// <param name="strDate">要更新的SQL语句</param>
        /// <param name="strWhere">条件</param>
        /// <returns>返回是否更新成功</returns>
        /// <example>UpOnlyDate("C_Supply", "Verify=3","id=1")</example>
        public static bool UpOnlyDate(string strTableName, string strData,string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] { 
                new SqlParameter("@strTableName", strTableName), 
                new SqlParameter("@strData", strData), 
                new SqlParameter("@strWhere", strWhere), 
            };
            int Reint = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_P_UpdateByWhere", param);
            if (Reint >= 1)
                return true;
            else
                return false;
        }

    }

}