﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// RTradeSettings 的摘要说明
/// </summary>
namespace TradeSettings
{
    public class RTradeSettings : ITradeSettings
    {
        #region ITradeSettings 成员
        /// <summary>
        /// 添加商业信息
        /// </summary>
        /// <param name="eui">商业信息对象</param>
        /// <returns></returns>
        public int Insert(TTradeSettings eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
					new SqlParameter("@TradeType",eui.TradeType),
					new SqlParameter("@isADD", eui.isADD),
					new SqlParameter("@isEdit", eui.isEmail),
					new SqlParameter("@Mark", eui.Mark),
					new SqlParameter("@isEmail", eui.isEmail),
					new SqlParameter("@EmailTitle", eui.EmailTitle),
					new SqlParameter("@EmailInfo", eui.EmailInfo),
					new SqlParameter("@isSMS", eui.isSMS),
					new SqlParameter("@SMSTitle", eui.SMSTitle),
					new SqlParameter("@SMSInfo", eui.SMSInfo)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_TradeSettings_Add", commandParameters);
        }
        /// <summary>
        /// 修改商业信息
        /// </summary>
        /// <param name="eui">商业信息对象<</param>
        /// <returns></returns>
        public int Update(TTradeSettings eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@TradeType",eui.TradeType),
					new SqlParameter("@isADD", eui.isADD),
					new SqlParameter("@isEdit", eui.isEdit),
					new SqlParameter("@Mark", eui.Mark),
					new SqlParameter("@isEmail", eui.isEmail),
					new SqlParameter("@EmailTitle", eui.EmailTitle),
					new SqlParameter("@EmailInfo", eui.EmailInfo),
					new SqlParameter("@isSMS", eui.isSMS),
					new SqlParameter("@SMSTitle", eui.SMSTitle),
					new SqlParameter("@SMSInfo", eui.SMSInfo)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_TradeSettings_Update", commandParameters);
        }

        /// <summary>
        /// 根据ID删除供应信息
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_TradeSettings") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到商业信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "W_TradeSettings"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到所有商业信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where UserID=" + ParamID),
                new SqlParameter("@strtableName", "W_TradeSettings"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到商业每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public TTradeSettings GateItem(string product)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where TradeType='"+product+"'"), 
                new SqlParameter("@strTableName", "W_TradeSettings"), 
                new SqlParameter("@strOrder", "") 
            };
            TTradeSettings info = new TTradeSettings();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.TradeType = reader["TradeType"].ToString();
                if (reader["isADD"].ToString() != "")
                {
                    info.isADD = Convert.ToBoolean(reader["isADD"].ToString());
                }
                if (reader["isEdit"].ToString() != "")
                {
                    info.isEdit = Convert.ToBoolean(reader["isEdit"].ToString());
                }
                if (reader["Mark"].ToString() != "")
                {
                    info.Mark = int.Parse(reader["Mark"].ToString());
                }
                if (reader["isEmail"].ToString() != "")
                {
                    info.isEmail = Convert.ToBoolean(reader["isEmail"].ToString());
                }
                info.EmailTitle = reader["EmailTitle"].ToString();
                info.EmailInfo = reader["EmailInfo"].ToString();
                if (reader["isSMS"].ToString() != "")
                {
                    info.isSMS = Convert.ToBoolean(reader["isSMS"].ToString());
                }
                info.SMSTitle = reader["SMSTitle"].ToString();
                info.SMSInfo = reader["SMSInfo"].ToString();
            }
            return info;
        }
        #endregion
    }
}
