﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;
/// <summary>
/// R_VipGrade 的摘要说明
/// </summary>
namespace VipGrade
{
    public class RVipGrade : IVipGrade
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IVIPGrade 成员

        /// <summary>
        /// 添加会员等级信息
        /// </summary>
        /// <param name="us">会员等级对象</param>
        /// <returns></returns>
        public int Insert(VipGrade.TVipGrade us)
        {

            SqlParameter[] commandParameters = new SqlParameter[] { 
                new SqlParameter("@Name",us.Name), 
                new SqlParameter("@Flag", us.Flag),
                new SqlParameter("@ServiceTime", us.ServiceTime),          
                new SqlParameter("@Price", us.Price), 
                new SqlParameter("@Register",us.Register), 
                new SqlParameter("@ShopTemplate",us.ShopTemplate) 
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_U_VipGrade_Add", commandParameters);

        }


        /// <summary>
        /// 修改会员等级信息
        /// </summary>
        /// <param name="us">会员等级对象</param>
        /// <returns></returns>
        public int Update(VipGrade.TVipGrade us)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            { 
                new SqlParameter("@ID",us.ID),
                new SqlParameter("@Name",us.Name), 
                new SqlParameter("@Flag", us.Flag),
                new SqlParameter("@ServiceTime", us.ServiceTime),          
                new SqlParameter("@Price", us.Price), 
                new SqlParameter("@Register",us.Register),
                new SqlParameter("@ShopTemplate",us.ShopTemplate) 
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_U_VipGrade_Update", commandParameters);

        }


        /// <summary>
        /// 修改会员等级权限
        /// </summary>
        /// <param name="us">会员等级对象</param>
        /// <returns></returns>
        public int UpdateRights(VipGrade.TVipGrade us)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            { 
                new SqlParameter("@ID",us.ID),
                new SqlParameter("@ManageRights",us.ManageRights), 
                new SqlParameter("@SupplyCount",us.SupplyCount), 
                new SqlParameter("@PurchaseCount", us.PurchaseCount),
                new SqlParameter("@ExpoCount", us.ExpoCount),          
                new SqlParameter("@SincereCount", us.SincereCount), 
                new SqlParameter("@WillCount",us.WillCount) 
            };
            return SqlHelper.ExecuteNonQuery( CommandType.StoredProcedure, "SP_U_VipGrade_UpdateRights", commandParameters);

        }

        /// <summary>
        /// 根据会员等级ID删除会员等级信息
        /// </summary>
        /// <param name="VipGradeID">会员等级ID</param>
        /// <returns></returns>
        public int Delete(int VipGradeID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + VipGradeID + ")"), 
                new SqlParameter("@strTableName", "U_VipGrade") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }


        /// <summary>
        /// 根据会员等级条件查询会员等级信息
        /// </summary>
        /// <param name="VipGrade"></param>
        /// <returns></returns>
        public DataSet GetDataTable(string VipGrade)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", VipGrade),
                new SqlParameter("@strTableName", "U_VipGrade"),
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteDataset(ConnectionString, CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }


        /// <summary>
        /// 根据会员等级ID得到会员等级信息
        /// </summary>
        /// <param name="GradeID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int GradeID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + GradeID.ToString()), 
                new SqlParameter("@strTableName", "U_VipGrade"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }


        /// <summary>
        /// 得到会员等级信息
        /// </summary>
        /// <returns></returns>
        public DataSet GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", ""), 
                new SqlParameter("@strtableName", "U_VipGrade"),
                new SqlParameter("@strOrder", " order by  Sort desc ") 
            };
            return SqlHelper.ExecuteDataset(ConnectionString, CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        #endregion


    }
}