﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;

/// <summary>
/// R_WebNews 的摘要说明
/// </summary>
namespace WebNews
{
    public class RWebNews : IWebNews
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IPostInfo 成员
        /// <summary>
        /// 添加网站信息
        /// </summary>
        /// <param name="eui">网站信息对象</param>
        /// <returns></returns>
        public int Insert(TWebNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
               	    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Type", eui.Type),
					new SqlParameter("@Attribute", eui.Attribute),
					new SqlParameter("@Picture", eui.Picture),
					new SqlParameter("@Origin", eui.Origin),
					new SqlParameter("@Detail", eui.Detail)

             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_WebNews_ADD ", commandParameters);
        }


        /// <summary>
        /// 修改网站信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TWebNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Type", eui.Type),
					new SqlParameter("@Attribute", eui.Attribute),
					new SqlParameter("@Picture", eui.Picture),
					new SqlParameter("@Origin", eui.Origin),
					new SqlParameter("@Detail", eui.Detail)
            };
            return SqlHelper.ExecuteNonQuery( CommandType.StoredProcedure, "SP_W_WebNews_Update", commandParameters);
        }


        /// <summary>
        /// 根据ID删除网站信息
        /// </summary>
        /// <param name="ID">行业类别ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_WebNews") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }


        /// <summary>
        /// 得到网站信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_WebNews"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }


        /// <summary>
        /// 根据标题,类别得到网站信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TWebNews eui)
        {
            string str = "where 1=1 ";
            if (eui.Title != "")
                str += " and Title like '%" + eui.Title + "%'";
            if (eui.Type != "所有类别")
                str += " and Type='" + eui.Type + "'";
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", str ),
                new SqlParameter("@strtableName", "W_WebNews"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }


        /// <summary>
        ///  根据ID得到网站分类每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TWebNews GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "W_WebNews"), 
                new SqlParameter("@strOrder", "") 
            };
            TWebNews info = new TWebNews();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Title = reader["Title"].ToString();
                info.Type = reader["Type"].ToString();
                info.Attribute = reader["Attribute"].ToString();
                info.Picture = reader["Picture"].ToString();
                info.Origin = reader["Origin"].ToString();
                info.Detail = reader["Detail"].ToString();
            }
            return info;
        }
        #endregion
    }
}
