﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// EmailStatistics 的摘要说明
/// </summary>
namespace nspEmail.Lables
{
    public class EmailStatistics
    {
        public EmailStatistics()
        {
            //
            // EmailStatistics 发送邮件统计表
            //        
        }
        #region Model
        private int _id;
        private int _userid;
        private string _state;
        private string _subscriptionType;
        private DateTime _addDate;
        private string _extend;

        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserId
        {
            get { return _userid; }
            set { _userid = value; }
        }
        /// <summary>
        /// 邮件发送状态
        /// </summary>
        public string State
        {
            get { return _state; }
            set { _state = value; }
        }
        /// <summary>
        /// 邮件发送类型
        /// </summary>
        public string SubscriptionType
        {
            get { return _subscriptionType; }
            set { _subscriptionType = value; }
        }
        /// <summary>
        /// 邮件发送时间
        /// </summary>
        public DateTime AddDate
        {
            get { return _addDate; }
            set { _addDate = value; }
        }
        /// <summary>
        /// 扩展字段
        /// </summary>
        public string Extend
        {
            get { return _extend; }
            set { _extend = value; }
        }
        #endregion Model

        #region EmailStatistics 成员
        /// <summary>
        /// 添加
        /// </summary>
        /// <param name="eui">发送邮件统计对象</param>
        /// <returns></returns>
        public int Insert(EmailStatistics eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@UserId", eui.UserId),
					new SqlParameter("@State", eui.State),
                    new SqlParameter("@SubscriptionType", eui.SubscriptionType),
                    new SqlParameter("@AddDate", eui.AddDate),
                    new SqlParameter("@Extend", eui.Extend)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_EmailStatistics_Add", commandParameters);
        }
        /// <summary>
        /// 修改
        /// </summary>
        /// <param name="eui">发送邮件统计对象<</param>
        /// <returns></returns>
        public int Update(EmailStatistics eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@UserId", eui.UserId),
					new SqlParameter("@State", eui.State),
                    new SqlParameter("@SubscriptionType", eui.SubscriptionType),
                    new SqlParameter("@AddDate", eui.AddDate),
                    new SqlParameter("@Extend", eui.Extend)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_EmailStatistics_Update", commandParameters);
        }
        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="ID">自增ID</param>
        /// <returns></returns> 
        public void Delete(int comId)
        {
            string sql = "delete from W_EmailStatistics where Id="+comId+"";
            SqlHelper.ExecuteNonQuery(sql);
        }
        #endregion
    }
}
