﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// EmailTemplate 的摘要说明
/// </summary>
namespace nspEmail
{
    public class EmailTemplate
    {
        public EmailTemplate()
        {

        }
        #region Model
        private int _id;
        private string _flag;
        private string _type;
        private bool _ishtml;
        private string _name;
        private string _title;
        private string _content;
        private DateTime _adddate;

        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// 标志
        /// </summary>
        public string Flag
        {
            get { return _flag; }
            set { _flag = value; }
        }
        /// <summary>
        /// 所属类别
        /// </summary>
        public string Type
        {
            get { return _type; }
            set { _type = value; }
        }
        /// <summary>
        /// 是否使用html
        /// </summary>
        public bool Ishtml
        {
            get { return _ishtml; }
            set { _ishtml = value; }
        }
        /// <summary>
        /// 邮件名称
        /// </summary>
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
        /// <summary>
        /// 邮件标题
        /// </summary>
        public string Title
        {
            get { return _title; }
            set { _title = value; }
        }
        /// <summary>
        /// 邮件内容
        /// </summary>
        public string Content
        {
            get { return _content; }
            set { _content = value; }
        }
        /// <summary>
        /// 添加日期
        /// </summary>
        public DateTime AddDate
        {
            get { return _adddate; }
            set { _adddate = value; }
        }
        #endregion Model

        #region EmailTemplate 成员
        /// <summary>
        /// 添加邮件模版
        /// </summary>
        /// <param name="eui">邮件模版对象</param>
        /// <returns></returns>
        public int Insert(EmailTemplate eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@Flag", eui.Flag),
                    new SqlParameter("@Type",eui.Type),
					new SqlParameter("@Name", eui.Name),
                    new SqlParameter("@Title", eui.Title),
                    new SqlParameter("@Content", eui.Content),
                    new SqlParameter("@Ishtml", eui.Ishtml),
			        new SqlParameter("@AddDate",eui.AddDate)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_EmailTemplate_Add", commandParameters);
        }
        /// <summary>
        /// 修改邮件模版
        /// </summary>
        /// <param name="eui">公司邮件模版<</param>
        /// <returns></returns>
        public int Update(EmailTemplate eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Flag", eui.Flag),
                    new SqlParameter("@Type",eui.Type),
					new SqlParameter("@Name", eui.Name),
                    new SqlParameter("@Title", eui.Title),
                    new SqlParameter("@Content", eui.Content),
                    new SqlParameter("@Ishtml", eui.Ishtml),
			        new SqlParameter("@AddDate",eui.AddDate)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_EmailTemplate_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除邮件模版
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_EmailTemplate") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有邮件模版
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","W_EmailTemplate"), 
                new SqlParameter("@strOrder", " order by ID asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到邮件模版每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public EmailTemplate GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_EmailTemplate"), 
                new SqlParameter("@strOrder", "") 
            };
            EmailTemplate info = new EmailTemplate();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.Type = reader["Type"].ToString();
                info.Flag = reader["Flag"].ToString();
                info.Name = reader["Name"].ToString();
                info.Title = reader["Title"].ToString();
                info.Content = reader["Content"].ToString();
                if (reader["Ishtml"].ToString() != "")
                {
                    info.Ishtml = Convert.ToBoolean(reader["Ishtml"].ToString());
                }
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}
