﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

namespace Email.Subscription
{
    /// <summary>
    /// SubscriptionEmail 的摘要说明
    /// </summary>
    public class SubscriptionEmail
    {
        public SubscriptionEmail()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region SubscriptionEmail属性
        private int _id;
        private int _userid;
        private string _email;
        private DateTime _adddate;
        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email
        {
            get { return _email; }
            set { _email = value; }
        }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserID
        {
            get { return _userid; }
            set { _userid = value; }
        }
        /// <summary>
        /// 添加日期
        /// </summary>
        public DateTime AddDate
        {
            get { return _adddate; }
            set { _adddate = value; }
        }
        #endregion
        #region SubscriptionEmail 成员
        /// <summary>
        /// 添加订阅商机邮箱
        /// </summary>
        /// <param name="eui">订阅商业资讯对象</param>
        /// <returns></returns>
        public int Insert(SubscriptionEmail eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {       
                    new SqlParameter("UserID",UserID),
                    new SqlParameter("@Email", eui.Email)
  
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_SubscriptionEmail_Add", commandParameters);
        }
        /// <summary>
        /// 修改订阅商机邮箱
        /// </summary>
        /// <param name="eui">订阅商业资讯对象<</param>
        /// <returns></returns>
        public int Update(SubscriptionEmail eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("UserID",UserID),
                    new SqlParameter("@Email", eui.Email)

            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_SubscriptionEmail_Update", commandParameters);
        }

        /// <summary>
        /// 根据ID删除订阅商机邮箱
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "U_SubscriptionEmail") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有订阅商机邮箱
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","U_SubscriptionEmail"), 
                new SqlParameter("@strOrder", " order by AddDate asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到订阅商机邮箱每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public SubscriptionEmail GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "U_SubscriptionEmail"), 
                new SqlParameter("@strOrder", "") 
            };
            SubscriptionEmail info = new SubscriptionEmail();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Email = reader["Email"].ToString();
                if (info.AddDate.ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}