﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

namespace Email.Subscription
{
    /// <summary>
    /// SubscriptionNews 的摘要说明
    /// </summary>
    public class SubscriptionNews
    {
        public SubscriptionNews()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region SubscriptionNews属性
        private int _id;
        private string _type;
        private int _userid;
        private DateTime _adddate;
        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// 信息类型
        /// </summary>
        public string Type
        {
            get { return _type; }
            set { _type = value; }
        }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserID
        {
            get { return _userid; }
            set { _userid = value; }
        }
        /// <summary>
        /// 添加提起
        /// </summary>
        public DateTime AddDate
        {
            get { return _adddate; }
            set { _adddate = value; }
        }
        #endregion
        #region SubscriptionNews 成员
        /// <summary>
        /// 添加订阅商业资讯
        /// </summary>
        /// <param name="eui">订阅商业资讯对象</param>
        /// <returns></returns>
        public int Insert(SubscriptionNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {       
                    new SqlParameter("UserID",UserID),
                    new SqlParameter("@Type", eui.Type)
  
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_SubscriptionNews_Add", commandParameters);
        }
        /// <summary>
        /// 修改订阅商机
        /// </summary>
        /// <param name="eui">订阅商业资讯对象<</param>
        /// <returns></returns>
        public int Update(SubscriptionNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
               new SqlParameter("@ID",eui.ID),
               new SqlParameter("@Type", eui.Type),

            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_SubscriptionNews_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除订阅商业资讯
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "U_SubscriptionNews") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据UserID删除订阅商业资讯
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(string UserID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where UserID in (" + UserID + ")"), 
                new SqlParameter("@strTableName", "U_SubscriptionNews") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有订阅商业资讯
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","U_SubscriptionNews"), 
                new SqlParameter("@strOrder", " order by AddDate asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到订订阅商业资讯每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public SubscriptionNews GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "U_SubscriptionNews"), 
                new SqlParameter("@strOrder", "") 
            };
            SubscriptionNews info = new SubscriptionNews();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Type = reader["Type"].ToString();
                if (info.AddDate.ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}