﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

namespace Email.Subscription
{
    /// <summary>
    /// SubscriptionProduct 的摘要说明
    /// </summary>
    public class SubscriptionProduct
    {
        public SubscriptionProduct()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region SubscriptionProduct属性
        private int _id;
        private int _userid;
        private string _type;
        private string _keyword;
        private string _indtype;
        private string _area;
        private DateTime _adddate;
        private int _validity;
        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserID
        {
            get { return _userid; }
            set { _userid = value; }
        }
        /// <summary>
        /// 类别
        /// </summary>
        public string Type
        {
            get { return _type; }
            set { _type = value; }
        }
        /// <summary>
        /// 关键字
        /// </summary>
        public string Keyword
        {
            get { return _keyword; }
            set { _keyword = value; }
        }
        /// <summary>
        /// 产品所属类目
        /// </summary>
        public string Indtype
        {
            get { return _indtype; }
            set { _indtype = value; }
        }
        /// <summary>
        /// 地区
        /// </summary>
        public string Area
        {
            get { return _area; }
            set { _area = value; }
        }
        /// <summary>
        /// 添加日期
        /// </summary>
        public DateTime AddDate
        {
            get { return _adddate; }
            set { _adddate = value; }
        }
        /// <summary>
        /// 发布有效期天数
        /// </summary>
        public int Validity
        {
            get { return _validity; }
            set { _validity = value; }
        }
        #endregion
        #region SubscriptionProduct 成员
        /// <summary>
        /// 添加订阅商机
        /// </summary>
        /// <param name="eui">订阅商机对象</param>
        /// <returns></returns>
        public int Insert(SubscriptionProduct eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {      
                    new SqlParameter("@UserID", eui.UserID),        
                    new SqlParameter("@Type", eui.Type),
					new SqlParameter("@Keyword", eui.Keyword),
                    new SqlParameter("@Indtype", eui.Indtype),
                    new SqlParameter("@Area", eui.Area),
                    new SqlParameter("@Validity", eui.Validity)
			        
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_SubscriptionProduct_Add", commandParameters);
        }
        /// <summary>
        /// 修改订阅商机
        /// </summary>
        /// <param name="eui">订阅商机对象<</param>
        /// <returns></returns>
        public int Update(SubscriptionProduct eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID",eui.ID),
                    new SqlParameter("@Type", eui.Type),
					new SqlParameter("@Keyword", eui.Keyword),
                    new SqlParameter("@Indtype", eui.Indtype),
                    new SqlParameter("@Area", eui.Area),
                    new SqlParameter("@Validity", eui.Validity)
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_SubscriptionProduct_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除订阅商机
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where UserID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "U_SubscriptionProduct") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有订阅商机
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","U_SubscriptionProduct"), 
                new SqlParameter("@strOrder", " order by ID asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID得到订阅商机每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public SubscriptionProduct GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "U_SubscriptionProduct"), 
                new SqlParameter("@strOrder", "") 
            };
            SubscriptionProduct info = new SubscriptionProduct();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                info.Type = reader["Type"].ToString();
                info.Keyword = reader["Keyword"].ToString();
                info.Indtype = reader["Indtype"].ToString();
                info.Area = reader["Area"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate =Convert.ToDateTime( reader["AddDate"].ToString());
                }
                if (reader["Validity"].ToString() != "")
                {
                    info.Validity = int.Parse(reader["Validity"].ToString());
                }
            }
            return info;
        }
        #endregion
    }
}
