﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_Expo 的摘要说明
/// </summary>
namespace Expo
{
    public class RExpo : IExpo
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IArea 成员
        /// <summary>
        /// 添加展会信息
        /// </summary>
        /// <param name="eui">展会信息对象</param>
        /// <returns></returns>
        public int Insert(TExpo eui, out int intReturn)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {  
                    new SqlParameter("@Return",DbType.Int32), 
                    new SqlParameter("@UserID",eui.UserID), 
                    new SqlParameter("@TypeID", eui.TypeID),
                    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@ExpoType", eui.ExpoType),
					new SqlParameter("@StartDate", eui.StartDate),
					new SqlParameter("@EndDate", eui.EndDate),
					new SqlParameter("@Place", eui.Place),
					new SqlParameter("@Authorize", eui.Authorize),
					new SqlParameter("@FrontFor", eui.FrontFor),
					new SqlParameter("@Undertake", eui.Undertake),
					new SqlParameter("@Aidance", eui.Aidance),
					new SqlParameter("@Summary", eui.Summary),
					new SqlParameter("@Range", eui.Range),
					new SqlParameter("@Period", eui.Period),
					new SqlParameter("@Homepage", eui.Homepage),
					new SqlParameter("@Picture", eui.Picture),
					new SqlParameter("@ShowArea", eui.ShowArea),
					new SqlParameter("@Businessmen", eui.Businessmen),
					new SqlParameter("@Spectator", eui.Spectator),
					new SqlParameter("@Price", eui.Price),
					new SqlParameter("@MinNum", eui.MinNum)
             };

            intReturn = 0;
            commandParameters[0].Direction = ParameterDirection.Output;
            int ReRows = SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Expo_Add", commandParameters);
            if (ReRows >= 0)
                intReturn = (int)commandParameters[0].Value;
            return ReRows;

        }
        /// <summary>
        /// 修改展会信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TExpo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@TypeID", eui.TypeID),
                    new SqlParameter("@Title", eui.Title),
					new SqlParameter("@ExpoType", eui.ExpoType),
					new SqlParameter("@StartDate", eui.StartDate),
					new SqlParameter("@EndDate", eui.EndDate),
					new SqlParameter("@Place", eui.Place),
					new SqlParameter("@Authorize", eui.Authorize),
					new SqlParameter("@FrontFor", eui.FrontFor),
					new SqlParameter("@Undertake", eui.Undertake),
					new SqlParameter("@Aidance", eui.Aidance),
					new SqlParameter("@Summary", eui.Summary),
					new SqlParameter("@Range", eui.Range),
					new SqlParameter("@Period", eui.Period),
					new SqlParameter("@Homepage", eui.Homepage),
					new SqlParameter("@Picture", eui.Picture),
					new SqlParameter("@ShowArea", eui.ShowArea),
					new SqlParameter("@Businessmen", eui.Businessmen),
					new SqlParameter("@Spectator", eui.Spectator),
					new SqlParameter("@Price", eui.Price),
					new SqlParameter("@MinNum", eui.MinNum)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Expo_Update", commandParameters);
        }
        /// <summary>
        /// 修改审核信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int UpdateVerify(TExpo eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@Verify", eui.Verify)
               
             };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_Expo_UpdateVerify", commandParameters);
        }
        /// <summary>
        /// 根据ID删除展会信息
        /// </summary>
        /// <param name="ID">地区ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Expo") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Expo") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据tppeID删除展会信息
        /// </summary>
        /// <param name="ID">地区ID</param>
        /// <returns></returns>
        public int DeleteByTypeID(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where TypeID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Expo") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        public int DeleteByTypeID(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where TypeID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_Expo") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到展会信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect", " W_Expo.*, W_ExpoType.Type"),
                new SqlParameter("@strwhere", "ON W_Expo.TypeID = W_ExpoType.ID"),
                new SqlParameter("@strtableName", "W_Expo left JOIN W_ExpoType"), 
                new SqlParameter("@strOrder", "order by AddDate desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据展会类别ID得到展会信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TExpo con)
        {
            string str = "on W_Expo.TypeID = W_ExpoType.ID";
            if (con.Title != null)
            {
                if (con.Title != "")
                {
                    str = str + " and Title like '%" + con.Title + "%' ";
                }
            }
            if (con.TypeID != 0)
            {
                str = str + " and W_Expo.TypeID =" + con.TypeID;
            }
            if (con.Verify != 0)
            {
                str = str + " and W_Expo.Verify =" + con.Verify;
            }
            if (con.UserID != null)
            {
                str = str + " and W_Expo.UserID =" + con.UserID;
            }
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strSelect", " W_Expo.*, W_ExpoType.Type"),
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "W_Expo INNER JOIN W_ExpoType"), 
                new SqlParameter("@strOrder", "order by AddDate desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        ///  根据ID得到展会每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TExpo GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "W_Expo"), 
                new SqlParameter("@strOrder", "") 
            };
            TExpo info = new TExpo();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = Convert.ToInt32(reader["TypeID"].ToString());
                }

                info.Title = reader["Title"].ToString();


                info.ExpoType = reader["ExpoType"].ToString();

                if (reader["StartDate"].ToString() != "")
                {
                    info.StartDate = Convert.ToDateTime(reader["StartDate"].ToString());
                }
                if (reader["EndDate"].ToString() != "")
                {
                    info.EndDate = Convert.ToDateTime(reader["EndDate"].ToString());
                }
                info.Place = reader["Place"].ToString();
                info.Authorize = reader["Authorize"].ToString();
                info.FrontFor = reader["FrontFor"].ToString();
                info.Undertake = reader["Undertake"].ToString();
                info.Aidance = reader["Aidance"].ToString();
                info.Summary = reader["Summary"].ToString();
                info.Range = reader["Range"].ToString();
                info.Period = reader["Period"].ToString();
                info.Homepage = reader["Homepage"].ToString();
                info.Picture = reader["Picture"].ToString();
                if (reader["ShowArea"].ToString() != "")
                {
                    info.ShowArea = Convert.ToInt32(reader["ShowArea"].ToString());
                }
                if (reader["Businessmen"].ToString() != "")
                {
                    info.Businessmen = Convert.ToInt32(reader["Businessmen"].ToString());
                }
                if (reader["Spectator"].ToString() != "")
                {
                    info.Spectator = Convert.ToInt32(reader["Spectator"].ToString());
                }
                if (reader["Price"].ToString() != "")
                {
                    info.Price = Convert.ToInt32(reader["Price"].ToString());
                }
                if (reader["MinNum"].ToString() != "")
                {
                    info.MinNum = Convert.ToInt32(reader["MinNum"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}