﻿using System;
using System.Data;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_ExpoNews 的摘要说明
/// </summary>
namespace Expo
{
    public class RExpoNews : IExpoNews
    {
        #region IArea 成员
        /// <summary>
        /// 添加展会资讯信息
        /// </summary>
        /// <param name="eui">展会信息对象</param>
        /// <returns></returns>
        public int Insert(TExpoNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {  
                    new SqlParameter("@TypeID", eui.TypeID),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Attribute", eui.Attribute),
					new SqlParameter("@Origin", eui.Origin),
                    new SqlParameter("@Picture",eui.Picture),
					new SqlParameter("@Detail", eui.Detail)
				
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_ExpoNews_Add", commandParameters);
        }
        /// <summary>
        /// 修改展会资讯信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TExpoNews eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@TypeID", eui.TypeID),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Attribute", eui.Attribute),
					new SqlParameter("@Origin", eui.Origin),
                    new SqlParameter("@Picture",eui.Picture),
					new SqlParameter("@Detail", eui.Detail),
                    new SqlParameter("@Verify",eui.Verify)
            };
            return SqlHelper.ExecuteNonQuery( CommandType.StoredProcedure, "SP_W_ExpoNews_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除展会资讯信息
        /// </summary>
        /// <param name="ID">地区ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_ExpoNews") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到展会资讯信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect", " W_ExpoNews.*, W_ExpoNewsType.Type"),
                new SqlParameter("@strwhere", "ON W_ExpoNews.TypeID = W_ExpoNewsType.ID"),
                new SqlParameter("@strtableName", "W_ExpoNews inner JOIN W_ExpoNewsType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据展会资讯类别ID得到展会资讯信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(TExpoNews con)
        {
            string str = "on W_ExpoNews.TypeID = W_ExpoNewsType.ID";
            if (con.Title != null)
            {
                if (con.Title != "")
                {
                    str = str + " and Title like '%" + con.Title + "%' ";
                }
            }
            if (con.TypeID != 0)
            {
                str = str + " and W_ExpoNews.TypeID =" + con.TypeID;
            }
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strSelect", " W_ExpoNews.*, W_ExpoNewsType.Type"),
                new SqlParameter("@strwhere", str),
                new SqlParameter("@strtableName", "W_ExpoNews INNER JOIN W_ExpoNewsType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        /// <summary>
        ///  根据ID得到展会资讯每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TExpoNews GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "W_ExpoNews"), 
                new SqlParameter("@strOrder", "") 
            };
            TExpoNews info = new TExpoNews();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = Convert.ToInt32(reader["TypeID"].ToString());
                }
                info.Title = reader["Title"].ToString();
                info.Attribute = reader["Attribute"].ToString();
                info.Origin = reader["Origin"].ToString();
                info.Detail = reader["Detail"].ToString();
                info.Picture = reader["Picture"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
            }
            return info;
        }
        #endregion
    }
}
