﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_ExpoNewsType 的摘要说明
/// </summary>
namespace Expo
{
    public class RExpoNewsType : IExpoNewsType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IArea 成员
        /// <summary>
        /// 添加展会资讯类别信息
        /// </summary>
        /// <param name="eui">展会资讯类别信息对象</param>
        /// <returns></returns>
        public int Insert(TExpoNewsType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {  
                 
                    new SqlParameter("@Type", eui.Type)
                    
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_ExpoNewsType_Add", commandParameters);
        }
        /// <summary>
        /// 修改展会资讯类别信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TExpoNewsType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Type", eui.Type)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_ExpoNewsType_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除展会资讯类别信息
        /// </summary>
        /// <param name="ID">地区ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_ExpoNewsType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到展会资讯类别信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_ExpoNewsType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据展会资讯类别ID得到展会资讯类别信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where TypeID="+ParamID),
                new SqlParameter("@strtableName", "W_ExpoNewsType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        /// <summary>
        ///  根据ID得到展会资讯类别每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TExpoNewsType GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "W_ExpoNewsType"), 
                new SqlParameter("@strOrder", "") 
            };
            TExpoNewsType info = new TExpoNewsType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Type = reader["Type"].ToString();
            }
            return info;
        }
        #endregion
    }
}
