﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_ExpoType 的摘要说明
/// </summary>
namespace Expo
{
    public class RExpoType : IExpoType
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region IArea 成员
        /// <summary>
        /// 添加展会类别信息
        /// </summary>
        /// <param name="eui">展会类别信息对象</param>
        /// <returns></returns>
        public int Insert(TExpoType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {  
                 
                    new SqlParameter("@Type", eui.Type)
                    
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_ExpoType_Add", commandParameters);
        }
        /// <summary>
        /// 修改展会类别信息
        /// </summary>
        /// <param name="eui"></param>
        /// <returns></returns>
        public int Update(TExpoType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Type", eui.Type)
            };
            return SqlHelper.ExecuteNonQuery(ConnectionString, CommandType.StoredProcedure, "SP_W_ExpoType_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除展会类别信息
        /// </summary>
        /// <param name="ID">地区ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_ExpoType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到展会类别信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere",""),
                new SqlParameter("@strTableName", "W_ExpoType"), 
                new SqlParameter("@strOrder", "")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据展会类别ID得到展会类别信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where TypeID="+ParamID),
                new SqlParameter("@strtableName", "W_ExpoType"), 
                new SqlParameter("@strOrder", "") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        /// <summary>
        ///  根据ID得到展会类别每一条信息
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public TExpoType GateItem(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "W_ExpoType"), 
                new SqlParameter("@strOrder", "") 
            };
            TExpoType info = new TExpoType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Type = reader["Type"].ToString();
            }
            return info;
        }
        #endregion

    }
}
