﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_HelpCenter 的摘要说明
/// </summary>
namespace Help
{
    public class RHelpCenter:IHelpCenter
    {
        public RHelpCenter()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region IHelpCenter 成员

        /// <summary>
        /// 添加帮助中心信息
        /// </summary>
        /// <param name="eui">帮助中心信息对象</param>
        /// <returns></returns>
        public int Insert(THelpCenter eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@TypeID", eui.TypeID),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Info", eui.Info),
					new SqlParameter("@AddDate", eui.AddDate)
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_HelpCenter_Add", commandParameters);
        }
        /// <summary>
        /// 修改帮助中心信息
        /// </summary>
        /// <param name="eui">帮助中心信息对象</param>
        /// <returns></returns>
        public int update(THelpCenter eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {             
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@TypeID", eui.TypeID),
					new SqlParameter("@Title", eui.Title),
					new SqlParameter("@Info", eui.Info),
					new SqlParameter("@AddDate", eui.AddDate)
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_HelpCenter_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除帮助中心信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_HelpCenter") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据ID批量删除帮助中心信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_HelpCenter") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 得到所有帮助中心信息
        /// </summary>
        /// <returns></returns>

        public DataTable GetDataTable()
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere",""),
                new SqlParameter("@strtableName", "W_HelpCenter"), 
                new SqlParameter("@strOrder", " order by AddDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据strWhere得到所有帮助中心信息
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", strWhere),
                new SqlParameter("@strtableName", "W_HelpCenter"), 
                new SqlParameter("@strOrder", " order by EditDate  desc,ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        /// <summary>
        /// 根据ID得到所有帮助中心信息每一条信息
        /// </summary>
        /// <param name="ID">搜藏信息ID</param>
        /// <returns></returns>
        public THelpCenter GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_HelpCenter"), 
                new SqlParameter("@strOrder", "") 
            };
            THelpCenter info = new THelpCenter();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = Convert.ToInt32(reader["TypeID"].ToString());
                }
                info.Title = reader["Title"].ToString();
                info.Info = reader["Info"].ToString();
                if (reader["AddDate"].ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }
              
            }
            return info;
        }
    }
    #endregion
}
