﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// R_HelpType 的摘要说明
/// </summary>
namespace Help
{
    public class RHelpType : IHelpType
    {
        public RHelpType()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region IFavorites 成员

        /// <summary>
        /// 添加帮助类别信息
        /// </summary>
        /// <param name="eui">帮助类别信息对象</param>
        /// <returns></returns>
        public int Insert(THelpType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                   new SqlParameter("@Name", eui.Name),
					new SqlParameter("@ParentID", eui.ParentID)
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_HelpType_Add", commandParameters);
        }

        /// <summary>
        /// 添加帮助类别信息
        /// </summary>
        /// <param name="eui">帮助类别信息对象</param>
        /// <returns></returns>
        public int update(THelpType eui)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {   
                    new SqlParameter("@ID", eui.ID),
                    new SqlParameter("@Name", eui.Name)
	        };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_HelpType_Update", commandParameters);
        }
        /// <summary>
        /// 根据ID删除帮助类别信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@ID", ID), 
              
            };
            return SqlHelper.DeleteByWhere("SP_W_HelpType_Delete", param);

        }
        /// <summary>
        /// 根据ID批量删除帮助类别信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int Delete(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_HelpType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据ParentID批量删除帮助类别信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DeleteParentID(string ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ParentID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_HelpType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

        }
        /// <summary>
        /// 根据ID得到所有帮助类别信息
        /// </summary>
        /// <returns></returns>

        public DataTable GetDataTable(string ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where ID="+ParamID),
                new SqlParameter("@strtableName", "W_HelpType"), 
                new SqlParameter("@strOrder", "order by ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据上级ID得到所有帮助类别信息
        /// </summary>
        /// <returns></returns>

        public DataTable GetDataTable(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where ParentID="+ParamID),
                new SqlParameter("@strtableName", "W_HelpType"), 
                new SqlParameter("@strOrder", "order by ID desc") 
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
       
        /// <summary>
        /// 根据ID得到所有帮助类别信息每一条信息
        /// </summary>
        /// <param name="ID">搜藏信息ID</param>
        /// <returns></returns>
        public THelpType GateItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" + ID), 
                new SqlParameter("@strTableName", "W_HelpType"), 
                new SqlParameter("@strOrder", "") 
            };
            THelpType info = new THelpType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = Convert.ToInt32(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                if (reader["ParentID"].ToString() != "")
                {
                    info.ParentID = Convert.ToInt32(reader["ParentID"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}
