﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;
using System.Data.SqlClient;

///**************************************************
///<summary>
///Depiction：这个类用于管理员对职位类别的管理
///Create Date：2009-8-29
///</summary>
///**************************************************
namespace nspJob
{
    #region RJobType 成员
    public class RJobType : IJobType
    {
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对职位类别的添加
        /// </summary>
        /// <param name="tb"><职位类别的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>

        ///Create Date：2009-8-29
        ///**************************************************
        public int Insert(TJobType tb)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
                    new SqlParameter("@typename",tb.TypeName),
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_jobtype_add", commandParameters);
        }

        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对职位类别的修改
        /// </summary>
        /// <param name="tb"><职位类别的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>

        ///Create Date：2009-8-29
        ///**************************************************
        public int Update(TJobType tb)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {   
                    new SqlParameter("@id", tb.ID),
                    new SqlParameter("@typename  ", tb.TypeName)
	        };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_jobtype_update", commandParameters);
        }
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对职位类别的删除
        /// </summary>
        /// <param name="tb"><职位类别的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>

        ///Create Date：2009-8-29
        ///**************************************************
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where id in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_JobType") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对已经存在的对象进行判断
        /// </summary>
        /// <param name="<参数名称>"><参数说明></param>
        /// <returns>
        ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
        /// </returns>

        ///Create Date：2009-08-29
        ///**************************************************
        public bool GetDataExists(string typename)
        {
            int num = 0;
            String sql = "select count(*)  from C_JobType where TypeName='" + typename + "'";
            SqlConnection conn = new SqlConnection(SqlHelper.ConnectionString);
            conn.Open();
            SqlCommand cmmd = new SqlCommand(sql, conn);
            num = Convert.ToInt32(cmmd.ExecuteScalar());
            conn.Close();
            if (num > 0)
            {
                return true;
            }
            else
            {
                return false;
            }


        }
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于根据条件查询符合条件的职位
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>

        ///Create Date：2009-8-31
        ///**************************************************
        public string GetDataTableByWhere(int ParamID)
        {

             SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","TypeName"),
                new SqlParameter("@strWhere", "where id=" + ParamID), 
                new SqlParameter("@strTableName", "C_JobType")
            };
             string name = "";
             using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
             {
                 if (reader.Read())
                 {
                     name = reader["TypeName"].ToString();
                 }
             }
            return name;
        }
    }
    #endregion
}