﻿using System;
using System.Data;
using System.Data.SqlClient;
using SqlOperate;
///**************************************************
///<summary>
///Depiction：此类是对用户操作的实现类
///Author：
///Create Date：2009-9-5
///</summary>
///**************************************************
namespace nspJob
{
    public class RUser : IUser
    {

        #region IUser 成员
        /// <summary>
        /// depiction：该方法用于根据条件添加用户
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否添加成功，如果成功返回1 否则返回0
        /// </returns>
        ///Create Date：2009-8-31
        public int Insert(TUser tu)
        {
            SqlParameter[] parameters = {
					new SqlParameter("@LoginName", tu.LoginName),
					new SqlParameter("@password", tu.password),
					new SqlParameter("@ResumeID",tu.ResumeID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_Applicant_Add", parameters);
        }

        /// <summary>
        /// depiction：该方法用于根据条件修改用户
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>
        ///Create Date：2009-8-31
        public int Update(TUser tu)
        {
            SqlParameter[] parameters = {
					new SqlParameter("@LoginName", tu.LoginName),
					new SqlParameter("@password", tu.password)};
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_U_Applicant_Update", parameters);
        }

        ///**************************************************
        /// <summary>
        /// depiction：该方法用于根据条件删除用户
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否删除成功，如果成功返回1 否则返回0
        /// </returns>
        ///Create Date：2009-8-31
        ///**************************************************
        public int Delete(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where id in (" + ID + ")"), 
                new SqlParameter("@strTableName", "C_Job") 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }

        ///**************************************************
        /// <summary>
        /// depiction：该方法用于登陆判断用户名是否存在
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否存在，如果存在返回1 否则返回0
        /// </returns>

        ///Create Date：2009-8-31
        ///**************************************************
        public bool GetDataExists(string username, string password)
        {
            bool exists = false;
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where LoginName='" + username + "' and password='" + password + "'"), 
                new SqlParameter("@strTableName", "U_Applicant"), 
                new SqlParameter("@strOrder", "") 
            };
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (reader.Read())
                {
                    exists = true;
                }
                else
                {
                    exists = false;
                }
            }
            return exists;

        }

        ///**************************************************
        /// <summary>
        /// depiction：根据用户名删除用户
        /// </summary>
        /// <param name="<参数名称>"><参数说明></param>
        /// <returns>
        ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
        /// </returns>

        ///Create Date：2009-9-4
        ///**************************************************
        public int DeleteUser(string typename,int resumeid)
        {
            int num = 0;
            String sql1 = "delete  from U_Applicant where LoginName='" + typename + "'";
            String sql2 = "delete  from U_Resume where id="+ resumeid + "";
            String sql3 = "delete  from C_JobResume where resumeid=" + resumeid + "";
            String[] sql ={ sql1,sql2,sql3};
            SqlConnection conn = new SqlConnection(SqlHelper.ConnectionString);
            conn.Open();
            for (int i = 0; i < sql.Length; i++)
            {
                SqlCommand cmmd = new SqlCommand(sql[i], conn);
                num = Convert.ToInt32(cmmd.ExecuteNonQuery());
            }
            conn.Close();
            return num;
        }
        /// <summary>
        /// 根据登陆名获取简历ID
        /// </summary>
        /// <param name="ParamID"></param>
        /// <returns></returns>
        public int GetResumeIdByName(String ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","ResumeID"),
                new SqlParameter("@strwhere","where LoginName='"+ParamID+"'"),
                new SqlParameter("@strtableName", "U_Applicant")
            };
            return Convert.ToInt32(SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param).Rows[0][0].ToString());
        }
        /// <summary>
        /// 人才应聘职位数据的处理
        /// </summary>
        /// <param name="CompanyID"></param>
        /// <param name="ResumeID"></param>
        /// <param name="jobID"></param>
        /// <returns></returns>
        public int InsertJobResume( int ResumeID, int jobID)
        {
            SqlParameter[] parameters = new SqlParameter[] {
					new SqlParameter("@ResumeID", ResumeID),
					new SqlParameter("@jobID",jobID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_JobResume_Add", parameters);
        }
        #endregion
    }
}
