﻿using System;
using System.Data;
using System.Data.SqlClient;
using SqlOperate;
using System.Configuration;

///**************************************************
///<summary>
///Depiction：此类是企业发布招聘信息，以及对招聘信息的增加，删除，修改，查询
///Create Date：2009-8-31
///</summary>
///**************************************************
namespace nspJob
{
    public class Rjob : IJob
    {
        #region R_job 成员
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对职位的添加
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>
        ///**************************************************
        public int Insert(TJob tb)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {                
					new SqlParameter("@UserID",tb.UserID),
					new SqlParameter("@TypeID", tb.TypeID),
					new SqlParameter("@Position", tb.Position),
					new SqlParameter("@Count",tb.JobCount),
					new SqlParameter("@Degree",tb.Degree),
					new SqlParameter("@AgeRequest",tb.AgeRequest),
					new SqlParameter("@Experience ", tb.Experience),
					new SqlParameter("@WorkTemper", tb.WorkTemper),
					new SqlParameter("@Address", tb.Address),
					new SqlParameter("@SalaryLevel",tb.SalaryLevel),
					new SqlParameter("@Sex", tb.Sex),
					new SqlParameter("@EnglishLevel", tb.EnglishLevel),
					new SqlParameter("@ComputerLevel",tb.ComputerLevel),
					new SqlParameter("@verify", tb.verify),
					new SqlParameter("@EndDate", tb.EndDate),
					new SqlParameter("@isRecommend", tb.isRecommend)
					
             };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_job_Add", commandParameters);
        }

        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对职位的修改
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>
        ///**************************************************
        public int Update(TJob tb)
        {
            SqlParameter[] commandParameters = new SqlParameter[]
            {   
                    new SqlParameter("@ID", tb.ID),
					new SqlParameter("@TypeID", tb.TypeID),
					new SqlParameter("@Position", tb.Position),
					new SqlParameter("@Count",tb.JobCount),
					new SqlParameter("@Degree",tb.Degree),
					new SqlParameter("@AgeRequest",tb.AgeRequest),
					new SqlParameter("@Experience ", tb.Experience),
					new SqlParameter("@WorkTemper", tb.WorkTemper),
					new SqlParameter("@Address", tb.Address),
					new SqlParameter("@SalaryLevel",tb.SalaryLevel),
					new SqlParameter("@Sex", tb.Sex),
					new SqlParameter("@EnglishLevel", tb.EnglishLevel),
					new SqlParameter("@ComputerLevel",tb.ComputerLevel),
					new SqlParameter("@EndDate", tb.EndDate)
	        };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_C_job_update", commandParameters);
        }
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于对职位的删除
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方法的返回值表示 是否更新成功，如果成功返回1 否则返回0
        /// </returns>

        ///Create Date：2009-8-31
        ///**************************************************
        public int Delete(string table, int ID, string typeid)
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where " +typeid+" in (" + ID + ")"), 
                new SqlParameter("@strTableName", table) 
            };
            return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于根据条件查询符合条件的职位
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///
        /// </returns>
        ///Create Date：2009-8-31
        ///**************************************************
        public DataTable GetDataTableByWhere(int ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where C_Job.ID="+ParamID),
                new SqlParameter("@strtableName", "C_Job")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        ///**************************************************
        /// <summary>
        /// depiction：该方法用于根据条件查询符合条件的职位
        /// </summary>
        /// <param name="tb"><职位的实体对象></param>
        /// <returns>
        ///方
        /// </returns>
        ///Create Date：2009-8-31
        ///**************************************************
        public DataTable GetDataTable(String table, String ParamID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where ID='"+ParamID+"'"),
                new SqlParameter("@strtableName", table)
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }

        ///**************************************************
        /// <summary>
        /// depiction：该方法用于根据表名查询数据
        /// </summary>
        /// <param name="<参数名称>"><参数说明></param>
        /// <returns>
        ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
        /// </returns>
        ///Create Date：2009-9-4
        ///**************************************************
        public DataTable GetDataType(string table)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strtableName", table)
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        public DataTable GetDataType(string table,int userid)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strwhere","where UserId="+userid),
                new SqlParameter("@strtableName", table)
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
        }
        ///**************************************************
        /// <summary>
        /// depiction：判断企业发布职位名称是否重复
        /// </summary>
        /// <param name="<参数名称>"><参数说明></param>
        /// <returns>
        ///<对方法返回值的说明，该说明必须明确说明返回的值代表什么含义>
        /// </returns>
        ///Create Date：2009-9-4
        ///**************************************************
        public bool GetDataPositionExists(string position, int userid)
        {
            int num = 0;
            String sql = "select count(*)  from C_Job where Position='" + position + "' and  UserID=" + userid + "";
            SqlConnection conn = new SqlConnection(SqlHelper.ConnectionString);
            conn.Open();
            SqlCommand cmmd = new SqlCommand(sql, conn);
            num = Convert.ToInt32(cmmd.ExecuteScalar());
            conn.Close();
            if (num > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        //根据职位ID获取职位发布状态
        public bool GetStateIsEnable(int id)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere", "where ID=" + id), 
                new SqlParameter("@strTableName", "U_Resume")
            };
            bool flag = false;
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (reader.Read())
                    flag =Convert.ToBoolean(reader["isEnable"]);
            }
            return flag;
        }
        #endregion

    }


}
