﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

/// <summary>
/// KnowAnswer 的摘要说明
/// </summary>
public class KnowAnswer
{
    public KnowAnswer()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    #region Model
    private int _id;
    private int _userid;
    private string _username;
    private int _problemsid;
    private bool _state;
    private string _detail;
    private string _ip;
    private DateTime _adddate;
    /// <summary>
    /// 
    /// </summary>
    public int ID
    {
        set { _id = value; }
        get { return _id; }
    }
    /// <summary>
    /// 用户ID
    /// </summary>
    public int UserID
    {
        set { _userid = value; }
        get { return _userid; }
    }
    /// <summary>
    /// 用户名
    /// </summary>
    public string UserName
    {
        set { _username = value; }
        get { return _username; }
    }
    /// <summary>
    /// 问题ID
    /// </summary>
    public int ProblemsID
    {
        set { _problemsid = value; }
        get { return _problemsid; }
    }
    /// <summary>
    /// 是否被采纳
    /// </summary>
    public bool State
    {
        set { _state = value; }
        get { return _state; }
    }
    /// <summary>
    /// 回答内容
    /// </summary>
    public string Detail
    {
        set { _detail = value; }
        get { return _detail; }
    }
    /// <summary>
    /// 回答IP
    /// </summary>
    public string IP
    {
        set { _ip = value; }
        get { return _ip; }
    }
    /// <summary>
    /// 发布时间
    /// </summary>
    public DateTime AddDate
    {
        set { _adddate = value; }
        get { return _adddate; }
    }
    #endregion Model

    #region KnowAnswer 成员
    /// <summary>
    /// 添加知道问题
    /// </summary>
    /// <param name="eui">知道问题对象</param>
    /// <returns></returns>
    public int Insert(KnowAnswer eui)
    {
        SqlParameter[] Parameters = new SqlParameter[]
        {
            new SqlParameter("@UserID", eui.UserID),
		    new SqlParameter("@UserName",eui.UserName),
		    new SqlParameter("@ProblemsID", eui.ProblemsID),
		    new SqlParameter("@Detail",eui.Detail),
		    new SqlParameter("@IP", eui.IP),
		    new SqlParameter("@AddDate", eui.AddDate)
      
        };
        return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowAnswers_Add", Parameters);
    }
    /// <summary>
    /// 修改知道问题
    /// </summary>
    /// <param name="eui">知道问题对象<</param>
    /// <returns></returns>
    public int Update(KnowAnswer eui)
    {
        SqlParameter[] Parameters = new SqlParameter[]
        {
            new SqlParameter("@ID", eui.UserID),
            new SqlParameter("@Detail",eui.Detail),
		    new SqlParameter("@IP", eui.IP),
		    new SqlParameter("@AddDate", eui.AddDate)
        };
        return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowAnswer_Update", Parameters);
    }
    /// <summary>
    /// 根据ID删除知道问题
    /// </summary>
    /// <param name="ID">供应ID</param>
    /// <returns></returns>
    public int Delete(int ID)
    {
        SqlParameter[] param = new SqlParameter[] 
        {
            new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
            new SqlParameter("@strTableName", "W_KnowAnswer") 
        };
        return SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);

    }
    /// <summary>
    /// 得到所有知道问题
    /// </summary>
    /// <returns></returns>
    public DataTable GetDataTable(string strWhere)
    {
        SqlParameter[] param = new SqlParameter[] 
        { 
            new SqlParameter("@strSelect","*"),
            new SqlParameter("@strWhere",strWhere),
            new SqlParameter("@strTableName","W_KnowAnswer"), 
            new SqlParameter("@strOrder", " order by AddDate asc")
        };
        return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

    }
    /// <summary>
    /// 根据ID读取知道问题别每一条信息
    /// </summary>
    /// <param name="ID"></param>
    /// <returns></returns>
    public KnowAnswer GetItem(int ID)
    {
        SqlParameter[] param = new SqlParameter[] 
        { 
            new SqlParameter("@strWhere", "where ID=" +ID), 
            new SqlParameter("@strTableName", "W_KnowAnswer"), 
            new SqlParameter("@strOrder", "") 
        };
        KnowAnswer info = new KnowAnswer();
        using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
        {
            if (!reader.Read())
            {
                return info;
            }
            if (reader["ID"].ToString() != "")
            {
                info.ID = int.Parse(reader["ID"].ToString());
            }
            if (reader["UserID"].ToString() != "")
            {
                info.UserID = int.Parse(reader["UserID"].ToString());
            }
            if (reader["ProblemsID"].ToString() != "")
            {
                info.ProblemsID = int.Parse(reader["ProblemsID"].ToString());
            }
            info.UserName = reader["UserName"].ToString();
            info.Detail = reader["Detail"].ToString();
            if (reader["State"].ToString() != "")
            {
                info.State = Convert.ToBoolean(reader["State"].ToString());
            }
            info.IP = reader["IP"].ToString();
            if (info.AddDate.ToString() != "")
            {
                info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
            }

        }
        return info;
    }
    #endregion
}
