﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

namespace nspKnow
{
    /// <summary>
    /// KnowProblem 的摘要说明
    /// </summary>
    public class KnowProblem
    {
        public KnowProblem()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region Model
        private int _id;
        private int _userid;
        private int _typeid;
        private string _username;
        private string _caption;
        private string _detail;
        private bool _verify;
        private bool _state;
        private int _answercount;
        private DateTime _adddate;
        /// <summary>
        /// 
        /// </summary>
        public int ID
        {
            set { _id = value; }
            get { return _id; }
        }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserID
        {
            set { _userid = value; }
            get { return _userid; }
        }
        /// <summary>
        /// 类别ID
        /// </summary>
        public int TypeID
        {
            set { _typeid = value; }
            get { return _typeid; }
        }
        /// <summary>
        /// 用户名
        /// </summary>
        public string UserName
        {
            set { _username = value; }
            get { return _username; }
        }
        /// <summary>
        /// 问题
        /// </summary>
        public string Caption
        {
            set { _caption = value; }
            get { return _caption; }
        }
        /// <summary>
        /// 问题补充说明
        /// </summary>
        public string Detail
        {
            set { _detail = value; }
            get { return _detail; }
        }
        /// <summary>
        /// 审核
        /// </summary>
        public bool Verify
        {
            set { _verify = value; }
            get { return _verify; }
        }
        /// <summary>
        /// 问题状态
        /// </summary>
        public bool State
        {
            set { _state = value; }
            get { return _state; }
        }
        /// <summary>
        /// 回答数  
        /// </summary>
        public int AnswerCount
        {
            set { _answercount = value; }
            get { return _answercount; }
        }
        /// <summary>
        /// 发布日期
        /// </summary>
        public DateTime AddDate
        {
            set { _adddate = value; }
            get { return _adddate; }
        }
        #endregion Model
        #region KnowProblem 成员
        /// <summary>
        /// 添加知道问题
        /// </summary>
        /// <param name="eui">知道问题对象</param>
        /// <returns></returns>
        public int Insert(KnowProblem eui)
        {
            SqlParameter[] Parameters = new SqlParameter[]
            {
                new SqlParameter("@UserID", eui.UserID),
			    new SqlParameter("@TypeID", eui.TypeID),
			    new SqlParameter("@UserName", eui.UserName),
			    new SqlParameter("@Caption", eui.Caption),
			    new SqlParameter("@Detail", eui.Detail),
                new SqlParameter("@AddDate", eui.AddDate)
      
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowProblems_Add", Parameters);
        }
        /// <summary>
        /// 修改知道问题
        /// </summary>
        /// <param name="eui">知道问题对象<</param>
        /// <returns></returns>
        public int Update(KnowProblem eui)
        {
            SqlParameter[] Parameters = new SqlParameter[]
            {
                new SqlParameter("@ID", eui.ID),
                new SqlParameter("@UserID", eui.UserID),
			    new SqlParameter("@TypeID", eui.TypeID),
			    new SqlParameter("@UserName", eui.UserName),
			    new SqlParameter("@Caption", eui.Caption),
			    new SqlParameter("@Detail", eui.Detail)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowProblems_Update", Parameters);
        }
        /// <summary>
        /// 根据ID删除知道问题
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] Parameters = new SqlParameter[] 
            {
                 new SqlParameter("@ID", ID)
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowProblems_Delete", Parameters);

        }
        /// <summary>
        /// 得到所有知道问题
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","W_KnowProblems"), 
                new SqlParameter("@strOrder", " order by AddDate asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID读取知道问题别每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public KnowProblem GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                    new SqlParameter("@strWhere", "where ID=" +ID), 
                    new SqlParameter("@strTableName", "W_KnowProblems"), 
                    new SqlParameter("@strOrder", "") 
             };
            KnowProblem info = new KnowProblem();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                if (reader["UserID"].ToString() != "")
                {
                    info.UserID = int.Parse(reader["UserID"].ToString());
                }
                if (reader["TypeID"].ToString() != "")
                {
                    info.TypeID = int.Parse(reader["TypeID"].ToString());
                }
                info.UserName = reader["UserName"].ToString();
                info.Caption = reader["Caption"].ToString();
                info.Detail = reader["Detail"].ToString();

                if (reader["Verify"].ToString() != "")
                {
                    info.Verify = Convert.ToBoolean(reader["Verify"].ToString());
                }
                if (reader["State"].ToString() != "")
                {
                    info.State = Convert.ToBoolean(reader["State"].ToString());
                }
                if (reader["AnswerCount"].ToString() != "")
                {
                    info.AnswerCount = int.Parse(reader["AnswerCount"].ToString());
                }
                if (info.AddDate.ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}
