﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;

namespace nspKnow
{
    /// <summary>
    /// KnowType 的摘要说明
    /// </summary>
    public class KnowType
    {
        public KnowType()
        {
            //
            // TODO: 在此处添加构造函数逻辑
            //
        }
        #region KnowType属性
        private int _id;
        private string _name;
        private int _parentid;
        private DateTime _adddate;
        public int ID
        {
            get { return _id; }
            set { _id = value; }
        }
        /// <summary>
        /// 知道类别 
        /// </summary>
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }
        /// <summary>
        /// 父级ID
        /// </summary>
        public int ParentID
        {
            get { return _parentid; }
            set { _parentid = value; }
        }
        /// <summary>
        /// 添加日期
        /// </summary>
        public DateTime AddDate
        {
            get { return _adddate; }
            set { _adddate = value; }
        }
        #endregion
        #region KnowType 成员
        /// <summary>
        /// 添加知道类别
        /// </summary>
        /// <param name="eui">订阅商业资讯对象</param>
        /// <returns></returns>
        public int Insert(KnowType eui)
        {
            SqlParameter[] Parameters = new SqlParameter[]
            {       
                    new SqlParameter("Name",eui.Name),
                    new SqlParameter("@ParentID", eui.ParentID),
                    new SqlParameter("@AddDate",eui.AddDate)
      
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowType_Add", Parameters);
        }
        /// <summary>
        /// 修改知道类别
        /// </summary>
        /// <param name="eui">订阅商业资讯对象<</param>
        /// <returns></returns>
        public int Update(KnowType eui)
        {
            SqlParameter[] Parameters = new SqlParameter[]
            {
                   new SqlParameter("@ID",eui.ID),
                   new SqlParameter("@Name", eui.Name),

            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowType_Update", Parameters);
        }
        /// <summary>
        /// 根据ID删除知道类别
        /// </summary>
        /// <param name="ID">供应ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter[] Parameters = new SqlParameter[] 
            {
                  new SqlParameter("@ID",ID),
            };
            return SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_KnowType_Delete", Parameters);
        }
        /// <summary>
        /// 得到所有知道类别
        /// </summary>
        /// <returns></returns>
        public DataTable GetDataTable(string strWhere)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strSelect","*"),
                new SqlParameter("@strWhere",strWhere),
                new SqlParameter("@strTableName","W_KnowType"), 
                new SqlParameter("@strOrder", " order by AddDate asc")
            };
            return SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);

        }
        /// <summary>
        /// 根据ID读取知道类别每一条信息
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public KnowType GetItem(int ID)
        {
            SqlParameter[] param = new SqlParameter[] 
            { 
                new SqlParameter("@strWhere", "where ID=" +ID), 
                new SqlParameter("@strTableName", "W_KnowType"), 
                new SqlParameter("@strOrder", "") 
            };
            KnowType info = new KnowType();
            using (SqlDataReader reader = SqlHelper.ExecuteReader(CommandType.StoredProcedure, "SP_SelectByWhere", param))
            {
                if (!reader.Read())
                {
                    return info;
                }
                if (reader["ID"].ToString() != "")
                {
                    info.ID = int.Parse(reader["ID"].ToString());
                }
                info.Name = reader["Name"].ToString();
                if (reader["ParentID"].ToString() != "")
                {
                    info.ParentID = int.Parse(reader["ParentID"].ToString());
                }
                if (info.AddDate.ToString() != "")
                {
                    info.AddDate = Convert.ToDateTime(reader["AddDate"].ToString());
                }

            }
            return info;
        }
        #endregion
    }
}