﻿using System;
using System.Data;
using System.Configuration;
using nspLable.Function.Systems;
using nspLable.Function.Shops;
using nspLable.Function;

namespace nspLable
{
    namespace Using
    {


        /// <summary>
        /// Corporation 的摘要说明
        /// </summary>
        public class Principal:Base.BasePage 
        {

            /// <summary>
            ///  取得网站模板
            /// </summary>
            /// <param name="strPage">模板类型</param>
            /// <param name="strPage">模板路径</param>
            /// <returns>返回生成的页面</returns>
            public string GetTemplate(string strPage)
            {

                string WSbody = "页面生成出现错误！";
                try
                {
                    if (strPage == "") return "没有传入模板路径或类型";
                    //获取模板路径
                    string strdir = Base.XMLProcess.Read("xml/Template.xml", "/template/system", "url");
                    string strfile = Base.XMLProcess.Read("xml/Template.xml", "/template/system/mode[@type='" + strPage + "']", "url");
                    string Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + strdir+strfile;
                    if (!Base.BasePage.CheckFile(Path))
                        return "模板不存在";
                    else
                    {
                        Tempinc Temp = new Tempinc(strPage);
                        WSbody = Temp.GetTemplate(Path);
                    }
                }
                catch (Exception e)
                {
                    throw e;
                }
                return WSbody;     
            }
        }



        /// <summary>
        /// 查找会员商铺模板
        /// </summary>
        public class Shops
        {

            /// <summary>
            /// 取得会员商铺模板
            /// </summary>
            /// <returns></returns>
            public string CreateShop(string Module, string LogName)
            {
                string Path = "";
                string strSelect;
                strSelect = " U_UserOperate.Template_new ";
                //查询条件 
                string strWhere = "where U_UserOperate.UserID =U_UserInfo.UserID and U_UserInfo.LoginName ='" + LogName + "' ";
                // 要查询表、视图
                string strTableName = "U_UserOperate,U_UserInfo";

                string ShopModel = nspLable.Function.Function.GetOnlyDate(strSelect, strWhere, strTableName);
                string strShopDir = Base.XMLProcess.Read("xml/Template.xml", "/template/shop", "url");
                //获取会员商铺模板路径
                Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + strShopDir + ShopModel; 
                switch (Module.ToLower())
                {
                    case "index":
                        Path += "/Index.html";     //商铺首页
                        break;
                    case "supply":
                        Path += "/Supply.html";    //供应信息
                        break;
                    case "contact":
                        Path += "/Contact.html";   //联系方式
                        break;
                    case "certify":
                        Path += "/Certify.html";   //公司证书
                        break;
                    case "profile":
                        Path += "/Profile.html";   //公司介绍
                        break;
                    case "newslist":
                        Path += "/Newslist.html";  //公司动态
                        break;
                    case "online":
                        Path += "/online.html";    //公司动态
                        break;
                    case "newsinfo":
                        Path += "/NewsInfo.html";    //公司动态
                        break;
                    case "job":
                        Path += "/job.html";    //公司动态
                        break;
                    default:
                        Path += "/index.html";
                        break;
                    //else
                    //    Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + @"Shops/" + StrModule + @"/index.html";
                }


                if (!Base.BasePage.CheckFile(Path))
                    return "模板不存在";
                else
                {
                    Process Temp = new Process(ShopModel, LogName);
                    return Temp.GetTemplate(ShopModel, Path);
                }
            }
        }
    }
}
