﻿using System;
using System.Data;
using System.Configuration;
using System.Text;
using System.IO;
using System.Text.RegularExpressions;

namespace nspLable.Function.Shops
{
    /// <summary>
    /// Process 的摘要说明
    /// </summary>
    public class Process
    {
        Regex[] regex = new Regex[5];
        public Process(string StrModule,string LoginName)
        {
            //确定访问哪个会员的商铺以及商铺的哪个页面
            this._StrModule = StrModule;
            this._LogName = LoginName;
            RegexOptions options;
            options = RegexOptions.Singleline | RegexOptions.IgnoreCase;
            regex[0] = new Regex(@"{Shop_\w+(\(\d[,]+\d\))?}", options);
            regex[1] = new Regex(@"{PB_\w+}", options);
        }

        private string _StrModule;
        private string _LogName;
        public string StrModule
        {
            get { return this._StrModule; }
        }

        public string LogName
        {
            get { return this._LogName; }
        }

        /// <summary>
        /// 获取模板
        /// </summary>
        /// <param name="pathName">模板路径</param>
        /// <returns></returns>
        public string GetTemplate(string strMode,string pathName)
        {
            this._StrModule = strMode;
            StringBuilder builder = new StringBuilder();
            string str = "";
            using (StreamReader reader = new StreamReader(pathName, Encoding.Default))
            {
                StringBuilder builder2 = new StringBuilder();
                builder2.Append(reader.ReadToEnd());
                reader.Close();
                str = Hope_HtmlResult(builder2.ToString());
            }
            return str;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public string Hope_HtmlResult(string str)
        {
            string resultHtml = "";
            resultHtml = Hope_htmlAll(str);
            resultHtml = Hope_htmlAll(resultHtml);  //使用三层，考虑资源问题
            return resultHtml;
        }

        /// <summary>
        /// 标签处理方法
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        private string Hope_htmlAll(string str)
        {
            string Restr = "";
            Restr = str;
            string strInfo_SY = "";
            string strInfo_PB = ""; 
            string[] arrInfo;
            try
            {
                //处理公共标签
                foreach (Match match in regex[0].Matches(Restr))
                {
                    //string Fun = tempTitle(match0.Groups[i].ToString());
                    //ReStr = str.Replace(match0.Groups[i].ToString(), eval(Fun));
                    strInfo_SY = strInfo_SY + match.Groups[0].ToString() + "|";
                }
                arrInfo = strInfo_SY.Split('|');
                for (int i = 0; i < arrInfo.Length - 1; i++)
                {
                    Restr = Restr.Replace(arrInfo[i], eval(arrInfo[i].ToString()));
                }

                //处理公共标签
                foreach (Match match in regex[1].Matches(Restr))
                    strInfo_PB = strInfo_PB + match.Groups[0].ToString() + "|";
                Restr = PBFunction(Restr, strInfo_PB);
            }
            catch (Exception e)
            {
                Console.WriteLine("{0} Second exception caught.", e);
            }

            return Restr;
        }

        /// <summary>
        /// 替换函数标签
        /// </summary>
        /// <param name="funTitle"></param>
        /// <param name="arry"></param>
        /// <returns></returns>
        private string eval(string str)
        {
            string LName = "";
            LName = this.LogName;
            string Restr = "";
            try
            {
                //switch (str.ToLower())
                //{
                //    case "{shop_companysummary}":   //公司简介
                //        Restr = Shop.ComPanySummary(LName);
                //        break;
                //    case "{shop_logo}":            //公司LOGO
                //        Restr = Shop.ReplaceLable(LName, "Logo");
                //        break;
                //    case "{shop_companyname}":            //公司名称
                //        Restr = Shop.ReplaceLable(LName, "CompanyName");
                //        break;
                //    default :
                //        Restr = Shop.ReplaceLable(LName, "CompanySummary");
                //        break;
                //}
                if(str!="")
                    Restr = Shop.ReplaceLable(LName, str.Substring(6,str.Length-7));
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }


        /// <summary>
        /// 处理全局变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        private  string PBFunction(string strInfo, string str)
        {
            string[] strArray;
            strArray = str.Split('|');
            DataTable WebTable = Function.GetDataTable("select * from W_WebBasic");
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PB_WEBURL}":
			    strInfo = strInfo.Replace(strArray[i].ToString(), WebTable.Rows[0]["WebURL"].ToString());
                            break;
                        case "{PB_WEBNAME}":
                            strInfo = strInfo.Replace(strArray[i].ToString(), WebTable.Rows[0]["WebName"].ToString());
                            break;
                        case "{PB_WEBTEL}":
                            strInfo = strInfo.Replace(strArray[i].ToString(), WebTable.Rows[0]["HotTel"].ToString());
                            break;
                        case "{PB_CSS}":
                            strInfo = strInfo.Replace(strArray[i].ToString(), "{PB_webUrl}ShopTemplate/"+StrModule+"/");
                            break;
                        case "{PB_WEBLOGO}":
                            string Url=@"<img src='"+Function.ProcessImageUrl(WebTable.Rows[0]["WebLOGO"].ToString())+ "'alt=''>";
                            strInfo = strInfo.Replace(strArray[i].ToString(), Url);
                            break;

                    }
                }
            }
            catch
            {

            }
            return strInfo;
        }
    }
}