﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Text;
using nspLable.Function;
using System.IO;
using Base;
namespace nspLable.Function.Shops
{
    /// <summary>
    /// Shop 的摘要说明
    /// </summary>
    public class Shop
    {

        /// <summary>
        /// 获取方法名称
        /// </summary>
        /// <param name="parame"></param>
        /// <returns></returns>
        private static string tempTitle(string parame)
        {
            int nstart = parame.IndexOf("(");
            if (nstart > 0)
                return parame.Substring(0, nstart);
            else
                return parame;

        }


        /// <summary>
        /// 获取参数列表
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        private static string tempInfo(string str)
        {
            int nstart = str.IndexOf("(");
            int nend = str.IndexOf(")");
            if (nstart < 0 || nend < 0)
                return "";
            else
                return str.Substring(nstart + 1, nend - nstart - 1);
        }


        /// <summary>
        /// 标签替换
        /// </summary>
        /// <param name="Summary"></param>
        /// <returns></returns>
        public static string ReplaceLable(string LoginName, string strLable)
        {
            //查询内容
            string strSelect;
            strSelect = "top 1 U_UserInfo.*,U_VipGrade.Name";
            //查询条件 
            string strWhere = "where LoginName= '" + LoginName + "' ";
            // 要查询表、视图
            string strTableName = "U_UserInfo left join U_VipGrade on U_UserInfo.GradeID=U_VipGrade.ID";
            // 排序方式
            string strOrderBy = "";
            // 返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            switch (tempTitle(strLable).ToUpper())
            {
                case "COMPANYSUMMARY":  //CompanySummary
                    strBuilder.Append(Lists.Rows[0]["Summary"].ToString());
                    break;
                case "VIPGRADE":  //CompanySummary
                    strBuilder.Append(Lists.Rows[0]["Name"].ToString());
                    break;
                case "LOGO":
                    if (Lists.Rows[0]["Logo"].ToString() != "")
                    {
                        strBuilder.Append(@"<img width='120' height='80' src='");
                        strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[0]["Logo"].ToString()));
                        strBuilder.Append(@"'>");
                    }
                    else
                        strBuilder.Append("");
                    break;
                case "COMPANYNAME":                     //公司名称
                    strBuilder.Append(Lists.Rows[0]["CompanyName"].ToString());
                    break;
                case "SUPPLY":                          //供应
                    strBuilder.Append(Supply(Lists.Rows[0]["UserID"].ToString()));
                    break;
                case "JOB":                            //人才招聘
                    strBuilder.Append(JobList(Lists.Rows[0]["UserID"].ToString()));
                    break;
                case "WEBNAME":                         //商铺名称
                    strBuilder.Append(Lists.Rows[0]["LoginName"].ToString() + Base.BasePage.Config.Rewrite);
                    break;
                case "RECOMMEND":                       //精品推荐
                    strBuilder.Append(Recommend(Lists.Rows[0]["UserID"].ToString(), 1));
                    break;
                case "CONTACT":                         // 联系方式
                    strBuilder.Append(Contact(Convert.ToInt32(Lists.Rows[0]["UserID"].ToString())));
                    break;
                case "LINK_ROW":                        //友情链接竖排
                    strBuilder.Append(Link_Row(Convert.ToInt32(Lists.Rows[0]["UserID"].ToString())));
                    break;
                case "CERTIFY":                         //公司证书 
                    strBuilder.Append(Certify(Convert.ToInt32(Lists.Rows[0]["UserID"].ToString())));
                    break;
                case "PRODUCTTYPE":                     //产品分类
                    strBuilder.Append(ProductType(Convert.ToInt32(Lists.Rows[0]["UserID"].ToString()), LoginName));
                    break;
                case "NEWSLIST":                        //公司新闻
                    string param = "6";
                    string sType = "1";
                    string str = tempInfo(strLable);
                    param = str.Substring(0, str.IndexOf(","));
                    sType = str.Substring(str.IndexOf(",") + 1);
                    strBuilder.Append(NewsList(Convert.ToInt32(Lists.Rows[0]["UserID"].ToString()), LoginName, param, sType));
                    //strBuilder.Append("fh");

                    break;
                case "DETAILEADDRESS":                  //公司详细地址
                    strBuilder.Append(Lists.Rows[0]["Country"].ToString());
                    strBuilder.Append(Lists.Rows[0]["Province"].ToString());
                    strBuilder.Append(Lists.Rows[0]["City"].ToString());
                    strBuilder.Append(Lists.Rows[0]["Area"].ToString());
                    strBuilder.Append(Lists.Rows[0]["Street"].ToString());
                    break;
                case "COMPANYINFO":                    //公司详细信息
                    strBuilder.Append(CompanyInfo(Lists));
                    break;
                case "SEARCHKEY":                     // 站内搜索
                    strBuilder.Append(Search(LoginName));
                    break;
                case "HOMEPAGE":                     //设为首页
                    strBuilder.Append("<a onMouseDown=\"return hcclick('?hctracelog=newsswindex')\"");
                    strBuilder.Append("onclick=\"javascript:this.style.behavior='url(#default#homepage)';");
                    strBuilder.Append("this.setHomePage('{PB_WebURL}Shop/Index/{Shop_WebName}.shtml')\" title=\"设为主页\" style=\"cursor:pointer;\">设为首页</a> | ");
                    strBuilder.Append("<a href=\"{PB_WebURL}Search/SaveFavorites" + Base.BasePage.Config.Rewrite + "?id=" + Lists.Rows[0]["UserID"] + "&Type=company\">收藏此企业</a>");
                    break;
                case "BOTTOM":
                    strBuilder.Append(Bottom(Lists));
                    break;
                case "NEWSINFO":
                    strBuilder.Append(NewsInfo(Lists.Rows[0]["UserID"].ToString()));
                    break;
                default:
                    strBuilder.Append("无此内容！");
                    break;
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 底部信息
        /// </summary>
        /// <param name="dtList">公司表</param>
        /// <returns></returns>
        private static string Bottom(DataTable dtList)
        {
            StringBuilder strBuilder1 = new StringBuilder();
            strBuilder1.Append("<div class=\"bo_class\">");
            strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Index/{Shop_WebName}\">首页</a>&nbsp;&nbsp;|&nbsp;&nbsp;");
            strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Supply/{Shop_WebName}\">供应产品</a>&nbsp;&nbsp;|&nbsp;&nbsp;");
            strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Profile/{Shop_WebName}\">公司介绍</a>&nbsp;&nbsp;|&nbsp;&nbsp;");
            strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Newslist/{Shop_WebName}\">产品动态</a>&nbsp;&nbsp;|&nbsp;&nbsp;");
            strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Certify/{Shop_WebName}\">诚信档案</a>&nbsp;&nbsp;|&nbsp;&nbsp;");
            //strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Onlone/{Shop_WebName}\">在线留言</a>&nbsp;&nbsp;|&nbsp;&nbsp;");
            strBuilder1.Append("<a href=\"{PB_WebURL}Shop/Contact/{Shop_WebName}\">联系方式</a>");
            strBuilder1.Append("</div>");
            strBuilder1.Append("<div>");
            strBuilder1.Append("<p>" + dtList.Rows[0]["CompanyName"].ToString() + "</p>");
            strBuilder1.Append("<p>地址：");
            strBuilder1.Append(dtList.Rows[0]["Country"].ToString());
            strBuilder1.Append(dtList.Rows[0]["Province"].ToString());
            strBuilder1.Append(dtList.Rows[0]["City"].ToString());
            strBuilder1.Append(dtList.Rows[0]["Area"].ToString());
            strBuilder1.Append(dtList.Rows[0]["Street"].ToString());
            strBuilder1.Append("</p>");
            strBuilder1.Append("<p>技术支持：<a href=\"" + "{PB_WEBURL}" + "\"></a>" + "{PB_WEBNAME}" + "</p>");
            strBuilder1.Append("</div>");
            string str = strBuilder1.ToString();
            return str;
        }


        /// <summary>
        /// 公司证书
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        private static string Certify(int UserID)
        {
            string Restr = "";
            //查询内容
            string strSelect;
            strSelect = " Name,Url,Organization,LicenceDate,ExpiryDate";
            //查询条件 
            string strWhere = " where UserID= " + UserID;
            // 要查询表、视图
            string strTableName = " C_Certificate ";
            // 排序方式
            string strOrderBy = " Order by AddDate desc ";
            // 返回查询结果
            DataTable Lists = nspLable.Function.Function.GetDataTable(strSelect, strWhere, strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0)
                strBuilder.Append("还没有相关链接");
            else
            {
                strBuilder.Append("<table width=\"100%\" cellspacing=\"2\" cellpadding\"0\" border=\"0\" class=\"table_zs\">");
                strBuilder.Append("<tr><td bgcolor=\"#9EACB6\">证书图片</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">证书名称</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">发证机构</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">生效日期</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">截止日期</td></tr>");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strBuilder.Append("<tr><td>");
                    strBuilder.Append(@"<a href='");
                    strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Url"].ToString()));
                    strBuilder.Append(@"'target='_blank'><img src='");
                    strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Url"].ToString()));
                    strBuilder.Append(@"' width='120' height='80'></a></td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(@"<a href='");
                    strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Url"].ToString()));
                    strBuilder.Append(@"'target='_blank'>");
                    strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    strBuilder.Append(@"</a></td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(Lists.Rows[i]["Organization"].ToString());
                    strBuilder.Append(@"</td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(Base.Common.DateTransform(Lists.Rows[i]["LicenceDate"].ToString(), 1));
                    strBuilder.Append(@"</td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(Base.Common.DateTransform(Lists.Rows[i]["ExpiryDate"].ToString(), 1));
                    strBuilder.Append(@"</td></tr>");
                } 
                strBuilder.Append(@"</table>");
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 公司供应
        /// </summary>
        /// <param name="UserID">公司ID</param>
        /// <param name="p">获得供应的哪种信息(0：全部信息；1：产品类别信息；2：查询信息)</param>
        /// <returns></returns>
  private static string Supply(string UserID)
        {

            string strType = "";
            string strKey = "";
            if (HttpContext.Current.Request.QueryString.AllKeys.Length == 2)
            {
                if (GetRequest.CheckQueryStringisInt("Type"))
                    strType = HttpContext.Current.Request.QueryString["Type"].ToString();
                else if (HttpContext.Current.Request.QueryString["keywords"] != "" && HttpContext.Current.Request.QueryString["keywords"] != null)
                    strKey = HttpContext.Current.Request.QueryString["keywords"].ToString();
            }
            int Num = 10;         //共显示的条数
            int RowsNum = 5;      //每行显示几条
            int TitleSize = 30;    //标题显示的条数
            //查询内容
            string strSelect;
            strSelect = " ID,Thumbnail as Picture,Name as Title";
            //查询条件 
            string strWhere = "[C_Supply].Verify=1 AND UserID= " + UserID;
            if (strType != "" || strType == null)
                strWhere += " and ProType=" + strType;
            if (strKey != "" || strKey == null)
                strWhere += " and Name like '%" + strKey + "%'";
            // 要查询表、视图
            string strTableName = "C_Supply";
            // 排序方式
            string strOrderBy = " AddDate ";
            int PageIndex = 1;
            if (GetRequest.CheckQueryStringisInt("Page"))
                PageIndex = int.Parse(HttpContext.Current.Request.QueryString["Page"].ToString());
            // 返回查询结果
            DataTable Lists = Pagination.GetDataTable(strWhere.ToString(), strTableName, 1, strOrderBy, strSelect, Num, PageIndex, 0);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0)
                strBuilder.Append("还没有发布信息");
            else
            {
                strBuilder.Append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td>");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    if (i > Num - 1) break; //如果超过显示的条数则跳出。
                    strBuilder.Append("<div class=\"quality\">");
                    strBuilder.Append("<div class=\"flay\"><a href=\"{PB_WebURL}Supply/detail.aspx?ID=");
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                    strBuilder.Append("\" Target=\"_blank");
                    //strBuilder.Append(Target);
                    strBuilder.Append("\">");
                    strBuilder.Append("<img width=\"");
                    strBuilder.Append(80);
                    strBuilder.Append("\" height=\"");
                    strBuilder.Append(100);
                    strBuilder.Append("\" src=\"");
                    strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                    strBuilder.Append("\"></a></div>");
                    strBuilder.Append("<p><a href=\"{PB_WebURL}Supply/detail.aspx?ID=");
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                    strBuilder.Append("\" Target=\"_blank");
                    //strBuilder.Append(Target);
                    strBuilder.Append("\">");
                    if (TitleSize > 0)
                        if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                            strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                        else
                            strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                    else
                        strBuilder.Append(Lists.Rows[i]["title"].ToString());
                    strBuilder.Append(@"</a></p>");

                    strBuilder.Append(@"</div>");
                    if (((i + 1) % RowsNum) == 0)  //换行
                        if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                            strBuilder.Append(@"</td></tr></table> ");
                        else
                            strBuilder.Append(@"</td></tr><tr><td>");
                    else
                        if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                            strBuilder.Append(@"</td></tr></table> ");
                        else
                            strBuilder.Append(@"</td><td>");
                }
            }
            string strUrl = "{PB_WebUrl}Shop/Supply/websen.aspx?Page=";
            if (PageIndex <= 0)
                PageIndex = 1;
            string Pages = "";
            Pages = Pagination.GoToPager(PageIndex, Num, strUrl, strWhere.ToString(), strTableName,0);
            strBuilder.Append(Pages);
            return strBuilder.ToString();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        private static string SupplyList(string UserID)
        {
            return "";
        }


        /// <summary>
        /// 公司简介
        /// </summary>
        /// <param name="Summary"></param>
        /// <returns></returns>
        private static string ComPanySummary(string LoginName)
        {
            //查询内容
            string strSelect;
            strSelect = "top 1 Summary";
            //查询条件 
            string strWhere = "where LoginName= '" + LoginName + "' ";
            // 要查询表、视图
            string strTableName = "U_UserInfo";
            // 排序方式
            string strOrderBy = "";
            // 返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append(Lists.Rows[0]["Summary"].ToString());
            return strBuilder.ToString();
        }


        /// <summary>
        /// 推荐产品
        /// </summary>
        /// <param name="UserID">公司ID</param>
        /// <param name="p">获得供应的哪种信息</param>
        /// <returns></returns>
        private static string Recommend(string UserID, int p)
        {
            string Restr = "";
            int Num = 15;         //共显示的条数
            int RowsNum = 15;      //每行显示几条
            int TitleSize = 8;    //标题显示的条数
            //查询内容
            string strSelect;
            strSelect = " ID,Thumbnail as Picture,Name as Title";
            //查询条件 
            string strWhere = " UserID= '" + UserID + "' AND [C_Supply].Verify=1 AND Recommend=1 ";
            // 要查询表、视图
            string strTableName = "C_Supply";
            // 排序方式
            string strOrderBy = " AddDate ";
            // 返回查询结果
            DataTable Lists = Pagination.GetDataTable(strWhere.ToString(), strTableName, 1, strOrderBy, strSelect, 15, 1, 0);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0)
                strBuilder.Append("还没有发布信息");
            else
            {
                strBuilder.Append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    if (i > Num - 1) break; //如果超过显示的条数则跳出。
                    strBuilder.Append("<div class=\"quality\">");
                    strBuilder.Append("<div class=\"flay\"><a href=\"{PB_WebURL}supply/detail.aspx?ID=");
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                    strBuilder.Append("\" Target=\"_blank\">");
                    strBuilder.Append("<img width=\"");
                    strBuilder.Append(80);
                    strBuilder.Append("\" height=\"");
                    strBuilder.Append(100);
                    strBuilder.Append("\" src=\"");
                    strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                    strBuilder.Append("\"></a></div>");
                    strBuilder.Append("<p><a href=\"{PB_WebURL}supply/detail.aspx?ID=");
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                    strBuilder.Append("\" Target=\"_blank\" class=\"c1\">");
                    if (TitleSize > 0)
                        if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                            strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                        else
                            strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                    else
                        strBuilder.Append(Lists.Rows[i]["title"].ToString());
                    strBuilder.Append(@"</a></p>");

                    strBuilder.Append(@"</div>");

                    if (((i + 1) % RowsNum) == 0)  //换行
                        if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                            strBuilder.Append(@"</td></tr></table> ");
                        else
                            strBuilder.Append(@"</td></tr><tr><td>");
                    else
                        if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                            strBuilder.Append(@"</td></tr></table> ");
                        else
                            strBuilder.Append(@"</td><td>");
                }
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 联系方式
        /// </summary>
        /// <param name="UserID">会员ID</param>
        /// <returns></returns>
        private static string Contact(int UserID)
        {
            //查询内容
            string strSelect;
            strSelect = " * ";
            //查询条件 
            string strWhere = " where UserID= " + UserID;
            // 要查询表、视图
            string strTableName = " U_UserInfo ";
            // 排序方式
            string strOrderBy = " ";
            // 返回查询结果
            DataTable Lists = nspLable.Function.Function.GetDataTable(strSelect, strWhere, strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0)
                strBuilder.Append("还没有会员信息");
            else
            {

                strBuilder.Append(@"<table>");
                strBuilder.Append(@"<tr><td class=""topicLink"">");
                strBuilder.Append(Lists.Rows[0]["LinkName"].ToString());
                strBuilder.Append(@"&nbsp;");
                strBuilder.Append(Lists.Rows[0]["Sex"].ToString());
                strBuilder.Append(@"&nbsp");
                strBuilder.Append(@"（");
                strBuilder.Append(Lists.Rows[0]["Department"].ToString());
                strBuilder.Append(@"&nbsp;&nbsp");
                strBuilder.Append(Lists.Rows[0]["Position"].ToString());
                strBuilder.Append(@"）&nbsp;&nbsp;</td></tr>");
                string strc = "<a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + Lists.Rows[0]["qq"].ToString() + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" /></a>";
                strBuilder.Append(@"<tr><td>" + strc + "</td></tr>");
                strBuilder.Append(@"<ul class=""mainTextColor"">");
                strBuilder.Append(@"<tr><td>电&nbsp;&nbsp;&nbsp;&nbsp;话：" + Lists.Rows[0]["Tel_International"].ToString() + "-" + Lists.Rows[0]["Tel_DistrictNumber"].ToString() + "-" + Lists.Rows[0]["Tel_Telephone"].ToString() + "-" + Lists.Rows[0]["Tel_Ext"].ToString() + "</td></tr>");
                strBuilder.Append(@"<tr><td>移动电话：" + Lists.Rows[0]["MobilePhone"].ToString() + " </td></tr>");
                strBuilder.Append(@"<tr><td>传&nbsp;&nbsp;&nbsp;&nbsp;真：" + Lists.Rows[0]["Fax_International"].ToString() + "-" + Lists.Rows[0]["Fax_DistrictNumber"].ToString() + "-" + Lists.Rows[0]["Fax_Telephone"].ToString() + "-" + Lists.Rows[0]["Fax_Ext"].ToString() + " </td></tr>");
                strBuilder.Append(@"<tr><td>地&nbsp;&nbsp;&nbsp;&nbsp;址：  " + Lists.Rows[0]["Country"].ToString() + " " + Lists.Rows[0]["Province"].ToString() + " " + Lists.Rows[0]["City"].ToString() + " " + Lists.Rows[0]["Area"].ToString() + " " + Lists.Rows[0]["Street"].ToString() + "      </td></tr>");
                strBuilder.Append(@"<tr><td>邮&nbsp;&nbsp;&nbsp;&nbsp;编： " + Lists.Rows[0]["Postalcode"].ToString() + " </td></tr>");
                strBuilder.Append("<tr><td>公司主页：         <a class=\"topicLink draft_no_link\" href=\"" + Lists.Rows[0]["URL"].ToString() + "\" target=\"_blank\">" + Lists.Rows[0]["URL"].ToString() + "</a></td></tr>");
                strBuilder.Append(@"</table>");

            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 版权
        /// </summary>
        /// <returns></returns>
        private static string Copyright(int UserID)
        {
            string Restr = "";
            return Restr;
        }


        /// <summary>
        ///  友情链接竖排
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        private static string Link_Row(int UserID)
        {
            string Restr = "";
            //查询内容
            string strSelect;
            strSelect = " Name,Url,Verify,Logo";
            //查询条件 
            string strWhere = " where Verify=1 AND UserID= " + UserID;
            // 要查询表、视图
            string strTableName = " U_UserLink ";
            // 排序方式
            string strOrderBy = " Order by AddDate desc ";
            // 返回查询结果
            DataTable Lists = nspLable.Function.Function.GetDataTable(strSelect, strWhere, strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0)
                strBuilder.Append("暂时没有添加友情链接！");
            else
            {
                strBuilder.Append("<table width='100%'>");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strBuilder.Append("<tr><td>");
                    strBuilder.Append(@"<a href='");
                    strBuilder.Append(Lists.Rows[i]["Url"].ToString());
                    strBuilder.Append(@"'>");
                    strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    strBuilder.Append(@"</a></td></tr>");
                }
                strBuilder.Append(@"</table>");
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 公司详细信息
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        private static string CompanyInfo(DataTable strTable)
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<table width='100%'>");

            strBuilder.Append(@"<tr>");
            strBuilder.Append(@"<td width='17%'>主营产品或服务：</td><td width='33%'>" + strTable.Rows[0]["Product"].ToString() + @"</td>");     //主营产品或服务
            strBuilder.Append(@"<td width='17%'>主营行业：</td><td width='33%'>" + strTable.Rows[0]["Industry"].ToString() + @"</td>");           //主营行业
            strBuilder.Append(@"</tr><tr>");
            strBuilder.Append(@"<td width='17%'>企业类型：</td><td width='33%'>" + strTable.Rows[0]["CompanyName"].ToString() + @"</td>");     //企业类型
            strBuilder.Append(@"<td width='17%'>经营模式：</td><td width='33%'>" + strTable.Rows[0]["BusinessModel"].ToString() + @"</td>");     //经营模式
            strBuilder.Append(@"</tr><tr>");
            strBuilder.Append(@"<td width='17%'>注册地址：</td><td width='33%'>" + strTable.Rows[0]["RegisterAddress"].ToString() + @"</td>");     //注册地址
            strBuilder.Append(@"<td width='17%'>经营地址：</td><td width='33%'>" + strTable.Rows[0]["DealinAdd"].ToString() + @"</td>");     //经营地址
            strBuilder.Append(@"</tr><tr>");
            strBuilder.Append(@"<td width='17%'>经营品牌：</td><td width='33%'>" + strTable.Rows[0]["CompanyName"].ToString() + @"</td>");     //经营品牌
            strBuilder.Append(@"<td width='17%'>法定代表人/负责人：</td><td width='33%'>" + strTable.Rows[0]["Corporate"].ToString() + @"</td>");     //法定代表人/负责人
            strBuilder.Append(@"</tr><tr>");
            strBuilder.Append(@"<td >公司主页：</td>");     //主营产品或服务
            strBuilder.Append(@"<td colspan='3' ><a href='{PB_WebURL}Shop/index/" + strTable.Rows[0]["LoginName"].ToString() + @".html'>{PB_WebURL}Shop/index/" + strTable.Rows[0]["LoginName"].ToString() + @".html</a></td>");     //主营行业
            strBuilder.Append(@"</tr>");

            strBuilder.Append(@"</table>");

            return strBuilder.ToString();
        }


        /// <summary>
        /// 产品分类
        /// </summary>
        /// <param name="Summary"></param>
        /// <returns></returns>
        private static string ProductType(int UserID, string LoginName)
        {
            string strType = HttpContext.Current.Request.QueryString["Type"];
            //查询内容
            string strSelect;
            strSelect = "ID,Name";
            //查询条件 
            string strWhere = "where UserID= " + UserID;
            // 要查询表、视图
            string strTableName = "C_ProType";
            // 排序方式
            string strOrderBy = "order by Sequence desc";
            // 返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();

            if (Lists.Rows.Count > 0)
            {
                strBuilder.Append("<div class=\"bodyContent\"><ul>");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strBuilder.Append("<li>");
                    strBuilder.Append("<a href=\"../Supply/" + LoginName + Base.BasePage.Config.Rewrite + "?Type=" + Lists.Rows[i]["ID"].ToString() + "\">");
                    strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    strBuilder.Append(@"</a>");
                    strBuilder.Append(@"</li>");
                }
                strBuilder.Append("</ul></div><div class=\"clr\"></div>");
            }
            else
            {
                strBuilder.Append(@"该会员没有产品分类");
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 公司新闻
        /// </summary>
        /// <param name="Summary"></param>
        /// <returns></returns>
        private static string NewsList(int UserID, string LoginName, string parame, string strType)
        {
            //string strType = HttpContext.Current.Request.QueryString["Type"];
            //查询内容
            string strSelect = "";
            if (parame != "" && parame != "0")
            {
                strSelect += " top " + parame;
            }
            strSelect += " ID,Title,Adddate";
            //查询条件 
            string strWhere = "where Verify=1 AND UserID= " + UserID;
            // 要查询表、视图
            string strTableName = "C_News";
            // 排序方式
            string strOrderBy = " ";
            // 返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();

            if (Lists.Rows.Count > 0)
            {
                strBuilder.Append("<table width=\"100%\" border=\"0\" cellsapcing=\"0\" cellpadding=\"0\">");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strBuilder.Append(@"<tr><td>");
                    strBuilder.Append(@"·<a href='../NewsInfo/" + LoginName + Base.BasePage.Config.Rewrite + "?id=" + Lists.Rows[i]["ID"].ToString() + "'>");
                    strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                    strBuilder.Append(@"</a></td>");
                    if (strType.ToUpper() != "1")
                    {
                        strBuilder.Append("<td align=\"right\">" + Lists.Rows[i]["Adddate"].ToString() + "</td>");
                    }
                    strBuilder.Append(@"</tr>");
                }
                strBuilder.Append(@"</table>");
            }
            else
            {
                strBuilder.Append(@"暂无公司新闻");
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 站内收索
        /// </summary>
        /// <param name="pathName">模板路径</param>
        /// <returns></returns>
        private static string Search(string LoginName)
        {

            string PathName = AppDomain.CurrentDomain.BaseDirectory.ToString() + "Shops/search.js";
            StringBuilder builder = new StringBuilder();
            string str = "";
            using (StreamReader reader = new StreamReader(PathName, Encoding.Default))
            {
                StringBuilder builder2 = new StringBuilder();
                builder2.Append(reader.ReadToEnd());
                reader.Close();
                str = builder2.ToString().Replace("{SHOP_ReURL}", "../Supply/" + LoginName + Base.BasePage.Config.Rewrite + "?keywords=");
            }
            return str;
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        private static string NewsInfo(string UserID)
        {
            string strType = HttpContext.Current.Request.QueryString["id"];
            //查询内容
            string strSelect = "";
            strSelect += " ID,Title,Info,Adddate";
            //查询条件 
            string strWhere = "where verify=1 and UserID= " + UserID + " and id=" + strType;
            // 要查询表、视图
            string strTableName = "C_News";
            // 排序方式
            string strOrderBy = " ";
            // 返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count > 0)
            {
                strBuilder.Append("<ul><li class=\"t\">");
                strBuilder.Append(Lists.Rows[0]["Title"].ToString());
                strBuilder.Append("</li><li class=\"c\">");
                strBuilder.Append(Lists.Rows[0]["Info"].ToString());
                strBuilder.Append("</li></ul>");
            }
            else
            {
                strBuilder.Append("<ul><li>该公司动态不存在或没有通过审核！</li></ul>");
            }
            return strBuilder.ToString();
        }

        /// <summary>
        /// 企业招聘列表
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        private static string JobList(string UserID)
        {
            //查询内容
            string strSelect = " [C_Job].*,[C_JobType].TypeName ";
            //查询条件 
            string strWhere = "WHERE [C_Job].Verify=1 AND [C_Job].UserID= " + UserID + " AND [C_Job].TypeID=[C_JobType].ID";
            // 要查询表、视图
            string strTableName = " [C_Job],[C_JobType] ";
            // 排序方式
            string strOrderBy = " ";
            // 返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count > 0)
            {
                strBuilder.Append("<table width=\"100%\" cellspacing=\"2\" cellpadding\"0\" border=\"0\" class=\"table_zs\">");
                strBuilder.Append("<tr><td bgcolor=\"#9EACB6\">招聘类别</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">招聘职位</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">招聘人数</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">生效日期</td>");
                strBuilder.Append("<td bgcolor=\"#9EACB6\">截止日期</td></tr>");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strBuilder.Append("<tr><td>");
                    strBuilder.Append("<a href=\"{PB_WebUrl}Job/JobTrade-" + Lists.Rows[i]["TypeID"].ToString() + BasePage.Config.Rewrite + "\">" + Lists.Rows[i]["TypeName"].ToString() + "</a>");
                    strBuilder.Append(@"</td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append("<a href=\"{PB_WEBURL}Job/JobDetail-" + Lists.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite + "\">" + Lists.Rows[i]["Position"].ToString() + "</a>");
                    strBuilder.Append(@"</td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(Lists.Rows[i]["Count"].ToString());
                    strBuilder.Append(@"</td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString());
                    strBuilder.Append(@"</td>");

                    strBuilder.Append("<td>");
                    strBuilder.Append(DateTime.Parse(Lists.Rows[i]["EndDate"].ToString()).ToShortDateString());
                    strBuilder.Append(@"</td></tr>");
                }
                strBuilder.Append(@"</table>");
            }
            else
            {
                strBuilder.Append("<ul><li>该公司暂时没有招聘信息!</li></ul>");
            }
            return strBuilder.ToString();
        }
    }
}
