﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using System.Text;

namespace nspLable.Function.Systems
{
    /// <summary>
    /// Agent 的摘要说明
    /// </summary>
    public class clsAgentLable
    {

        /// <summary>
        /// 取得数据信息STR
        /// </summary>
        /// <param name="a"></param>
        /// <param name="TypeID"></param>
        /// <param name="Num"></param>
        /// <param name="AgeAttribute"></param>
        /// <param name="ShowType"></param>
        /// <param name="OrderBy"></param>
        /// <returns></returns>
        private static DataTable GetTable(string TypeID, int Num, string isRecommend, string ShowType, string OrderBy)
        {

            string strSelect = "";             //需要取得的数据           
            string strTableName = "";        //要查询的表、视图、存储过程           
            string strWhere = "where  verify=1 ";   //查询条件            
            string strOrder = "";            // 排序方式

            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1 ";
            else
                strSelect = " top " + Num;
            strSelect += " W_SincereAgent.ID as ID ,W_SincereAgent.Title as Name,AddDate ";
            strTableName = "W_SincereAgent";
            if (TypeID != "0")
                strWhere += " AND AgentType=" + TypeID;
            if (isRecommend == "1")
                strWhere += " AND Recommend=1 ";
            else if (isRecommend == "2")
                strWhere += " AND Recommend!=1 ";
            if (ShowType == "1")
            {
                strSelect += ",W_AgentType.Name as TypeName";
                strTableName += ", W_AgentType";
                strWhere += "and W_AgentType.ID=W_SincereAgent.AgentType";
            }

            switch (OrderBy)
            {
                case "0":
                    strOrder = "order by ID desc";
                    break;
                case "1":
                    strOrder = "order by ID asc";
                    break;
                case "2":
                    strOrder = "order by  AddDate asc";
                    break;
                case "3":
                    strOrder = "order by  AddDate desc";
                    break;

            }

            //获取数据表
            DataTable Lists = Function.GetDataTable(strSelect, strWhere, strTableName, strOrder);
            return Lists;
        }


        /// <summary>
        /// 取得数据信息PIC
        /// </summary>
        /// <param name="a"></param>
        /// <param name="TypeID"></param>
        /// <param name="Num"></param>
        /// <param name="AgeAttribute"></param>
        /// <param name="ShowType"></param>
        /// <param name="OrderBy"></param>
        /// <returns></returns>
        private static DataTable GetTable1(string TypeID, int Num, string AgeAttribute,  string OrderBy)
        {

            string strSelect = "";             //需要取得的数据           
            string strTableName = "";        //要查询的表、视图、存储过程           
            string strWhere = "where Picture !='' and verify=1 ";   //查询条件            
            string strOrder = "";            // 排序方式

            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1 ";
            else
                strSelect = " top " + Num;
            strSelect += " W_SincereAgent.ID as ID ,Name,Picture ";
            strTableName = "W_SincereAgent";

            if (AgeAttribute == "1")
                strWhere += "and Recommend = 1 ";
            if (TypeID != "0")
                strWhere += "AND AgentType=" + TypeID;
            switch (OrderBy)
            {
                case "0":
                    strOrder = "order by ID desc";
                    break;
                case "1":
                    strOrder = "order by  ID asc";
                    break;
                case "2":
                    strOrder = "order by  AddDate asc";
                    break;
                case "3":
                    strOrder = "order by  AddDate desc";
                    break;
            }

            //获取数据表
            DataTable Lists = Function.GetDataTable(strSelect, strWhere, strTableName, strOrder);
            return Lists;
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="Array（13）">
        /// IndType      类型[0：招商，1：加盟]
        /// TypeID       行业类别
        /// Num	         信息列表数目	
        /// RowsNum	     每行的列数	
        /// AgeAttribute 信息列表属性	
        /// WhitchType	 列表显示样式[0:只有图片，1: 图文]
        /// PicHeight	 图片宽度	
        /// PicWidth	 图片高度	
        /// PicClass	 图片样式	
        /// TitleSize	 标题最多字符数	
        /// TitleClass	 标题样式
        /// OrderBy	     排序方式[0：ID升序；1：ID降序；2：时间升序；3：时间降序]		
        /// Target       链接目标
        /// <returns></returns>
        /// <returns></returns>
        public static string SY_AgentList_Pic(TSystemLable Array)
        {
            int PicWidth = 0;
            int PicHight = 0;

            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 13) throw new Exception(Function.ErrInfo(0));

            string IndType = strContent[0].ToString();
            string TypeID = strContent[1].ToString();
            int Num = strContent[2].ToString().Length > 0 ? Convert.ToInt32(strContent[2].ToString()) : 0;
            int RowsNum = strContent[3].ToString().Length > 0 ? Convert.ToInt32(strContent[3].ToString()) : 0;
            string AgeAttribute = strContent[4].ToString();
            string WhitchType = strContent[5].ToString();
            if (strContent[6].ToString().Trim() != "") PicWidth = Convert.ToInt32(strContent[6].ToString());
            if (strContent[7].ToString().Trim() != "") PicHight = Convert.ToInt32(strContent[7].ToString());
            string PicClass = strContent[8].ToString();
            int TitleSize = strContent[10].ToString().Length > 0 ? Convert.ToInt32(strContent[10].ToString()) : 0;
            string TitleClass = strContent[9].ToString();
            string OrderBy = strContent[11].ToString();
            string Target = strContent[12].ToString();
            string str = "{PB_WebURL}Agent/";
            if (IndType == "1")
                str += "Detail-";
            else
                str += "Detail-";
            DataTable Lists = GetTable1(TypeID, Num, AgeAttribute, OrderBy);
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0) return "没有相关产品";
            strBuilder.Append("<div class=\"" + PicClass + "\"><ul>");
            for (int i = 0; i < Lists.Rows.Count; i++)
            {
                if (i > Num - 1) break; //如果超过显示的条数则跳出。
                if (WhitchType != "0" && WhitchType != "1") WhitchType = "0";
                strBuilder.Append("<li>");
                strBuilder.Append("<a href=\"" + str + Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                strBuilder.Append("\" Target=\"" + Target + "\">");
                strBuilder.Append("<img width=\"" + PicWidth + "\" height=\"" + PicHight);
                strBuilder.Append("\" src=\"" + Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()) + "\"></a>");
                if (WhitchType == "1") //是否显示标题
                {
                    strBuilder.Append("<p><a href=\"" + str);
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                    strBuilder.Append("\" Target=\"");
                    strBuilder.Append(Target);
                    strBuilder.Append("\">");
                    if (TitleSize > 0)
                        if (Lists.Rows[i]["Name"].ToString().Length > TitleSize)
                            strBuilder.Append(Function.GetString(Lists.Rows[i]["Name"].ToString(), TitleSize));
                        else
                            strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    else
                        strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    strBuilder.Append(@"</a></p>");
                }
                strBuilder.Append("</li>");
            }
            strBuilder.Append("</ul></div>");
            return strBuilder.ToString();
        }


        /// <summary>
        /// 招商加盟文字标签
        /// </summary>
        /// <param name="Array(12)">
        /// IndType	    信息类型[0：招商、1：加盟]		
        /// TypeID	    信息分类
        /// Num	        显示条数
        /// RowsNum	    每行显示条数	
        /// TitleSize	标题字数
        /// TitleClass	标题样式	
        /// Target	    链接目标
        /// ShowType	是否显示类别
        /// TypeClass	类别样式	
        /// ShowDate	是否显示日期	
        /// DateClass	日期格式
        /// </param>
        /// <returns></returns>
        public static string SY_AgentList_Str(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });
            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 13) throw new Exception(Function.ErrInfo(0));
            string IndType = strContent[0].ToString();
            string TypeID = strContent[1].ToString();
            int Num = strContent[2].ToString().Length > 0 ? Convert.ToInt32(strContent[2].ToString()) : 0;
            int RowsNum = strContent[3].ToString().Length > 0 ? Convert.ToInt32(strContent[3].ToString()) : 0;
            //string AgeAttribute = strContent[4].ToString();
            string AgeAttribute = "1";
            int TitleSize = strContent[4].ToString().Length > 0 ? Convert.ToInt32(strContent[4].ToString()) : 0;
            string TitleClass = strContent[5].ToString();
            string Target = strContent[6].ToString();
            string ShowType = strContent[7].ToString();
            string isRecommend = strContent[8].ToString();
            string TypeClass = strContent[9].ToString();
            string ShowDate = strContent[10].ToString();
            string DateClass = strContent[11].ToString();
            string OrderBy = strContent[12].ToString();
            string str = "{PB_WebURL}Agent/";
            string str1 = "{PB_WebURL}Agent/";
            if (IndType == "1")
            {
                str += "Detail-";
                str1 += "Trade-";
            }
            else
            {
                str += "Detail-";
                str1 += "Trade-";
            }
            DataTable Lists = GetTable(TypeID, Num, isRecommend, ShowType, OrderBy);
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<div class=\"" + TitleClass + "\"><ul>");
            if (Lists.Rows.Count <= 0) return "没有相关产品";
            for (int i = 0; i < Lists.Rows.Count; i++)
            {
                if (i > Num - 1) break; //如果超过显示的条数则跳出。
                strBuilder.Append("<li>");
                if (ShowDate == "1")  //是否显示时间
                {
                    strBuilder.Append(@"<span>");
                    strBuilder.Append(Function.DateTransform(Lists.Rows[i]["AddDate"].ToString(), DateClass));
                    strBuilder.Append(@"</span>");
                }
                if (ShowType == "1")  //是否显示类型
                {
                    strBuilder.Append(@"[<a href='" + str1);
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                    strBuilder.Append(@"' Target='");
                    strBuilder.Append(Target);
                    strBuilder.Append(@" '>");
                    strBuilder.Append(Lists.Rows[i]["TypeName"].ToString());
                    strBuilder.Append(@"</a>] ");
                }
                if (true) //显示标题
                {
                    strBuilder.Append("<a href=\"" + str);
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                    strBuilder.Append("\" Target=\"");
                    strBuilder.Append(Target);
                    strBuilder.Append("\">");
                    if (TitleSize > 0)
                        if (Lists.Rows[i]["Name"].ToString().Length > TitleSize)
                        {
                            strBuilder.Append(Function.GetString(Lists.Rows[i]["Name"].ToString(), TitleSize));
                        }
                        else
                        {
                            strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                        }
                    else
                    {
                        strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    }
                    strBuilder.Append(@"</a>");
                }
                strBuilder.Append("</li>\r\n");
            }
            strBuilder.Append("</ul></div>");
            return strBuilder.ToString();
        }


        /// <summary>
        /// 创业金额标签
        /// </summary>
        /// <param name="TypeID">信息分类</param>
        /// <param name="TitleClass">标题样式</param>
        /// <returns></returns>
        public static string SY_AgentPrice(TSystemLable Array)
        {
            string[] str;
            Base.XMLProcess xml = new Base.XMLProcess("xml/AgentPrice.xml");
            str = xml.ReadAllChildallValue("/agent");
            StringBuilder strBuilder = new StringBuilder();
            if (str.Length < 1)
                return "没有值";
            else
            {
                strBuilder.Append(@"<table width='100%'><tr><td>");
                for (int i = 0; i < str.Length; i++)
                {
                    strBuilder.Append("<td>");
                    strBuilder.Append(str[i].ToString());
                    strBuilder.Append("</td>");
                }
                strBuilder.Append(@"</tr></table>");
            }
            return strBuilder.ToString();
        }


        /// <summary>
        /// 招商分类页列表
        /// </summary>
        /// <param name="Array"></param>
        /// <param name="strModule"></param>
        /// <returns></returns>
        public static string DIY_Tradelist(TSystemLable Array, string strModule)
        {
            // 对标签使用条件进行检查
            //if (strModule == "" || strModule != "Wagent_Trade") throw new Exception(Function.ErrInfo(2));
            int TypeID = 0;
            if (HttpContext.Current.Request.QueryString["id"] != null && HttpContext.Current.Request.QueryString["id"] != "")
            {
                if (Base.Common.CheckNum(HttpContext.Current.Request.QueryString["ID"]))
                {
                    TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                }
            }
            if (TypeID < 0) throw new Exception(Function.ErrInfo(1));

            // 定义全局变量，最后返回
            StringBuilder ReBulider = new StringBuilder();

            // 求购列表头部
            string strHead = "";
            strHead = Array.Head;
            ReBulider.Append(strHead);


            // 获取求购信息
            string strWhere = "";

            if (TypeID != 0)
            {
                strWhere = " AgentType= " + TypeID;
            }
            string strTable = "W_SincereAgent inner join  U_UserInfo on U_UserInfo.UserID=W_SincereAgent.UserID";
            int OrderType = 1;
            string OrderField = "AddDate";
            string strSelect = " W_SincereAgent.ID,W_SincereAgent.Detail,W_SincereAgent.Name,W_SincereAgent.Picture,W_SincereAgent.AddDate,W_SincereAgent.UserID,U_UserInfo.QQ,U_UserInfo.CompanyName,U_UserInfo.LoginName,U_UserInfo.City,U_UserInfo.GradeID,U_UserInfo.Province ";
            int PageSize = 10;        //每页显示几条
            int PageIndex = 1;        //第几页
            if (HttpContext.Current.Request.QueryString["Page"] != null || HttpContext.Current.Request.QueryString["Page"] != "")
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;  //默认不需改动
            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);

            if (Lists.Rows.Count <= 0)
            {
                ReBulider.Append("暂无此类产品");
            }
            else
            {
                string strInfo = Array.Content.ToString();
                string[] strAtttibute = Function.GetAttribute(strInfo);
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strInfo = Array.Content.ToString();
                    for (int j = 0; j < strAtttibute.Length; j++)
                    {
                        //if (i > Num - 1) break; //如果超过显示的条数则跳出。
                        switch (strAtttibute[j].ToString())
                        {
                            case "{PR:WS_ID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["ID"].ToString());
                                break;
                            case "{PR:WS_UserID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["UserID"].ToString());
                                break;
                            case "{PR:WS_Name}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Name"].ToString());
                                break;
                            case "{PR:WS_AddDate}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Base.Common.GetShortDate(Lists.Rows[i]["AddDate"].ToString()));
                                break;
                            case "{PR:WS_Area}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Province"].ToString() + " " + Lists.Rows[i]["City"].ToString());
                                break;
                            case "{PR:WS_GradeName}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["GradeID"].ToString());
                                break;
                            case "{PR:WS_Detail}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.GetString(Base.Common.ClearHtml(Lists.Rows[i]["Detail"].ToString()), 60));
                                break;
                            case "{PR:WS_CompanyName}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["CompanyName"].ToString());
                                break;
                            case "{PR:WS_Galaxiechat}":           //在线交流
                                string str1 = Lists.Rows[i]["QQ"].ToString();
                                string str = "";
                                if (str1 != "")
                                    str = "<a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + str1 + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" /></a>";
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), str);
                                break;
                            case "{PR:WS_Title}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Title"].ToString());
                                break;
                            case "{PR:WS_Picture}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                                break;
                            case "{PR:WS_DetailUrl}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "Detail-" + Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_CheckInfo}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<input id=\"compareBox" + i + "\" type=\"checkbox\" value=\"\" name=\" " + Lists.Rows[i]["id"].ToString() + " \" onclick=\"clickcompareBox(" + Lists.Rows[i]["id"].ToString() + ",this)\" memberId=\"stfseal\">");
                                break;
                            case "{PR:WS_CompanyUrl}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WebUrl}Shop/index/" + Lists.Rows[i]["LoginName"].ToString() + Base.BasePage.Config.Rewrite);
                                break;
                        }
                    }
                    ReBulider.Append(strInfo);
                }
            }

            //求购列表尾部
            string strFooter = "";
            strFooter = Array.Footer;
            ReBulider.Append(strFooter);
            string strLink = "{PB_WebURL}Agent/Trade-" + TypeID + "-p";
            // 分页链接
            string Pages = Pagination.GoToPager(PageIndex, 10, strLink, strWhere, strTable);
            ReBulider.Append(Pages);
            return ReBulider.ToString();
        }


        /// <summary>
        /// 加盟分类页列表
        /// </summary>
        /// <param name="Array"></param>
        /// <param name="strModule"></param>
        /// <returns></returns>
        public static string DIY_STradelist(TSystemLable Array, string strModule)
        {
            // 对标签使用条件进行检查
            //if (strModule == "" || strModule != "Wagent_Trade") throw new Exception(Function.ErrInfo(2));
            int TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (TypeID <= 0) throw new Exception(Function.ErrInfo(1));

            // 定义全局变量，最后返回
            StringBuilder ReBulider = new StringBuilder();

            // 求购列表头部
            string strHead = "";
            strHead = Array.Head;
            ReBulider.Append(strHead);


            // 获取求购信息
            string strWhere = " AgentType= " + TypeID + " and W_SincereAgent.verify=1 ";
            string strTable = "W_SincereAgent inner join  U_UserInfo on U_UserInfo.UserID=W_SincereAgent.UserID";
            int OrderType = 1;
            string OrderField = "AddDate";
            string strSelect = " W_SincereAgent.ID,W_SincereAgent.Detail,W_SincereAgent.Name,W_SincereAgent.Picture,W_SincereAgent.AddDate,W_SincereAgent.UserID,U_UserInfo.QQ,U_UserInfo.CompanyName,U_UserInfo.LoginName,U_UserInfo.City,U_UserInfo.GradeID,U_UserInfo.Province ";
            int PageSize = 10;        //每页显示几条
            int PageIndex = 1;        //第几页
            if (HttpContext.Current.Request.QueryString["PageID"] == null)
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["PageID"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;  //默认不需改动
            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);

            if (Lists.Rows.Count < 0)
            {
                ReBulider.Append("暂无此类产品");
            }
            else
            {
                string strInfo = Array.Content.ToString();
                string[] strAtttibute = Function.GetAttribute(strInfo);
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    strInfo = Array.Content.ToString();
                    for (int j = 0; j < strAtttibute.Length; j++)
                    {
                        //if (i > Num - 1) break; //如果超过显示的条数则跳出。
                        switch (strAtttibute[j].ToString())
                        {
                            case "{PR:WS_ID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["ID"].ToString());
                                break;
                            case "{PR:WS_UserID}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["UserID"].ToString());
                                break;
                            case "{PR:WS_Name}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Name"].ToString());
                                break;
                            case "{PR:WS_AddDate}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Base.Common.GetShortDate(Lists.Rows[i]["AddDate"].ToString()));
                                break;
                            case "{PR:WS_Area}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Province"].ToString() + " " + Lists.Rows[i]["City"].ToString());
                                break;
                            case "{PR:WS_GradeName}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["GradeID"].ToString());
                                break;
                            case "{PR:WS_Detail}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.GetString(Base.Common.ClearHtml(Lists.Rows[i]["Detail"].ToString()), 60));
                                break;
                            case "{PR:WS_CompanyName}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["CompanyName"].ToString());
                                break;
                            case "{PR:WS_Galaxiechat}":              //在线交流
                                string str1 = Lists.Rows[i]["QQ"].ToString();
                                string str = "";
                                if (str1 != "")
                                    str = "<a target=\"blank\" href=\"http://wpa.qq.com/msgrd?V=1&Uin=" + str1 + "&Exe=QQ&Site=im.qq.com&Menu=No\"><img style=\" border:0\" src=\"{pb_weburl}images/b_online.gif\" alt=\"给我发消息\" /></a>";
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), str);
                                break;
                            case "{PR:WS_Title}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Title"].ToString());
                                break;
                            case "{PR:WS_Picture}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Picture"].ToString());
                                break;
                            case "{PR:WS_DetailUrl}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "WDetail-" + Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                                break;
                            case "{PR:WS_CheckInfo}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "<input id=\"compareBox" + i + "\" type=\"checkbox\" value=\"\" name=\" " + Lists.Rows[i]["id"].ToString() + " \" onclick=\"clickcompareBox(" + Lists.Rows[i]["id"].ToString() + ",this)\" memberId=\"stfseal\">");
                                break;
                            case "{PR:WS_CompanyUrl}":
                                strInfo = strInfo.Replace(strAtttibute[j].ToString(), "{PB_WebUrl}Shop/" + Lists.Rows[i]["LoginName"].ToString() + Base.BasePage.Config.Rewrite);
                                break;
                        }
                    }
                    ReBulider.Append(strInfo);
                }
            }

            //求购列表尾部
            string strFooter = "";
            strFooter = Array.Footer;
            ReBulider.Append(strFooter);
            string strLink = "{PB_WebURL}Purchase/Trade.aspx?ID=" + TypeID + "&PageID";
            // 分页链接
            string Pages = Pagination.GoToPager(PageIndex, 10, strLink, strWhere, strTable);
            ReBulider.Append(Pages);
            return ReBulider.ToString();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="p">会员ID</param>
        /// <param name="param">要查找的字段</param>
        /// <returns></returns>
        private static string GetUserInfo(int p, string param)
        {
            string Restr = "";
            UserInfo.TUserInfo Items = new UserInfo.RUserInfo().GateItem(p);
            if (Items.UserID == 0)
            {
                // HttpContext.Current.Response.Redirect("/Error.aspx");
                return "";
            }


            switch (param.ToUpper())
            {
                case "AREA":               //地区
                    if (Items.Country == "中国")
                        Restr += Items.Province + " " + Items.City;
                    else
                        Restr += Items.Country;
                    break;
                case "COMPANYNAME":        //公司名称
                    Restr += Items.CompanyName;
                    break;
                case "LOGINNAME":          //会员名称
                    Restr += Items.LoginName;
                    break;
                case "QQ":                //QQ
                    Restr += Items.QQ;
                    break;
                case "GRADE":             //会员等级
                    DataTable Grade = new VipGrade.RVipGrade().GetDataTable(Convert.ToInt32(Items.GradeID.ToString()));
                    Restr += Grade.Rows[0]["Name"].ToString();
                    break;
                case "BUSINESSMODEL":
                    Restr += Items.BusinessModel.ToString();
                    break;
                case "STARTDATE":
                    Restr += Items.StartDate.ToString();
                    break;
            }
            return Restr.ToString();
        }


        /// <summary>
        /// 招商加盟首页
        /// </summary>
        /// <param name="Restr"></param>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_AgentIndex(string Restr, string str)
        {
            Restr = Restr.Replace("{PR_KEYWORD}", "招商加盟信息");
            return Restr;
        }


        /// <summary>
        /// 招商分类页
        /// </summary>
        /// <param name="Restr"></param>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_AgentSTrade(string Restr, string str)
        {
            Restr = Restr.Replace("{PR_KEYWORD}", "招商加盟信息");
            return Restr;
        }


        /// <summary>
        /// 加盟分类页
        /// </summary>
        /// <param name="Restr"></param>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_AgentWTrade(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int ID = 0;
            if (HttpContext.Current.Request.QueryString["id"] != null && HttpContext.Current.Request.QueryString["id"] != "")
            {
                if (Base.Common.CheckNum(HttpContext.Current.Request.QueryString["ID"]))
                {
                    ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                }
            }
            if (ID < 0) throw new Exception(Function.ErrInfo(1));
            Agent.TAgentType Items = new Agent.RAgentType().GateItem(ID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break;
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break;
                        case "{PR_METAKEYWORDS}":              //MATE关键字
                            Restr = Restr.Replace(strArray[i].ToString(), Base.XMLProcess.Read("Xml/Meta.xml", "/config/meta[@typeid='expo_trade']/keywords"));
                            break;
                        case "{PR_METADESCRIPTION}":          //MATE
                            Restr = Restr.Replace(strArray[i].ToString(), Base.XMLProcess.Read("Xml/Meta.xml", "/config/meta[@typeid='expo_trade']/descriptions"));
                            break;
                        case "{PR_LOWERTYPE}":          //MATE
                            Restr = Restr.Replace(strArray[i].ToString(), GetType("SWill"));
                            break;
                        //case "{PR_MESSAGE}":          //MATE
                        //    Restr = Restr.Replace(strArray[i].ToString(), "<a href=\"/Search/SendMessage"+Base.BasePage.Config.Rewrite+"?ID="+  +"\">点此留言</a>");
                        //    break;
                        default:

                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }


        /// <summary>
        /// 加盟详细页
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="Restr"></param>
        /// <param name="str"></param>
        public static string PR_AgentSDetail(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');

            int ID = Function.StringtoIntforQueryString("id");
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));

            // 获取代理信息
            string strWhere = " W_SincereAgent.AgentType=W_AgentType.ID and  W_SincereAgent.ID= " + ID;
            string strTable = "W_SincereAgent,W_AgentType";
            int OrderType = 1;
            string OrderField = "W_SincereAgent.AddDate";
            string strSelect = " W_SincereAgent.ID,W_SincereAgent.Name,W_SincereAgent.Title,W_SincereAgent.AgentType,W_SincereAgent.AddDate,W_AgentType.Name as TypeName ";
            int PageSize = 1;        //每页显示几条
            int PageIndex = 1;        //第几页
            if (HttpContext.Current.Request.QueryString["PageID"] == null)
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["PageID"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;  //默认不需改动
            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);


            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            Agent.TSincereAgent Items = new Agent.RSincereAgent().GateItem(ID);
            if (Items.UserID == 0) {
                HttpContext.Current.Response.Write("<script>location.href='/Error.aspx?err=5';</script>");
            }
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Title);
                            break;
                        case "{PR_METAKEYWORDS}":              //MATE关键字
                            Restr = Restr.Replace(strArray[i].ToString(), Base.XMLProcess.Read("Xml/Meta.xml", "/config/meta[@typeid='expo_trade']/keywords"));
                            break;
                        case "{PR_METADESCRIPTION}":          //MATE
                            Restr = Restr.Replace(strArray[i].ToString(), Base.XMLProcess.Read("Xml/Meta.xml", "/config/meta[@typeid='expo_trade']/descriptions"));
                            break;
                        case "{PR_NAME}":              //MATE
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Name);
                            break;
                        case "{PR_TYPELINK}":          //类别链表
                            Restr = Restr.Replace(strArray[i].ToString(), "<a href=\"index" + Base.BasePage.Config.Rewrite + "\">首页</a>" + "  >  <a href=\"Trade-" + Lists.Rows[0]["AgentType"].ToString() + Base.BasePage.Config.Rewrite + "\">" + Lists.Rows[0]["TypeName"].ToString() + "</a>  >  " + Lists.Rows[0]["Name"].ToString());
                            break;
                        case "{PR_MESSAGE}":           //留言链接
                            Restr = Restr.Replace(strArray[i].ToString(), "/Search/SendMessage" + Base.BasePage.Config.Rewrite + "?ID=" + Lists.Rows[0]["ID"].ToString());
                            break;
                        case "{PR_USERGRADE}":              //会员等级
                            Restr = Restr.Replace(strArray[i].ToString(), GetUserInfo(Items.UserID, "grade"));
                            break;
                        case "{PR_COUNTYEAR}":               //第几年
                            string year = "1";
                                if (Items.UserID != 0)
                                {
                                    DateTime StartDate = DateTime.Parse(GetUserInfo(Items.UserID, "StartDate"));
                                    if (((DateTime.Now.Year) - (StartDate.Year)) == 0)
                                        year = "1";
                                    else if (((DateTime.Now.Year) - (StartDate.Year)) > 0)
                                        year = ((DateTime.Now.Year) - (StartDate.Year)).ToString();
                                    Restr = Restr.Replace(strArray[i].ToString(), year);
                                }
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }


        /// <summary>
        /// 招商详细页
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="Restr"></param>
        /// <param name="str"></param>
        public static string PR_AgentWDetail(string Restr, string str)
        {
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            Agent.TWillAgent Items = new Agent.RWillAgent().GateItem(ID);
            Restr = Restr.Replace("{PR_KEYWORD}", Items.Title);
            return Restr;
        }


        /// <summary>
        /// 取得分类
        /// </summary>
        /// <returns></returns>
        private static string GetType(string strType)
        {
            DataTable dt = new Agent.RAgentType().GetDataTable();
            string Restr = "<ul>";
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                Restr += "<li><a href=\"Trade-" + dt.Rows[i]["id"].ToString() + Base.BasePage.Config.Rewrite + "\">" + dt.Rows[i]["Name"].ToString() + "</a></li>";
            }
            Restr += "</ul>";
            return Restr;
        }


        /// <summary>
        /// 自定义原做代理详细页
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_WAgentInfo(TSystemLable Array)
        {
            int ID = Function.StringtoIntforQueryString("id");
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));

            // 获取代理信息
            string strWhere = "U_UserInfo.UserID=W_SincereAgent.UserID and W_SincereAgent.verify=1 and W_SincereAgent.AgentType=W_AgentType.ID and  W_SincereAgent.ID= " + ID;
            string strTable = "W_SincereAgent,U_UserInfo,W_AgentType";
            int OrderType = 1;
            string OrderField = "W_SincereAgent.AddDate";
            string strSelect = " W_SincereAgent.*,U_UserInfo.QQ,U_UserInfo.CompanyName,U_UserInfo.LoginName,U_UserInfo.City,U_UserInfo.GradeID,U_UserInfo.Province,W_AgentType.Name as TypeName ";
            int PageSize = 1;        //每页显示几条
            int PageIndex = 1;        //第几页
            if (HttpContext.Current.Request.QueryString["PageID"] == null)
                PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["PageID"]);
            if (PageIndex < 1) PageIndex = 1;
            int Count = 0;  //默认不需改动
            DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);


            //Agent.TWillAgent Items = new Agent.RWillAgent().GateItem(ID);
            string Restr = Array.Content.ToString();
            if (Lists.Rows[0]["ID"].ToString() == "0")
            {
                throw new Exception(Function.ErrInfo(1));
            }
            else
            {
                Restr = Restr.Replace("{PR:WS_Picbig}", Lists.Rows[0]["Picture"].ToString().Replace("t_","m_"));
                Restr = Restr.Replace("{PR:WS_Name}", Lists.Rows[0]["Name"].ToString()).Replace("{PR:WS_Picture}", Function.ProcessImageUrl(Lists.Rows[0]["Picture"].ToString())).Replace("{PR:WS_Title}", Lists.Rows[0]["Title"].ToString()).Replace("{PR:WS_Type}", Lists.Rows[0]["TypeName"].ToString());
                Restr = Restr.Replace("{PR:WS_Investment}", Lists.Rows[0]["Investment"].ToString()).Replace("{PR:WS_Amount}", Lists.Rows[0]["Amount"].ToString()).Replace("{PR:WS_InitialFee}", Lists.Rows[0]["InitialFee"].ToString());
                Restr = Restr.Replace("{PR:WS_Require}", Lists.Rows[0]["Require"].ToString()).Replace("{PR:WS_Cradle}", Lists.Rows[0]["Cradle"].ToString()).Replace("{PR:WS_Payback}", Lists.Rows[0]["Payback"].ToString());
                Restr = Restr.Replace("{PR:WS_Period}", Lists.Rows[0]["Period"].ToString()).Replace("{PR:WS_Concession}", Lists.Rows[0]["Concession"].ToString()).Replace("{PR:WS_Contract}", Lists.Rows[0]["Contract"].ToString());
                string[] strc;
                string temp = "";
                strc = (Lists.Rows[0]["BusinessMode"].ToString()).Split(new char[] { ',' });
                foreach (string var in strc)
                {
                    if (var.Equals("0"))
                    {
                        temp += "生产型 |";
                    }
                    if (var.Equals("1"))
                    {
                        temp += " 贸易型 |";
                    }
                    if (var.Equals("2"))
                    {
                        temp += " 服务型 |";
                    }
                    if (var.Equals("3"))
                    {
                        temp += " 政府或其他机构 |";
                    }
                }
                if (temp.Length > 0)
                    temp = temp.Substring(0, temp.Length - 1);
                Restr = Restr.Replace("{PR:WS_BusinessMode}", temp).Replace("{PR:WS_Count}", Lists.Rows[0]["Count"].ToString()).Replace("{PR:WS_Detail}", Lists.Rows[0]["Detail"].ToString());
                Restr = Restr.Replace("{PR:WS_Brand}", Lists.Rows[0]["Brand"].ToString());
            }
            return Restr;
        }


        /// <summary>
        /// 自定义招商加盟详细页
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_SAgentInfo(TSystemLable Array)
        {
            int ID = Function.StringtoIntforQueryString("id");
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            Agent.TWillAgent Items = new Agent.RWillAgent().GateItem(ID);
            string Restr = Array.Content.ToString();
            if (Items.ID == 0)
            {
                throw new Exception(Function.ErrInfo(1));
            }
            else
            {
                Restr = Restr.Replace("{PR:WS_Name}", Items.Name.ToString()).Replace("{PR:WS_Picture}", Items.Picture);
            }
            return Restr;
        }
    }
}