﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.Collections;
using nspLable.Manage;
using Base.Core;
using Area;
using Base;
namespace nspLable.Function.Systems
{
    /// <summary>
    /// Baec 的摘要说明
    /// </summary>
    public partial class systemic : Base.BasePage
    {
        private string _Rewrite; //((WebConfig)Application["WebConfig"]).Rewrite;//伪静态

        public string Rewrite
        {

            get { return _Rewrite; }
        }

        /// <summary>
        /// 
        /// </summary>
        public systemic()
        {
            //DataTable WebTable = Function.GetDataTable("select * from W_WebBasic");
            //_Rewrite = WebTable.Rows[0]["Rewrite"].ToString();
            //if (_Rewrite == "" || _Rewrite == null)
            //{
            //    _Rewrite = ".aspx";
            //}

        }

        /// <summary>
        /// 网站总控制开关
        /// </summary>
        /// <returns></returns>
        public string SY_Announce()
        {
            string strs = "";
            strs = "<script type='text/javascript' src='{PB_WebURL}netOpenClose.asp'></script>";
            return strs;

        }

        /// <summary>
        /// 收藏信息
        /// </summary>
        /// <returns></returns>
        public static string PR_SaveFavorites(string strID, string strType)
        {
            return "<a href=\"../Search/SaveFavorites" + BasePage.Config.Rewrite + "?id=" + strID + "&Type=" + strType + "\">收藏此信息</a>";
        }

        /// <summary>
        /// 热门搜索关键字
        /// </summary>
        /// <returns></returns>
        public static string SY_HotKeyW()
        {
            string strUrl = HttpContext.Current.Request.Url.ToString();
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<span id='search_result'>&nbsp;&nbsp;正在更新....</span>");
            strBuilder.Append("script type='text/javascript'> AjaxSearch('search_result','Purchase')</script>");
            return strBuilder.ToString();
        }

        /// <summary>
        /// 内容查询
        /// </summary>
        /// <returns></returns>
        public static string SY_Searchinfo()
        {
            string strUrl = HttpContext.Current.Request.Url.ToString();
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append(@"<script type=""text/javascript"" src=""{PB_WebURL}js/Search.js"" ></script>");
            return strBuilder.ToString();
        }

        /// <summary>
        /// 最近搜索关键字
        /// </summary>
        /// <returns></returns>
        public string SY_NewKey()
        {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append("<table border=0 width='100%' align=center cellpadding=0 cellspacing=0 ><tr><td align=center>最近搜索关键词：");
            strBuilder.Append("{PB_WebURL}");
            strBuilder.Append("search_near.asp'></script></td></tr></table>");
            return strBuilder.ToString();
        }

        /// <summary>
        /// 友情链接
        /// </summary>
        /// <param name="Array">
        /// isWhich   链接方式（1：Logo链接，0：文字链接）
        /// Num       显示链接数
        /// RowNum    每行的链接数
        /// isShow    显示方式（0：纵向、1：横向显示）
        /// PicWidth
        /// PicHight
        /// </param>
        /// <returns></returns>
        public static string SY_Links(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,
            if (strContent.Length != 6) goto Err; //如果参数不够则跳出
            string isWhich = strContent[0].ToString();
            int Num = Convert.ToInt32(strContent[1].ToString());
            int RowNum = Convert.ToInt32(strContent[2].ToString());
            int isShow = Convert.ToInt32(strContent[3].ToString());
            int PicWidth = Convert.ToInt32(strContent[4].ToString());
            int PicHight = Convert.ToInt32(strContent[5].ToString());

            string strSelect = "";
            if (Num <= 0)
                if (isWhich == "1")
                    strSelect = "top 1 WebName,WebURL,WebLOGO ";
                else
                    strSelect = "top 1 WebName,WebURL ";
            else
                if (isWhich == "1")
                    strSelect = " top " + Num + " WebName,WebURL,WebLOGO";
                else
                    strSelect = " top " + Num + " WebName,WebURL";

            StringBuilder strWhere = new StringBuilder();
            strWhere.Append("where Verify=1 ");
            if (isWhich == "1")
                strWhere.Append(@" and LinkType = 1 ");
            else
                strWhere.Append(@" and LinkType = 2 ");

            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), "W_Links", " order by Sequence asc");

            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count == 0)
                strBuilder.Append("暂无链接");
            else
            {
                strBuilder.Append("<Table width='100%'><tr><td >");
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    if (i == (Num - 1)) break;
                    strBuilder.Append("<a href='");
                    strBuilder.Append(Lists.Rows[i]["WebUrl"].ToString());
                    strBuilder.Append(@" ' title =' ");
                    strBuilder.Append(Lists.Rows[i]["WebName"].ToString());
                    strBuilder.Append("' target=\"_blank\" >");
                    if (isWhich == "1")
                    {
                        strBuilder.Append("<img width='");
                        strBuilder.Append(PicWidth);
                        strBuilder.Append(@"' height='");
                        strBuilder.Append(PicHight);
                        strBuilder.Append(@"' src='");
                        if (Lists.Rows[i]["WebLOGO"].ToString().Substring(0, 4).ToLower() == "http")
                            strBuilder.Append(Lists.Rows[i]["WebLOGO"].ToString());
                        else
                            strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["WebLOGO"].ToString()));
                        strBuilder.Append(@" '>");
                    }
                    else
                        strBuilder.Append(Lists.Rows[i]["WebName"].ToString());
                    strBuilder.Append(@"</a>");

                    if (isShow == 0)  //换行
                    {
                        if (i == (Num - 1))
                            strBuilder.Append(@"</td></tr>");
                        else
                            strBuilder.Append(@"</td></tr><tr><td>");
                    }
                    else
                    {
                        if (i == (Num - 1))
                            strBuilder.Append(@"</td></tr>");
                        else
                            if (((i + 1) % RowNum) == 0)
                                strBuilder.Append(@"</td></tr><tr><td>");
                            else
                                strBuilder.Append(@"</td><td>");
                    }

                }
            }
            strBuilder.Append(@"</table>");
            return strBuilder.ToString();


        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 网站公告、活动、新闻
        /// </summary>
        /// <param name="Array">
        /// Type 类型
        /// isShow 显示方式（0：纵向，1：横向）
        /// Num 显示条数
        /// </param>
        /// <returns></returns>
        public static string SY_Posts(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,
            if (strContent.Length != 3) goto Err; //如果参数不够则跳出
            string Type = strContent[0].ToString();
            int isShow = Convert.ToInt32(strContent[1].ToString());
            int Num = Convert.ToInt32(strContent[2].ToString());

            //临时字符串
            StringBuilder strWhere = new StringBuilder();
            string strSelect;
            //读取几条信息
            if (Num <= 0)
                strSelect = "top 1 ID,Title ";
            else
                strSelect = " top " + Num + "ID,Title ";
            strWhere.Append("where 1=1 ");
            if (Type == "0")
                strWhere.Append("and Type = '网站公告'");
            else if (Type == "1")
                strWhere.Append("and Type = '网站新闻'");
            else
                strWhere.Append("and Type = '网站活动'");
            DataTable PostList = Function.GetDataTable(strSelect, strWhere.ToString(), "W_WebNews", " order by AddDate desc");
            StringBuilder strBuilder = new StringBuilder();
            if (PostList.Rows.Count == 0)
                strBuilder.Append("暂无信息");
            else
            {
                strBuilder.Append("<Table width='100%' border='0' cellpadding='0' cellspacing='0'><tr><td>");
                for (int i = 0; i < PostList.Rows.Count; i++)
                {
                    if (i > (Num - 1)) break;
                    strBuilder.Append(@"<a href= '");
                    strBuilder.Append(@"{PB_WebURL}");
                    strBuilder.Append(@"WebNews/Detail-");
                    strBuilder.Append(PostList.Rows[i]["ID"].ToString());
                    strBuilder.Append(BasePage.Config.Rewrite);
                    strBuilder.Append(@"'>");
                    strBuilder.Append(PostList.Rows[i]["Title"].ToString());
                    strBuilder.Append(@"</a>");

                    if (isShow == 0)  //换行
                    {
                        if (i == (Num - 1))
                            strBuilder.Append(@"</td></tr>");
                        else
                            strBuilder.Append(@"</td></tr><tr><td>");
                    }
                    else
                    {
                        if (i == (Num - 1))
                            strBuilder.Append(@"</td>");
                        else
                            strBuilder.Append(@"</td><td>");
                    }
                }
            }
            strBuilder.Append(@"</table>");
            return strBuilder.ToString();

        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 网站LOGO
        /// </summary>
        /// <param name="Array">
        /// Width：LOGO高
        /// Height：LOGO宽
        /// </param>
        /// <returns></returns>
        public static string SY_WebLogo(TSystemLable Array)
        {
            string Restr = "";
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,
            if (strContent.Length != 2) goto Err; //如果参数不够则跳出
            int Width = Convert.ToInt32(strContent[0].ToString());
            int Height = Convert.ToInt32(strContent[1].ToString());

            DataTable LOGO = Function.GetDataTable("top 1 WebLOGO", " ", "W_WebBasic", " ");
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.Append(@"<a href='");
            strBuilder.Append(Config.WebURL);
            strBuilder.Append(@"'>");
            strBuilder.Append("<img width='");
            strBuilder.Append(Width);
            strBuilder.Append(@"' height='");
            strBuilder.Append(Height);
            strBuilder.Append(@" ' src=' ");
            strBuilder.Append(Function.ProcessImageUrl(LOGO.Rows[0]["WebLOGO"].ToString()));
            strBuilder.Append(" '>");
            strBuilder.Append(@"</a>");
            Restr = strBuilder.ToString();
            return Restr;

        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        /// 行业分类
        /// </summary>
        /// <param name="Array（10）">
        /// WhichType：     行业类别（0：供应，1：求购，2：公司，3：产品索引）
        /// BigNum：        显示大类数量
        /// BigClass：      大类样式
        /// RowsNum：       每行显示几条
        /// BackColor：     背景交替颜色
        /// ShowSmall：     是否显示小类（0：显示，1：不显示）
        /// SmallNum：      小类个数
        /// SmallRowsNum：  小类每行显示几条
        /// SmallSize：     小类字数
        /// SmallClass：    小类样式
        /// Other：         其他（大类图片[0:显示，1;不显示]，发布信息[0:显示，1;不显示]，更多[0;显示，1:不显示]）
        /// </param>
        /// <returns></returns>
        public static string SY_Industry(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            string[] strSmall;
            strContent = Array.Info.Split(new char[] { '|' });

            //初始化参数,如果参数不够则跳出
            if (strContent.Length != 11) goto Err;

            string WhichType = strContent[0].ToString();
            int BigNum = Convert.ToInt32(strContent[1].ToString());
            string BigClass = strContent[2].ToString();
            int RowsNum = Convert.ToInt32(strContent[3].ToString());
            string BackColor = strContent[4].ToString();
            int ShowSmall = Convert.ToInt32(strContent[5].ToString());
            int SmallNum = Convert.ToInt32(strContent[6].ToString());
            int SmallRowsNum = Convert.ToInt32(strContent[7].ToString());
            int SmallSize = Convert.ToInt32(strContent[8].ToString());
            string SmallClass = strContent[9].ToString();
            string Other = strContent[10].ToString();
            string BigPicture = Other[4].ToString();
            string Release = Other[0].ToString();
            string More = Other[2].ToString();

            //需要取得的数据
            string strSelect = "";
            //读取几条信息
            if (BigNum <= 0)
                strSelect = "top 1  ID,Type,Superiors";
            else
                strSelect = " top " + BigNum + " ID,Type,Superiors ";
            //查询条件
            string strWhere = "";
            strWhere += " where ToRelease=1 and SuperiorsFlag=0";
            //要查询的表
            string strTableName = "W_IndustryType";
            //排序方式
            string strOrder = "";
            strOrder += " order by Sequence asc";
            //返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrder);
            StringBuilder strBuilder = new StringBuilder();
            //是否存在行业
            if (Lists.Rows.Count > 0)
            {
                int intCount = Lists.Rows.Count;
                int intRow = 0;
                int intCell = RowsNum;
                intRow = intCount % intCell == 0 ? intCount / intCell : intCount / intCell + 1;

                for (int i = 0; i < intRow; i++)
                {
                    if ((i + 1) % 2 == 0)
                        strBuilder.Append("<div class=" + BackColor + ">" + "\r\n ");
                    strBuilder.Append("<div class=\"classblock\">" + "\r\n ");
                    for (int j = 0; j < intCell; j++)
                    {
                        int ic = i * intCell + j;
                        if (ic > BigNum || ic >= Lists.Rows.Count) break; //如果超过显示的条数则跳出。
                        if (j == 0)
                            strBuilder.Append(@"<dl><dt>" + "\r\n ");
                        else
                            strBuilder.Append("<dl class=\"classleft\"><dt>");
                        //显示图片
                        if (BigPicture == "1")
                        {
                            strBuilder.Append(@"<img src='{PB_WebURL}Images/System/Industry_Flag.gif'>&nbsp;");
                        }
                        switch (WhichType)
                        {
                            case "0":
                                strBuilder.Append("<a href=\"{PB_WebURL}Supply/Trade-");
                                break;
                            case "1":
                                strBuilder.Append("<a href=\"{PB_WebURL}Purchase/Trade-");
                                break;
                            case "2":
                                strBuilder.Append("<a href=\"{PB_WebURL}Company/Trade-");
                                break;
                            case "3":
                                strBuilder.Append("<a href=\"{PB_WebURL}Product/Trade-");
                                break;
                            default:
                                strBuilder.Append("<a href=\"{PB_WebURL}Supply/Trade-");
                                break;
                        }
                        strBuilder.Append(Lists.Rows[ic]["ID"].ToString());
                        strBuilder.Append(Base.BasePage.Config.Rewrite + "\">");
                        strBuilder.Append(Lists.Rows[ic]["Type"].ToString());
                        strBuilder.Append("</a> " + "\r\n ");

                        //显示发布信息
                        if (Release == "1")
                        {
                            strBuilder.Append("<a href=\"{PB_WebURL}Member/index" + Base.BasePage.Config.Rewrite + "\">");
                            strBuilder.Append(@"<img src='{PB_WebURL}Images/System/Industry_Release.gif'>");
                            strBuilder.Append(@"</a>" + "\r\n ");
                        }
                        //显示下级分类
                        if (ShowSmall == 0)
                        {
                            strBuilder.Append("</dt>" + "\r\n " + "<dd>");
                            strBuilder.Append(SmallIndustry(Lists.Rows[ic]["ID"].ToString(), WhichType, SmallNum, SmallRowsNum, SmallSize, SmallClass, More));
                            strBuilder.Append("</dd>");
                        }
                        strBuilder.Append("</dl>");
                    }
                    strBuilder.Append("</div>" + "\r\n ");
                    if ((i + 1) % 2 == 0)
                        strBuilder.Append("</div>" + "\r\n ");
                }
            }
            else
            {
                strBuilder.Append(@"暂无行业分类");
            }
            return strBuilder.ToString();


        Err:
            return Function.ErrInfo(0);
        }

        /// <summary>
        ///  行业下级分类
        /// </summary>
        /// <param Nam="ID">上级ID</param>
        /// <param Nam="WhitchType">供应、求购、公司</param>
        /// <param Nam="SmallNum">数量</param>
        /// <param Nam="SmallRowsNum">每行显示条数</param>
        /// <param Nam="SmallSize">显示的字数</param>
        /// <param Nam="SmallClass">Class样式</param>
        /// <param Nam="More">是否显示"更多"</param>
        /// <returns></returns>
        private static string SmallIndustry(string ID, string WhichType, int SmallNum, int SmallRowsNum, int SmallSize, string SmallClass, string More)
        {
            int intID = Convert.ToInt32(ID);

            //需要取得的数据
            string strSelect = "";
            //读取几条信息
            if (SmallNum <= 0)
                strSelect = "top 1  ID,Type,Superiors";
            else
                strSelect = " top " + SmallNum + " ID,Type,Superiors ";
            //查询条件
            string strWhere = "";
            strWhere += " where ToRelease=1 and SuperiorsID=";
            strWhere += intID;
            //要查询的表
            string strTableName = "W_IndustryType";
            //排序方式
            string strOrder = "";
            strOrder += " order by Sequence asc";
            //返回查询结果
            DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrder);

            //设置每行显示条数
            int intRowsNum = 0;
            if (Lists.Rows.Count+1 > 0) intRowsNum = Lists.Rows.Count+1;//SmallRowsNum;
            //设置类别的字数
            int intSize = 0;
            if (SmallSize >= 0)
                intSize = SmallSize;
            StringBuilder strBuilder = new StringBuilder();
            if (Lists.Rows.Count <= 0)
            {
                return (strBuilder.Append("暂无下级 ")).ToString();
            }
            else
            {
                for (int i = 0; i < Lists.Rows.Count; i++)
                {
                    switch (WhichType)
                    {
                        case "0":
                            strBuilder.Append("<a href=\"{PB_WebURL}Supply/Trade-");
                            break;
                        case "1":
                            strBuilder.Append("<a href=\"{PB_WebURL}Purchase/Trade-");
                            break;
                        case "2":
                            strBuilder.Append("<a href=\"{PB_WebURL}Company/Trade-");
                            break;
                        case "3":
                            strBuilder.Append("<a href=\"{PB_WebURL}Product/Trade-");
                            break;
                        default:
                            strBuilder.Append("<a href=\"{PB_WebURL}Supply/Trade-");
                            break;
                    }
                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                    strBuilder.Append(Base.BasePage.Config.Rewrite + "\">");
                    if (intSize != 0)
                    {
                        string TempStr = "";
                        if (Lists.Rows[i]["Type"].ToString().Length < intSize)
                            strBuilder.Append(Lists.Rows[i]["Type"].ToString());
                        else
                        {
                            for (int k = 0; k < intSize; k++)
                            {
                                TempStr += (Lists.Rows[i]["Type"].ToString())[k].ToString();
                            }
                            //TempStr += "..";
                            strBuilder.Append(TempStr);
                        }
                    }
                    else
                        strBuilder.Append(Lists.Rows[i]["Type"].ToString());
                    strBuilder.Append("</a>");
                    strBuilder.Append(" | " + "\r\n ");
                    if (intRowsNum > 0 && ((i + 1) % intRowsNum) == 0)
                        strBuilder.Append("<br />" + "\r\n ");
                }
            }
            int Length = 0;
            if (More == "1")
            {
                if (Lists.Rows.Count > 0)
                {
                    switch (WhichType)
                    {
                        case "0":
                            strBuilder.Append("<a href=\"{PB_WebURL}Supply/Trade");
                            break;
                        case "1":
                            strBuilder.Append("<a href=\"{PB_WebURL}Purchase/Trade-");
                            break;
                        case "2":
                            strBuilder.Append("<a href=\"{PB_WebURL}Company/Trade-");
                            break;
                        case "3":
                            strBuilder.Append("<a href=\"{PB_WebURL}Product/Trade-");
                            break;
                        default:
                            strBuilder.Append("<a href=\"{PB_WebURL}Supply/Trade-");
                            break;
                    }
                    strBuilder.Append(Base.BasePage.Config.Rewrite + "\">");
                    strBuilder.Append("更多</span></a> " + "\r\n ");
                }
                Length = strBuilder.ToString().Length;
            }
            else
            {
                Length = strBuilder.ToString().Length - 6;
            }
            return strBuilder.ToString(0, Length);

        }

        /// <summary>
        /// 快速查找地区标签
        /// </summary>
        /// <returns></returns>
        public static string SY_RapidArea(TSystemLable Array)
        {
            return "123";
        }

        /// <summary>
        ///  下级行业类别
        /// </summary>
        /// <param name="strType">行业类别</param>
        /// <param name="p">信息类型[Supply,Prrchase,Company,Product]</param>
        /// <returns></returns>
        public static string lowerType(int strType, string p)
        {
            int TypeID = 0;
            if (HttpContext.Current.Request.QueryString["id"] != null && HttpContext.Current.Request.QueryString["id"] != "")
            {
                if (Base.Common.CheckNum(HttpContext.Current.Request.QueryString["ID"]))
                {
                    TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                }
            }
            StringBuilder ReBuilder = new StringBuilder();
            DataTable TypeDate = Function.GetDataTable(" Type,ID ", " where ToRelease=1 AND SuperiorsID=" + TypeID, " W_IndustryType", " order by sequence asc ");
            if (TypeDate.Rows.Count > 0)
            {
                ReBuilder.Append(@"<table width='100%'><tr><td>");
                for (int i = 0; i < TypeDate.Rows.Count; i++)
                {
                    ReBuilder.Append("");
                    if (p == "Supply")
                    {
                        ReBuilder.Append(@"<a href='{PB_WebURL}Supply/Trade-");
                    }
                    else if (p == "Purchase")
                    {
                        ReBuilder.Append(@"<a href='{PB_WebURL}purchase/Trade-");
                    }
                    else if (p == "Product")
                    {
                        ReBuilder.Append(@"<a href='{PB_WebURL}Product/Trade-");
                    }
                    else
                    {
                        ReBuilder.Append(@"<a href='{PB_WebURL}Company/Trade-");
                    }
                    ReBuilder.Append(TypeDate.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                    ReBuilder.Append(@"'>");
                    ReBuilder.Append(TypeDate.Rows[i]["Type"].ToString());
                    ReBuilder.Append(@"</a>");
                    if ((i + 1) % 6 == 0)
                    {
                        if (i != TypeDate.Rows.Count - 1)
                            ReBuilder.Append("</tr><tr><td>");
                        else
                            ReBuilder.Append("</tr>");
                    }
                    else
                    {
                        if (i != TypeDate.Rows.Count - 1)
                            ReBuilder.Append(@"</td><td>");
                        else
                            ReBuilder.Append(@"</td></tr>");
                    }
                }
                ReBuilder.Append(@"</table>");
            }
            else
                ReBuilder.Append(@"<table width='100%'><tr>暂无下级分类！<td></td></tr></table>");
            return ReBuilder.ToString();
        }

        /// <summary>
        /// 快速查找地区标签
        /// </summary>
        /// <returns></returns>
        public static string PR_SOLELY(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            WebNews.TWebNews tw = new WebNews.TWebNews();
            WebNews.IWebNews iw = new WebNews.RWebNews();
            tw = iw.GateItem(ID);
            string StrSQL = "";
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), tw.Title);
                            break;
                        case "{PR_INFO}":
                            Restr = Restr.Replace(strArray[i].ToString(), tw.Detail);
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }

        public static string SY_AtArea(string strType)
        {

            string str1 = "";
            if (strType.Contains("Supply"))
            {
                str1 = "Supply";
            }
            else if (strType.Contains("Purchase"))
            {
                str1 = "Purchase";
            }
            else
            {
                str1 = "Company";
            }

            string str = "<script language=\"javascript\"> \n function SearchArea(s) \n { \n ";
            str += "location.replace(\"../Search/Search.aspx?Type=" + str1 + "&keyword=&AreaID=\"+s.options[s.options.selectedIndex].value); }\n ";
            str += "</script>";
            str += "<select name=\"Areas\" onchange=\"SearchArea(this)\"> <option value='0'>所有地区</option> ";
            IArea area = new RArea();
            DataTable dt = area.GetDataTable(0);
            foreach (DataRow var in dt.Rows)
            {
                str += " <option value='" + var["Name"].ToString() + "'>" + var["Name"] + "</option> \r\n";
            }
            str += " </select>";
            return str;
        }

        /// <summary>
        ///  处理2级域名
        /// </summary>
        /// <returns></returns>
        public static string Subdomains(string LoginName)
        {
            if (new WebConfig().IsSecondUrl == true)
            {
                string Url = BasePage.Config.WebURL;
                if (Url.Contains("http://"))
                    Url = Url.Replace("http://", "");
                if (Url.Contains("www."))
                    Url = Url.Replace("www.", "");
                return LoginName + "." + Url + "Index" + BasePage.Config.Rewrite;
            }
            return "{PB_WEBURL}shop/index/" + LoginName + BasePage.Config.Rewrite;
        }
    }
}