﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using nspLable.Function;
using System.Text;
using Base;
using System.Data.SqlClient;
using Expo;
using System.Globalization;

namespace nspLable.Function.Systems
{
    /// <summary>
    /// 展会标签类
    /// </summary>
    public class clsExpoLable
    {


        /// <summary>
        /// 展会图文标签
        /// </summary>
        /// <param name="Array(13)">
        /// WitchType:      显示方式[0:上下，1:左右]	
        /// Num:            显示数量
        /// RowsNum:        每行显示条数
        /// TypeID:         展会类别[0: 全部，ID]
        /// Category        展会分类[0:国内，1:国外]
        /// PicWidth;       图片宽度	
        /// PicHeigth;      图片高度	
        /// PicFrame;       图片边框	
        /// isTitle;        是否显示标题[0:显示，1:不显示]	
        /// TitleClass;     标题样式	  
        /// TitleSize;      标题字数	
        /// Target;         打开目标	
        /// ExpoAttribute	属性
        /// </param>
        /// <returns></returns>
        public static string SY_Expo_Pic(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });

            try
            {
                //初始化参数,如果参数不够则跳出
                if (strContent.Length != 13)
                    throw new Exception("0");

                int WhichType = Convert.ToInt32(strContent[0].ToString());
                int Num = Convert.ToInt32(strContent[1].ToString());
                int RowsNum = Convert.ToInt32(strContent[2].ToString());
                int TypeID = Convert.ToInt32(strContent[3].ToString());
                int Category = Convert.ToInt32(strContent[4].ToString());
                int PicWidth = Convert.ToInt32(strContent[5].ToString());
                int PicHight = Convert.ToInt32(strContent[6].ToString());
                string PicFrame = strContent[7].ToString();
                string isTitle = strContent[8].ToString();
                string TitleClass = strContent[9].ToString();
                int TitleSize = Convert.ToInt32(strContent[10].ToString());
                string Target = strContent[11].ToString();
                //string ExpoAttributee = strContent[12].ToString();
                //临时字符串
                string strWhere = "";
                string strSelect;
                //读取几条信息
                if (Num <= 0)
                    strSelect = "top 1 ";
                else
                    strSelect = " top " + Num + " * ";

                //查询条件 
                strWhere += " WHERE 1=1 AND Picture!='' AND Verify=1";
                if (TypeID > 0)
                {
                    strWhere += "and TypeID = ";
                    strWhere += TypeID;
                }
                if (Category == 0)
                    strWhere += " and ExpoType='国内'";
                else
                    strWhere += " and ExpoType='国外'";

                DataTable Lists = Function.GetDataTable(strSelect, strWhere, "W_Expo", " order by AddDate desc");
                StringBuilder strBuilder = new StringBuilder();
                if (Lists.Rows.Count > 0)
                {
                    strBuilder.Append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>");
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        if (i > Num - 1) break; //如果超过显示的条数则跳出。
                        if (WhichType != 0 && WhichType != 1) WhichType = 0;
                        switch (WhichType)
                        {
                            case 0: //上下结构
                                strBuilder.Append("<table cellpadding=\"0\" cellspacing=\"0\" border\"0\"><tr><td class=\"" + PicFrame + "\">");
                                strBuilder.Append("<a href=\"{PB_WebURL}Expo/detail-");
                                strBuilder.Append(Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                                strBuilder.Append("\" Target=\"");
                                strBuilder.Append(Target);
                                strBuilder.Append("\">");
                                strBuilder.Append("<img width='");
                                strBuilder.Append(PicWidth);
                                strBuilder.Append(@"' height='");
                                strBuilder.Append(PicHight);
                                strBuilder.Append(@"'src='");
                                strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                                strBuilder.Append(@"'></a>");
                                if (isTitle == "0") //是否显示标题
                                {
                                    strBuilder.Append(@"</td></tr><tr><td>");
                                    strBuilder.Append(@"<a href='{PB_WebURL}Expo/detail-");
                                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                                    strBuilder.Append(BasePage.Config.Rewrite);
                                    strBuilder.Append(@" ' Target='");
                                    strBuilder.Append(Target);
                                    strBuilder.Append(@" '>");
                                    if (TitleSize > 0)
                                        if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                                            strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                                        else
                                            strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                                    else
                                        strBuilder.Append(Lists.Rows[i]["title"].ToString());
                                    strBuilder.Append(@"</a>");
                                }
                                strBuilder.Append(@"</td></tr></table>");
                                break;
                            case 1: //左右结构
                                strBuilder.Append("<table cellpadding=\"0\" cellspacing=\"0\" border\"0\"><tr><td class=\"" + PicFrame + "\" >");
                                strBuilder.Append(@"<a href='{PB_WebURL}Expo/detail-");
                                strBuilder.Append(Lists.Rows[i]["ID"].ToString() + Base.BasePage.Config.Rewrite);
                                strBuilder.Append(@" ' Target='");
                                strBuilder.Append(Target);
                                strBuilder.Append(@" '>");
                                strBuilder.Append("<img width='");
                                strBuilder.Append(PicWidth);
                                strBuilder.Append(@"' height='");
                                strBuilder.Append(PicHight);
                                strBuilder.Append(@"'src='");
                                strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                                strBuilder.Append("'></a></td><td valign='top'>");
                                strBuilder.Append(@"<a href='{PB_WebURL}Expo/detail-");
                                strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                                strBuilder.Append(BasePage.Config.Rewrite);
                                strBuilder.Append("' Target=\"");
                                strBuilder.Append(Target);
                                strBuilder.Append("\" class=\"" + TitleClass + "\">");
                                if (TitleSize > 0) //设置标题字数
                                    if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                                        strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                                    else
                                        strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                                else
                                    strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                                strBuilder.Append(@"</a>");
                                strBuilder.Append(@"</br>");
                                strBuilder.Append(@"地址：");
                                strBuilder.Append(Lists.Rows[i]["Place"].ToString());
                                strBuilder.Append(@"</br>");
                                strBuilder.Append(@"时间：");
                                strBuilder.Append(Common.DateTransform(Lists.Rows[i]["StartDate"].ToString(), 1));
                                strBuilder.Append(@"</td></tr></table>");
                                break;
                        }
                        if (((i + 1) % RowsNum) == 0)  //换行
                            if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                                strBuilder.Append(@"</td></tr></table> ");
                            else
                                strBuilder.Append(@"</td></tr><tr><td>");
                        else
                            if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                                strBuilder.Append(@"</td></tr></table> ");
                            else
                                strBuilder.Append(@"</td><td>");
                    }
                }
                return strBuilder.ToString();
            }
            catch (Exception e)
            {
                switch (e.Message)
                {
                    case "0":
                        return Function.ErrInfo(0);
                        break;
                    default:
                        return e.Message;
                        break;
                }
            }
        }

        /// <summary>
        /// 展会文字列表
        /// </summary>
        /// <param name="Array">
        /// TypeID	        展会类别[0为全部，ID]
        /// Category	    展会分类[0：全部，1：国内，2：国外]
        /// Num	            显示数量
        /// RowsNum	        每行显示的条数
        /// DisplayType	    是否显示展会类别[0:显示,1:不显示]
        /// TitleSize	    标题字数
        /// TitleClass	    标题样式
        /// Target	        打开目标
        /// DisplayTime	    是否显示时间[0:显示,1:不显示]
        /// DateFormat	    日期样式
        /// ExpoAttribute	属性
        /// OrderBy	        排序方式[0：时间降序，1：时间升序，2：点击率]
        /// </param>
        /// <returns></returns>
        public static string SY_Expo_Str(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });
            try
            {
                //初始化参数,如果参数不够则跳出
                if (strContent.Length != 12) throw new Exception(Function.ErrInfo(0));
                int TypeID = Convert.ToInt32(strContent[0].ToString());
                int Category = Convert.ToInt32(strContent[1].ToString());
                int Num = Convert.ToInt32(strContent[2].ToString());
                int RowsNum = Convert.ToInt32(strContent[3].ToString());
                string DisplayType = strContent[4].ToString();
                int TitleSize = Convert.ToInt32(strContent[5].ToString());
                string TitleClass = strContent[6].ToString();
                string Target = strContent[7].ToString();
                string DisplayTime = strContent[8].ToString();
                string DateFormat = strContent[9].ToString();
                string ExpoAttributee = strContent[10].ToString();
                string OrderBy = strContent[11].ToString();
                //临时字符串
                //查询内容
                string strSelect;
                if (Num <= 0)   //读取几条信息
                    strSelect = "top 1 ";
                else
                    strSelect = " top " + Num + " W_Expo.ID,W_Expo.Title,W_Expo.AddDate,W_Expo.TypeID,W_ExpoType.Type ";
                //查询条件 
                StringBuilder strWhere = new StringBuilder();
                strWhere.Append(" WHERE W_Expo.TypeID=W_ExpoType.ID AND Verify=1 And W_Expo.Title<>'' ");
                if (TypeID > 0)
                {
                    strWhere.Append("AND W_Expo.TypeID = ");
                    strWhere.Append(TypeID);
                }
                if (Category == 1)
                    strWhere.Append(" and W_Expo.ExpoType='国内'");
                else if (Category == 2)
                    strWhere.Append(" and W_Expo.ExpoType='国外'");
                // 要查询表、视图
                string strTableName = "W_Expo,W_ExpoType";
                // 排序方式
                string strOrderBy = "";
                switch (OrderBy)
                {
                    case "1":
                        strOrderBy += " order by AddDate desc";
                        break;
                    case "2":
                        strOrderBy += " order by AddDate ";
                        break;
                    default:
                        strOrderBy += " order by AddDate desc";
                        break;
                }
                // 返回查询结果
                DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
                //输出结果
                StringBuilder strBuilder = new StringBuilder();
                if (Lists.Rows.Count > 0)
                {
                    strBuilder.Append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td  class=\"" + TitleClass + "\">");
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        if (i > Num - 1) break; //如果超过显示的条数则跳出。
                        if (DisplayType == "1")
                        {
                            strBuilder.Append("[<a href='{PB_WebURL}Expo/Trade-");
                            strBuilder.Append(Lists.Rows[i]["TypeID"].ToString());
                            strBuilder.Append(BasePage.Config.Rewrite);
                            strBuilder.Append("'>");
                            strBuilder.Append(Lists.Rows[i]["Type"].ToString().Trim());
                            strBuilder.Append(@"</a>]");
                        }
                        strBuilder.Append("<a href=\"{PB_WebURL}Expo/Detail-");
                        strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                        strBuilder.Append(BasePage.Config.Rewrite);
                        strBuilder.Append("\" target=\"" + Target + "\">");
                        if (TitleSize > 0) //设置标题字数
                            if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                                strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                            else
                                strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                        else
                            strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                        strBuilder.Append(@"</a>");
                        if (DisplayTime == "1")
                        {
                            strBuilder.Append("<span>");
                            strBuilder.Append(DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToString(DateFormat, DateTimeFormatInfo.InvariantInfo));
                            // strBuilder.Append(Common.DateTransform(DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString(), DateFormat));
                            strBuilder.Append("</span>");
                        }
                        strBuilder.Append("</td><td width=\"15\">&nbsp;");
                        if (((i + 1) % RowsNum) == 0)  //换行
                            if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                                strBuilder.Append(@"</td></tr>");
                            else
                                strBuilder.Append("</td></tr><tr><td  class=\"" + TitleClass + "\">");
                        else
                            if (i == Lists.Rows.Count-1||i==Num-1)
                                 strBuilder.Append(@"</td></tr>");
                            else
                                 strBuilder.Append("</td><td  class=\"" + TitleClass + "\">");
                    }
                }
                strBuilder.Append("</table>");
                return strBuilder.ToString();
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }

        /// <summary>
        /// 展会列表
        /// </summary>
        /// <param name="Array">
        /// Num             显示多少条
        /// TypeSize        类别字数
        /// TitleSize	    标题字数
        /// </param>
        /// <returns></returns>
        public static string DIY_ExpoList(TSystemLable Array)
        {
            try
            {
                // 定义全局变量，最后返回
                StringBuilder ReBulider = new StringBuilder();
                // 求购列表头部
                string strHead = "";
                strHead = Array.Head;
                ReBulider.Append(strHead);
                // 取得用户设置的参数
                string[] strContent;
                strContent = Array.Info.Split(new char[] { '|' });
                if (strContent.Length != 3) throw new Exception(Function.ErrInfo(0));
                int Num = Convert.ToInt32(strContent[0].ToString());
                int TypeSize = Convert.ToInt32(strContent[1].ToString());
                int TitleSize = Convert.ToInt32(strContent[2].ToString());

                //临时字符串
                //查询内容
                string strSQL = "SELECT";
                if (Num <= 0)   //读取几条信息
                    strSQL += " top 1 ";
                else
                    strSQL += " top " + Num;
                strSQL += " W_Expo.ID as ID, TypeID, Title, W_ExpoType.Type,Verify, AddDate FROM W_ExpoType join W_Expo on W_Expo.TypeID=W_ExpoType.ID ";
                strSQL += " where W_Expo.Verify=1 and W_Expo.Title <>'' order by W_Expo.AddDate desc ";
                DataTable Lists = Function.GetDataTable(strSQL);
                if (Lists.Rows.Count < 0)
                {
                    ReBulider.Append("暂无行业展会");
                }
                else
                {
                    string strInfo = Array.Content.ToString();
                    string[] strAtttibute = Function.GetAttribute(strInfo);
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        strInfo = Array.Content.ToString();
                        for (int j = 0; j < strAtttibute.Length; j++)
                        {
                            switch (strAtttibute[j].ToString())
                            {
                                case "{PR:WS_exLink}":
                                    string strLink1 = "{PB_WebURL}Expo/Detail-";
                                    strLink1 += Lists.Rows[i]["ID"].ToString();
                                    strLink1 += BasePage.Config.Rewrite;
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), strLink1);
                                    break;
                                case "{PR:WS_exTypeLink}":
                                    string strLink2 = "{PB_WebURL}Expo/Trade-";
                                    strLink2 += Lists.Rows[i]["TypeID"].ToString();
                                    strLink2 += BasePage.Config.Rewrite;
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), strLink2);
                                    break;
                                case "{PR:WS_exTitle}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), new Common().GetString(Lists.Rows[i]["Title"].ToString(), 0, TitleSize));
                                    break;
                                case "{PR:WS_exAddDate}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.DateTransform(Lists.Rows[i]["AddDate"].ToString(), "yyyy-mm-dd"));
                                    break;
                                case "{PR:WS_exType}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.GetString(Lists.Rows[i]["Type"].ToString(), TypeSize));
                                    break;
                            }
                        }
                        ReBulider.Append(strInfo);
                    }
                }
                //求购列表尾部
                string strFooter = "";
                strFooter = Array.Footer;
                ReBulider.Append(strFooter);
                return ReBulider.ToString();
            }
            catch (Exception e)
            {
                switch (e.Message)
                {
                    case "0":
                        return Function.ErrInfo(0);
                        break;
                    default:
                        return e.Message;
                        break;
                }
            }
        }

        /// <summary>
        /// 展会资讯图文列表
        /// </summary>
        /// <param name="Array">
        /// WitchType	   显示方式[0:上下，1:左右]
        /// Num	           显示数量
        /// RowsNum	       每行显示条数
        /// TypeID         类别
        /// PicWidth       图片宽度	
        /// PicHeigth	   图片高度
        /// PicFrame	   图片边框
        /// DisplayTitle   是否显示标题[0:不显示，1:显示]	
        /// TitleClass	   标题样式
        /// TitleSize	   标题字数
        /// Target	       打开目标
        /// DetailSize	   内容字数
        /// NewsAttribute  资讯属性[0:全部,1:推荐，2:头条]
        /// OrderBy        排序方式[0：时间降序，1：时间升序，2：点击率]
        /// </param>
        /// <returns></returns>
        public static string SY_ExpoNews_Pic(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });
            try
            {
                //初始化参数,如果参数不够则跳出
                if (strContent.Length != 14) throw new Exception("0");
                int WitchType = Convert.ToInt32(strContent[0].ToString());
                int Num = Convert.ToInt32(strContent[1].ToString());
                int RowsNum = Convert.ToInt32(strContent[2].ToString());
                int TypeID = Convert.ToInt32(strContent[3].ToString());
                int PicWidth = Convert.ToInt32(strContent[4].ToString());
                int PicHight = Convert.ToInt32(strContent[5].ToString());
                string PicFrame = strContent[6].ToString();
                int DisplayTitle = Convert.ToInt32(strContent[7].ToString());
                string TitleClass = strContent[8].ToString();
                int TitleSize = Convert.ToInt32(strContent[9].ToString());
                string Target = strContent[10].ToString();
                int DatailSize = Convert.ToInt32(strContent[11].ToString());
                int NewsAttribute = Convert.ToInt32(strContent[12].ToString());
                string OrderBy = strContent[13].ToString();

                //查询内容
                string strSelect;
                if (Num <= 0)   //读取几条信息
                    strSelect = "top 1 ";
                else
                    strSelect = " top " + Num;
                strSelect += " ID,Title,AddDate,Detail,Picture ";
                //查询条件 
                StringBuilder strWhere = new StringBuilder();
                strWhere.Append("where Verify=1 ");
                if (TypeID > 0)
                {
                    strWhere.Append("and W_ExpoNews.TypeID = ");
                    strWhere.Append(TypeID);
                }
                if (NewsAttribute == 1)  //推荐
                    strWhere.Append("and W_ExpoNews.Recommend =='true' ");
                else if (NewsAttribute == 2) //头条
                    strWhere.Append("and W_ExpoNews.BigNews =='true' ");
                // 要查询表、视图
                string strTableName = "W_ExpoNews";
                // 排序方式
                string strOrderBy = "";
                switch (OrderBy)
                {
                    case "1":
                        strOrderBy += " order by AddDate";
                        break;
                    case "2":
                        strOrderBy += " order by AddDate ";
                        break;
                    default:
                        strOrderBy += " order by AddDate desc";
                        break;
                }
                // 返回查询结果
                DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
                StringBuilder strBuilder = new StringBuilder();
                if (Lists.Rows.Count > 0)
                {
                    strBuilder.Append("<table><tr><td>");
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        if (i > Num - 1) break; //如果超过显示的条数则跳出。
                        if (WitchType != 0 && WitchType != 1) WitchType = 0;
                        switch (WitchType)
                        {
                            case 0: //上下结构
                                strBuilder.Append(@"<table><tr><td>");
                                strBuilder.Append(@"<a href='{PB_WebURL}Expo/Newsdetail-");
                                strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                                strBuilder.Append(BasePage.Config.Rewrite);
                                strBuilder.Append(@" ' Target='");
                                strBuilder.Append(Target);
                                strBuilder.Append(@" '>");
                                strBuilder.Append("<img width='");
                                strBuilder.Append(PicWidth);
                                strBuilder.Append(@"' height='");
                                strBuilder.Append(PicHight);
                                strBuilder.Append(@"'src='");
                                strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                                strBuilder.Append(@"'></a>");
                                if (DisplayTitle == 1) //是否显示标题
                                {
                                    strBuilder.Append(@"</td></tr><tr><td>");
                                    strBuilder.Append(@"<a href='{PB_WebURL}Expo/Newsdetail-");
                                    strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                                    strBuilder.Append(BasePage.Config.Rewrite);
                                    strBuilder.Append(@" ' Target='");
                                    strBuilder.Append(Target);
                                    strBuilder.Append(@" '>");
                                    if (TitleSize > 0)
                                        if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                                            strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                                        else
                                            strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                                    else
                                        strBuilder.Append(Lists.Rows[i]["title"].ToString());
                                    strBuilder.Append(@"</a>");
                                }
                                strBuilder.Append(@"</td></tr></table>");
                                break;
                            case 1: //左右结构
                                strBuilder.Append(@"<table><tr><td >");
                                strBuilder.Append(@"<a href='{PB_WebURL}Expo/Newsdetail-");
                                strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                                strBuilder.Append(BasePage.Config.Rewrite);
                                strBuilder.Append(@" ' Target='");
                                strBuilder.Append(Target);
                                strBuilder.Append(@" '>");
                                strBuilder.Append("<img width='");
                                strBuilder.Append(PicWidth);
                                strBuilder.Append(@"' height='");
                                strBuilder.Append(PicHight);
                                strBuilder.Append(@"'src='");
                                strBuilder.Append(Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                                strBuilder.Append(@"'></a></td><td valign='top'>");
                                strBuilder.Append(@"<a href='{PB_WebURL}Expo/detail-");
                                strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                                strBuilder.Append(BasePage.Config.Rewrite);
                                strBuilder.Append(@" ' Target='");
                                strBuilder.Append(Target);
                                strBuilder.Append(@" '>");
                                if (TitleSize > 0) //设置标题字数
                                    if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                                        strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                                    else
                                        strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                                else
                                    strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                                strBuilder.Append(@"</a>");
                                strBuilder.Append(@"</br>");
                                strBuilder.Append(Lists.Rows[i]["Detail"].ToString());
                                strBuilder.Append(@"</td></tr></table>");
                                break;
                        }
                        if (((i + 1) % RowsNum) == 0)  //换行
                            if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                                strBuilder.Append(@"</td></tr></table> ");
                            else
                                strBuilder.Append(@"</td></tr><tr><td>");
                        else
                            strBuilder.Append(@"</td><td>");
                    }
                }
                return strBuilder.ToString();
            }
            catch (Exception e)
            {
                switch (e.Message)
                {
                    case "0":
                        return Function.ErrInfo(0);
                        break;
                    default:
                        return e.Message;
                        break;
                }
            }
        }

        /// <summary>
        /// 展会资讯文字列表
        /// </summary>
        /// <param name="Array">
        /// TypeID;	        资讯类别
        /// Num:            显示条数
        /// RowsNum	        每行显示几条
        /// DisplayType	    是否显示资讯类别
        /// TitleSize	    标题字数
        /// TitleClass	    标题样式
        /// target	        打开目标
        /// DisplayTime	    是否显示发布时间
        /// DateFormat	    时间格式
        /// NewsAttribute	资讯属性[0:全部,1:推荐，2;头条]
        /// DisplayDetail	是否显示内容 （选择了固定后选择） [0:不显示,1:显示]
        /// DetailSize	    内容字数（选择了显示内容后显示）
        /// OrderBy	        排序方式[0：时间降序，1：时间升序，2：点击率]
        /// </param>
        /// <returns></returns>
        public static string SY_ExpoNews_Str(TSystemLable Array)
        {
            // 分解的参数信息
            string[] strContent;
            strContent = Array.Info.Split(new char[] { '|' });
            try
            {
                //初始化参数,如果参数不够则跳出
                if (strContent.Length != 13) throw new Exception("0");
                int TypeID = Convert.ToInt32(strContent[0].ToString());
                int Num = Convert.ToInt32(strContent[1].ToString());
                int RowsNum = Convert.ToInt32(strContent[2].ToString());
                string DisplayType = strContent[3].ToString();
                int TitleSize = Convert.ToInt32(strContent[4].ToString());
                string TitleClass = strContent[5].ToString();
                string Target = strContent[6].ToString();
                string DisplayTime = strContent[7].ToString();
                string DateFormat = strContent[8].ToString();
                int NewsAttribute = int.Parse(strContent[9].ToString());
                int DisplayDetail = int.Parse(strContent[10].ToString());
                int DetailSize = Convert.ToInt32(strContent[11].ToString());
                string OrderBy = strContent[12].ToString();

                //查询内容
                string strSelect;
                if (Num <= 0)   //读取几条信息
                    strSelect = "top 1 ";
                else
                    strSelect = " top " + Num;
                strSelect += " W_ExpoNews.ID,W_ExpoNews.Title,W_ExpoNews.AddDate,W_ExpoNews.Detail,W_ExpoNews.TypeID,W_ExpoNewsType.Type ";
                //查询条件 
                StringBuilder strWhere = new StringBuilder();
                strWhere.Append("where Verify=1 and  W_ExpoNews.TypeID=W_ExpoNewsType.ID ");
                if (TypeID > 0)
                {
                    strWhere.Append("and W_ExpoNewso.TypeID = ");
                    strWhere.Append(TypeID);
                }
                if (NewsAttribute == 1)
                    strWhere.Append("and W_ExpoNews.Recommend =='true' ");
                else if (NewsAttribute == 2)
                    strWhere.Append("and W_ExpoNews.BigNews =='true' ");
                // 要查询表、视图
                string strTableName = "W_ExpoNews,W_ExpoNewsType";
                // 排序方式
                string strOrderBy = "";
                switch (OrderBy)
                {
                    case "1":
                        strOrderBy += " order by AddDate desc";
                        break;
                    case "2":
                        strOrderBy += " order by AddDate ";
                        break;
                    default:
                        strOrderBy += " order by AddDate desc";
                        break;
                }
                // 返回查询结果
                DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrderBy);
                //输出结果
                StringBuilder strBuilder = new StringBuilder();
                if (Lists.Rows.Count > 0)
                {
                    strBuilder.Append("<table width='100%'><tr><td>");
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        if (i > Num - 1) break; //如果超过显示的条数则跳出。

                        if (DisplayType == "1") //显示类别
                        {
                            strBuilder.Append("[<a href='{PB_WebURL}Expo/NewsTrade-");
                            strBuilder.Append(Lists.Rows[i]["TypeID"].ToString());
                            strBuilder.Append(BasePage.Config.Rewrite);
                            strBuilder.Append(@"'>");
                            strBuilder.Append(Lists.Rows[i]["Type"].ToString().Trim());
                            strBuilder.Append(@"</a>]");
                        }
                        strBuilder.Append("<a href='{PB_WebURL}Expo/NewsDetail-");
                        strBuilder.Append(Lists.Rows[i]["ID"].ToString());
                        strBuilder.Append(BasePage.Config.Rewrite);
                        strBuilder.Append(@"'>");
                        if (TitleSize > 0) //设置标题字数
                            if (Lists.Rows[i]["Title"].ToString().Length > TitleSize)
                                strBuilder.Append(Lists.Rows[i]["Title"].ToString().Substring(0, TitleSize));
                            else
                                strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                        else
                            strBuilder.Append(Lists.Rows[i]["Title"].ToString());
                        strBuilder.Append(@"</a>");
                        if (DisplayTime == "1")
                        {
                            strBuilder.Append(@"</td><td>");
                            strBuilder.Append(Common.DateTransform(Lists.Rows[i]["AddDate"].ToString(), DateFormat));
                        }
                        if (NewsAttribute == 2)  //显示内容
                        {
                            if (DisplayDetail == 1)
                                strBuilder.Append(@"</br>");
                            if (DetailSize > 0) //设置内容字数
                                if (Lists.Rows[i]["Title"].ToString().Length > DetailSize)
                                    strBuilder.Append(Lists.Rows[i]["Detail"].ToString().Substring(0, DetailSize));
                                else
                                    strBuilder.Append(Lists.Rows[i]["Datail"].ToString());
                            else
                                strBuilder.Append(Lists.Rows[i]["Detail"].ToString());
                        }
                        if (((i + 1) % RowsNum) == 0)  //换行
                            if (i == (Num - 1) || i == Lists.Rows.Count - 1)
                                strBuilder.Append(@"</td></tr></table> ");
                            else
                                strBuilder.Append(@"</td></tr><tr><td>");
                        else
                            strBuilder.Append(@"</td><td>");
                    }
                }
                return strBuilder.ToString();
            }
            catch (Exception e)
            {
                switch (e.Message)
                {
                    case "0":
                        return Function.ErrInfo(0);
                        break;
                    default:
                        return e.Message;
                        break;
                }
            }
        }

        /// <summary>
        ///  展会列表（仅限在展会分类页中使用）
        /// </summary>
        /// <param name="Array"></param>
        /// <returns></returns>
        public static string DIY_ExpoTradelist(TSystemLable Array, string strModule)
        {
            try
            {
                // 对标签使用条件进行检查
                if (strModule == "" || strModule != "Expo_Trade") throw new Exception(Function.ErrInfo(2));
                int TypeID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
                if (TypeID <= 0) throw new Exception("该页面不存在"); ;

                // 定义全局变量，最后返回
                StringBuilder ReBulider = new StringBuilder();

                // 求购列表头部
                string strHead = "";
                strHead = Array.Head;
                ReBulider.Append(strHead);


                // 取得用户设置的参数
                // string[] strContent;
                // strContent = Array.Info.Split(new char[] { '|' });
                // 获取展会信息
                string strSelect = " * ";
                string strWhere = " Verify=1 AND TypeID =" + TypeID;
                string strTable = "W_Expo";
                int OrderType = 1;
                string OrderField = "AddDate";
                int PageSize = 10;
                int PageIndex = 1;
                int Count = 0;
                if (HttpContext.Current.Request.QueryString["Page"] != null && HttpContext.Current.Request.QueryString["Page"] != "")
                {
                    if (Base.Common.CheckNum(HttpContext.Current.Request.QueryString["Page"]))
                    {
                        PageIndex = Convert.ToInt32(HttpContext.Current.Request.QueryString["Page"]);
                    }
                }
                DataTable Lists = Pagination.GetDataTable(strWhere, strTable, OrderType, OrderField, strSelect, PageSize, PageIndex, Count);
                if (Lists.Rows.Count < 0)
                {
                    ReBulider.Append("暂无此类产品");
                }
                else
                {
                    string strInfo = Array.Content.ToString();
                    string[] strAtttibute = Function.GetAttribute(strInfo);
                    for (int i = 0; i < Lists.Rows.Count; i++)
                    {
                        strInfo = Array.Content.ToString();
                        for (int j = 0; j < strAtttibute.Length; j++)
                        {
                            switch (strAtttibute[j].ToString())
                            {
                                case "{PR:WS_exTitle}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Title"].ToString());
                                    break;
                                case "{PR:WS_exCompanyName}":
                                    string CompanyName = GetUserCompanyName(Lists.Rows[i]["UserID"].ToString());
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), CompanyName);
                                    break;
                                case "{PR:WS_exID}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["ID"].ToString());
                                    break;
                                case "{PR:WS_exSrc}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), "../expo/Detail-" + Lists.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite);
                                    break;
                                case "{PR:WS_exPicture}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Function.ProcessImageUrl(Lists.Rows[i]["Picture"].ToString()));
                                    break;
                                case "{PR:WS_exStartDate}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), DateTime.Parse(Lists.Rows[i]["StartDate"].ToString()).ToShortDateString());
                                    break;
                                case "{PR:WS_exPlace}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Place"].ToString());
                                    break;
                                case "{PR:WS_exAddDate}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["AddDate"].ToString());
                                    break;
                                case "{PR:WS_exDetail}":
                                    strInfo = strInfo.Replace(strAtttibute[j].ToString(), Lists.Rows[i]["Summary"].ToString());
                                    break;
                            }
                        }
                        //if (i > Num - 1) break; //如果超过显示的条数则跳出。
                        ReBulider.Append(strInfo);
                    }
                    string strUrl = "{PB_WebURL}Expo/Trade";
                    if (PageIndex <= 0) PageIndex = 1;
                    if (TypeID != 0)
                    {
                        strUrl += "-" + TypeID;
                    }
                    strUrl += "-p";
                    string strPagion = Pagination.GoToPager(PageIndex, PageSize, strUrl, strWhere.ToString(), strTable);
                    ReBulider.Append(strPagion);
                }
                return ReBulider.ToString();
            }
            catch (Exception e)
            {
                return e.Message;
            }
        }

        private static string GetUserCompanyName(string UserID)
        {
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqldata"].ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT [CompanyName] FROM [U_UserInfo] WHERE UserID=@UserID", con);
            cmd.Parameters.AddWithValue("@UserID", UserID);
            con.Open();
            SqlDataReader sr = cmd.ExecuteReader();
            if (sr.Read())
            {
                return sr["CompanyName"].ToString();
            }
            con.Close();
            return "";
        }

        /// <summary>
        /// 处理展会分类页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_ExpoTrade(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            Expo.TExpoType Items = new Expo.RExpoType().GateItem(ID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type.ToString());
                            break;
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type.ToString());
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type);
                            break;
                        default:

                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message.ToString();
            }
            return Restr;
        }

        /// <summary>
        /// 处理展会分类页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_ExpoDetail(string Restr, string str)
        {
            // 分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            if (ID <= 0) throw new Exception(Function.ErrInfo(1));
            TExpo te = GetExpoTypeID(ID);
            Expo.TExpoType Items = new Expo.RExpoType().GateItem(te.TypeID);
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_TITLE}":
                            Restr = Restr.Replace(strArray[i].ToString(), te.Title);
                            break;
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), Items.Type.ToString());
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), te.Title);
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                // Restr = e.Message.ToString();
                return Restr;
            }
            return Restr;
        }

        private static TExpo GetExpoTypeID(int ExpoID)
        {
            TExpo t = new TExpo();
            SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["sqldata"].ConnectionString);
            SqlCommand cmd = new SqlCommand("SELECT * FROM [W_Expo] WHERE [ID]=@ID", con);
            cmd.Parameters.AddWithValue("@ID", ExpoID);
            con.Open();
            SqlDataReader sr = cmd.ExecuteReader();
            if (sr.Read())
            {
                t.TypeID = int.Parse(sr["TypeID"].ToString());
                t.Title = sr["Title"].ToString();
            }
            con.Close();
            return t;
        }

        /// <summary>
        /// 处理展会分类页的私有变量
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static string PR_ExpoIndex(string Restr, string str)
        {
            Restr = Restr.Replace("{PR_KEYWORD}", "展会信息");
            return Restr;
        }

        /// <summary>
        /// 展会详细页
        /// </summary>
        /// <returns></returns>
        public static string DIY_ExpoInfo(TSystemLable Array)
        {
            string strInfo = Array.Content;
            int ID = 0;
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
            Expo.TExpo Items = new Expo.RExpo().GateItem(ID);
            StringBuilder strBuilder = new StringBuilder();
            //string[] strAtttibute = Function.GetAttribute(strInfo);
            if (strInfo.Contains("{PR:WS_StartDate}"))
            {
                strInfo = strInfo.Replace("{PR:WS_StartDate}", Items.StartDate.ToString());
            }
            if (strInfo.Contains("{PR:WS_Title}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Title}", Items.Title);
            }
            if (strInfo.Contains("{PR:WS_EndDate}"))
            {
                strInfo = strInfo.Replace("{PR:WS_EndDate}", Items.EndDate.ToString());
            }
            if (strInfo.Contains("{PR:WS_Place}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Place}", Items.Place.ToString());
            }
            if (strInfo.Contains("{PR:WS_AddDate}"))
            {
                strInfo = strInfo.Replace("{PR:WS_AddDate}", Items.AddDate.ToString());
            }
            if (strInfo.Contains("{PR:WS_Authorize}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Authorize}", Items.Authorize.ToString());
            }
            if (strInfo.Contains("{PR:WS_FrontFor}"))
            {
                strInfo = strInfo.Replace("{PR:WS_FrontFor}", Items.FrontFor.ToString());
            }
            if (strInfo.Contains("{PR:WS_Undertake}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Undertake}", Items.Undertake.ToString());
            }
            if (strInfo.Contains("{PR:WS_Aidance}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Aidance}", Items.Aidance.ToString());
            }
            if (strInfo.Contains("{PR:WS_Summary}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Summary}", Items.Summary.ToString());
            }
            if (strInfo.Contains("{PR:WS_Range}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Range}", Items.Range.ToString());
            }
            if (strInfo.Contains("{PR:WS_Period}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Period}", Items.Period.ToString());
            }
            if (strInfo.Contains("{PR:WS_ShowArea}"))
            {
                strInfo = strInfo.Replace("{PR:WS_ShowArea}", Items.ShowArea.ToString());
            }
            if (strInfo.Contains("{PR:WS_Businessmen}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Businessmen}", Items.Businessmen.ToString());
            }
            if (strInfo.Contains("{PR:WS_Spectator}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Spectator}", Items.Spectator.ToString());
            }
            if (strInfo.Contains("{PR:WS_Price}"))
            {
                strInfo = strInfo.Replace("{PR:WS_Price}", Items.Price.ToString());
            }
            if (strInfo.Contains("{PR:WS_MinNum}"))
            {
                strInfo = strInfo.Replace("{PR:WS_MinNum}", Items.MinNum.ToString());
            }

            return strInfo;
        }

    }
}