﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using nspLable.Function;
using System.Text;
using Base;

/// <summary>
/// HelpLabel 的摘要说明
/// </summary>
public class HelpLabel
{
    public static string PR_HelpTrade(string Restr, string str)
    {
        // 分解传递过来的数据，取得模板内所有的私有标签
        string[] strArray;
        strArray = str.Split('|');
        try
        {
            for (int i = 0; i < strArray.Length; i++)
            {
                switch (strArray[i].ToString().ToUpper())
                {
                    case "{PR_HELP}":
                        Restr = Restr.Replace(strArray[i].ToString(), PR_Help());
                        break;
                    case "{PR_HELPLIST}":
                        Restr = Restr.Replace(strArray[i].ToString(), PR_List());
                        break;
                    case "{PR_SEARCH}":
                        Restr = Restr.Replace(strArray[i].ToString(), GetSearchTemp());
                        break;
                }
            }
        }
        catch (Exception e)
        {
            Restr = e.Message.ToString();
        }
        return Restr;
    }

    public static string PR_Help()
    {
        string strSelect = " W_HelpType.* ";
        string strWhere = " WHERE ParentID=0 ";
        //要查询的表
        string strTableName = "W_HelpType";
        //排序方式
        string strOrder = "";
        strOrder += " order by ID asc";
        //返回查询结果
        DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrder);
        StringBuilder strBuilder = new StringBuilder();
        //是否存在类别
        if (Lists.Rows.Count > 0)
        {
            for (int i = 0; i < Lists.Rows.Count; i++)
            {
                DataTable dt = Function.GetDataTable("SELECT * FROM [W_HelpType] WHERE [ParentID]=" + Lists.Rows[i]["ID"].ToString());
                if (dt.Rows.Count > 0)
                {
                    strBuilder.Append("<dl><dt>");
                    strBuilder.Append(Lists.Rows[i]["Name"].ToString());
                    strBuilder.Append("</dt> \n ");
                    for (int j = 0; j < dt.Rows.Count; j++)
                    {
                        strBuilder.Append("<dd><a href=\"{PB_WebUrl}Help/Trade-" + dt.Rows[j]["ID"].ToString() + BasePage.Config.Rewrite + "\" target=\"_parent\">" + dt.Rows[j]["Name"].ToString() + "</a></dd> \n ");
                    }
                    strBuilder.Append("</dl> \n ");
                }
                else
                {
                    strBuilder.Append("<dl><dt> \n ");
                    strBuilder.Append("<a href=\"{PB_WebUrl}Help/Trade-" + Lists.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite + "\">" + Lists.Rows[i]["Name"].ToString() + "</a></dt></dl> \n ");
                }
            }
        }
        else
        {
            strBuilder.Append(@"暂无帮助类别");
        }
        return strBuilder.ToString();
    }

    public static string PR_List()
    {
        string strSelect = " W_HelpCenter.* ";
        string strWhere = "";
        //要查询的表
        string strTableName = "W_HelpCenter";
        //排序方式
        string strOrder = "";
        strOrder += " order by ID asc";
        if (HttpContext.Current.Request.QueryString["ID"] != "" && HttpContext.Current.Request.QueryString["ID"] != null)
        {
            strWhere = " WHERE TypeID=" + HttpContext.Current.Request.QueryString["ID"] + " ";
        }
        else if (HttpContext.Current.Request.Form["keywords"] != null && HttpContext.Current.Request.Form["keywords"] != "")
        {
            strWhere = " WHERE Title like '%" + HttpContext.Current.Request.Form["keywords"] + "%' ";
        }
        else
        {
            strWhere = " WHERE 1=1 ";
        }
        //返回查询结果
        DataTable Lists = Function.GetDataTable(strSelect, strWhere.ToString(), strTableName, strOrder);
        StringBuilder strBuilder = new StringBuilder();
        //是否存在类别
        if (Lists.Rows.Count > 0)
        {
            for (int i = 0; i < Lists.Rows.Count; i++)
            {
                strBuilder.Append("<a href={PB_WebUrl}Help/Detail-" + Lists.Rows[i]["ID"].ToString() + BasePage.Config.Rewrite + ">" + Lists.Rows[i]["Title"].ToString() + "    " + DateTime.Parse(Lists.Rows[i]["AddDate"].ToString()).ToShortDateString() + "</a>  " + " <br/><br/> ");
            }
        }
        else
        {
            strBuilder.Append(@"暂无帮助信息");
        }
        return strBuilder.ToString();
    Err:
        return Function.ErrInfo(0);
    }

    public static string PR_Detail(string Restr, string str)
    {
        if (HttpContext.Current.Request.QueryString["ID"] == "" || HttpContext.Current.Request.QueryString["ID"] == null)
            return Restr;
        if (!Function.CheckQueryStringisInt("ID"))
            return Restr;
        string[] strArray;
        strArray = str.Split('|');
        //返回查询结果
        DataTable Lists = Function.GetDataTable("SELECT * FROM [W_HelpCenter] WHERE ID=" + HttpContext.Current.Request.QueryString["ID"]);
        //是否存在类别
        if (Lists.Rows.Count > 0)
        {
            for (int i = 0; i < strArray.Length; i++)
            {
                switch (strArray[i].ToString().ToUpper())
                {
                    case "{PR_HELP}":
                        Restr = Restr.Replace(strArray[i].ToString(), PR_Help());
                        break;
                    case "{PR_TITLE}":
                        Restr = Restr.Replace(strArray[i].ToString(), Lists.Rows[0]["Title"].ToString());
                        break;
                    case "{PR_HELPDETAIL}":
                        Restr = Restr.Replace(strArray[i].ToString(), Lists.Rows[0]["Info"].ToString());
                        break;
		    case "{PR_SEARCH}":
                        Restr = Restr.Replace(strArray[i].ToString(), GetSearchTemp());
                        break;
                }
            }
        }
        else
            Restr = "不存在帮助信息!";
        return Restr;
    }

    /// <summary>
    ///  获得搜索模板内容
    /// </summary>
    /// <returns></returns>
    private static string GetSearchTemp()
    {
        string strdir = Base.XMLProcess.Read("xml/Label.config", "configuration/label[@type='Search_Help']", "path");
        string Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + "xml/" + strdir;
        string Content = Function.GetFile(Path);
        return Content;
    }
}
