﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using System.Text;
using nspLable.Function;
using UserInfo;
using Base;
using nspJob;
using SqlOperate;

/// <summary>
/// Lavoro 的摘要说明
/// </summary>
public class Lavoro
{
    /// <summary>
    /// 求职列表(xjz)
    /// </summary>
    /// <param name="Array">
    /// ModelType-----(标签模板)----[String为文字,Image为图文]
    /// Num-----------(显示条数)----[int,默认为12条]
    /// DateClass-----(日期格式)----[string]
    /// Attribute-----(文章属性)----[是否推荐,1为推荐,0为全部]
    /// NewsType------(信息类型)----[all为全部,type为类型且要取得子类型,auto为自动绑定]
    /// Sort----------(排序方式)----[以XX-asc或xx-desc格式出现,用空格替换'-']
    /// IsPagination--(是否分页)----[1启用,0不启用]
    /// ThisPage------(当前页样式)--[Class="XXX"]
    /// OtherPage-----(其它页样式)--[Class="XXX"]
    /// </param>
    /// <returns></returns>
    public static string SY_ResumeList(TSystemLable Array)
    {
        #region   |--分解参数--|
        string strHead = "<DIV id='dome' style='overflow:hidden; height:200px; width=600px;'><DIV id='dome1' >";
        string strFloor = "</DIV><DIV id=dome2></DIV></DIV>";
        string[] strContent;
        strContent = Array.Info.Split(new char[] { '|' });
        //初始化参数,如果参数不够则跳出
        if (strContent.Length != 9)
            throw new Exception(Function.ErrInfo(0));

        string ModelType = strContent[0];                     //标签模板
        int Num = 12;                                         //显示条数
        if (GetRequest.isNum(strContent[1]))
            Num = int.Parse(strContent[1]);
        string DateClass = strContent[2];                     //日期格式
        string Attribute = strContent[3];                     //文章属性
        string NewsType = "";                                 //信息类型
        string[] strType = strContent[4].Split(',');
        if (!(strType[0].Equals("type")))
            NewsType = strType[0];
        else
            NewsType = strType[1];
        string Sort = strContent[5];                          //排序方式
        int OrderType = 1;
        if (Sort.Contains("asc"))
            OrderType = 0;
        Sort = Sort.Replace("-asc", "");
        Sort = Sort.Replace("-desc", "");
        int IsPagination = int.Parse(strContent[6]);          //启用分页
        string ThisPage = strContent[7];                      //当前页样式
        string OtherPage = strContent[8];                    //其它页样式
        #endregion

        #region   |--取得数据--|
        StringBuilder strWhere = new StringBuilder();
        strWhere.Append(" [U_Resume].Verify=1 ");
        string strSelect = " [U_Resume].ID,[C_JobType].TypeName,[C_JobType].ID as TypeID,[U_Resume].WantPosition,[U_Resume].Photo,[U_Resume].Sex,[U_Resume].ContactAddress,[U_Resume].AddDate,[U_Resume].txtwork";
        strSelect += ",[U_Resume].HighestEducation,[U_Resume].GraduateSchool,[U_Resume].WantAddress,[U_Resume].WantSalary,[U_Resume].Name";
        string Table = " U_Resume left join C_JobType on(U_Resume.TalentType=C_JobType.id) ";
        int ID = 0; //(分类页表示类别ID,详细页表示资讯ID)
        if (NewsType == "auto")
        {
            if (GetRequest.CheckQueryStringisInt("ID"))
                ID = int.Parse(HttpContext.Current.Request.QueryString["ID"]);
        }
        if (NewsType == "auto" && ID != 0)
            strWhere.Append(" AND [U_Resume].TalentType=" + ID + " ");
        else if (NewsType == "all")
            strWhere.Append("");
        else if (GetRequest.isNum(NewsType))
            strWhere.Append(" AND [U_Resume].TalentType=" + NewsType + " ");
        string[] lisNew = Attribute.Split(new char[] { ',' });
         if (lisNew[1] != "1")
            strWhere.Append(" AND IsEnable=1 ");
         if(Array.Remarks.Equals("人才推荐"))
            strWhere.Append(" AND IsRecommend=1 ");

        Sort = " [U_Resume]." + Sort;
        int Page = 1;
        if (IsPagination == 1)
        {
            if (GetRequest.CheckQueryStringisInt("Page"))
                Page = int.Parse(HttpContext.Current.Request.QueryString["Page"]);
        }
        if (NewsType == "auto")
        {
            String Title = "";
            if (HttpContext.Current.Request["Title"] != null && HttpContext.Current.Request["Title"] != "")
            {
                Title = HttpContext.Current.Request["Title"];
                strWhere.Append(" AND [U_Resume].WantPosition LIKE'%" + Title + "%' ");
            }
            String DateLine = "";
            if (HttpContext.Current.Request["Dateline"] != null && HttpContext.Current.Request["Dateline"] != "")
            {
                DateLine = HttpContext.Current.Request["Dateline"]; //默认全部日期
                if (DateLine.Equals("0"))
                {
                    strWhere.Append(" AND DATEDIFF(day,[U_Resume].AddDate ,getdate())>=0");
                }
                else
                {
                    strWhere.Append(" AND DATEDIFF(day,[U_Resume].AddDate ,getdate())<=" + DateLine);
                }
               
            }
        } 
        #endregion

        #region  |--处理数据--|
        DataTable NewsList = Pagination.GetDataTable(strWhere.ToString(), Table, OrderType, Sort, strSelect, Num, Page, 0);
        // 定义全局变量，最后返回
        StringBuilder ReBulider = new StringBuilder();
        string[,] strAtttibute = Function.GetAttribute(Array.Content, 14);   // 查询属性
        if (NewsList.Rows.Count <= 0)
            ReBulider.Append("暂无求职信息.");
        else
        {
            ReBulider.Append(Array.Head);
            if (Array.Remarks.Equals("人才推荐"))
            {
                if (NewsList.Rows.Count > 2)
                {
                    ReBulider.Append(strHead);
                }
            }
            for (int i = 0; i < NewsList.Rows.Count; i++)
            {
                string Temp = Array.Content;
                for (int j = 0; j < strAtttibute.Length / 2; j++)
                {
                    if (strAtttibute[j, 0] == null)
                        break;
                    int k = int.Parse(strAtttibute[j, 0]);
                    string Name = strAtttibute[j, 1];
                    string Value = "";
                    if (NewsList.Rows[i][Name] != null)
                        Value = NewsList.Rows[i][Name].ToString();
                    if (Value != "")
                    {
                        if (Name.Equals("Photo"))
                            Value = Function.ProcessImageUrl(Value);
                        else if (Name.Equals("AddDate"))
                            Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                    }
                    else
                    {
                        if (Name.Equals("Photo"))
                        {
                            Value = Function.ProcessImageUrl(Value);
                        }
                    }
                    if (k != 0 && Value != "")
                        Temp = Temp.Replace("{PR:WS_" + Name + "(" + k + ")}", Function.GetString(Value, k));
                    else
                        Temp = Temp.Replace("{PR:WS_" + Name + "}", Value);

                }
                ReBulider.Append(Temp);
            }
            if (Array.Remarks.Equals("人才推荐"))
            {
                if (NewsList.Rows.Count > 2)
                {
                    ReBulider.Append(strFloor);
                }
            }
            ReBulider.Append(Array.Footer);
        }
        string strUrl = "{PB_WebURL}Job/ResumeTrade";
        if (Page <= 0) Page = 1;
        if (NewsType == "all" || NewsType == "auto")
            if (ID != 0)
                strUrl += "-" + ID;
        strUrl += "-p";
        string Pages = "";
        if (IsPagination == 1)
        {
            if (ThisPage.Equals("") || OtherPage.Equals(""))
                Pages = Pagination.GoToPager(Page, Num, strUrl, strWhere.ToString(), Table);
            else
                Pages = Pagination.GoToPager(Page, Num, strUrl, strWhere.ToString(), Table, ThisPage, OtherPage);
            ReBulider.Append(Pages);
        }
        #endregion

        return ReBulider.ToString();
    }

    /// <summary>
    /// 招聘列表(xjz)
    /// </summary>
    /// <param name="Array">
    /// ModelType-----(标签模板)----[String为文字,Image为图文]
    /// Num-----------(显示条数)----[int,默认为12条]
    /// DateClass-----(日期格式)----[string]
    /// Attribute-----(文章属性)----[是否推荐,1为推荐,0为全部]
    /// NewsType------(信息类型)----[all为全部,type为类型且要取得子类型,auto为自动绑定]
    /// Sort----------(排序方式)----[以XX-asc或xx-desc格式出现,用空格替换'-']
    /// IsPagination--(是否分页)----[1启用,0不启用]
    /// ThisPage------(当前页样式)--[Class="XXX"]
    /// OtherPage-----(其它页样式)--[Class="XXX"]
    /// </param>
    /// <returns></returns>
    public static string SY_JobList(TSystemLable Array)
    {
        #region   |--分解参数--|
        string[] strContent;
        strContent = Array.Info.Split(new char[] { '|' });
        //初始化参数,如果参数不够则跳出
        if (strContent.Length != 9)
            throw new Exception(Function.ErrInfo(0));

        string ModelType = strContent[0];                     //标签模板
        int Num = 12;                                         //显示条数
        if (GetRequest.isNum(strContent[1]))
            Num = int.Parse(strContent[1]);
        string DateClass = strContent[2];                     //日期格式
        string Attribute = strContent[3];                     //文章属性
        string NewsType = "";                                 //信息类型
        string[] strType = strContent[4].Split(',');
        if (!(strType[0].Equals("type")))
            NewsType = strType[0];
        else
            NewsType = strType[1];
        string Sort = strContent[5];                          //排序方式
        int OrderType = 1;
        if (Sort.Contains("asc"))
            OrderType = 0;
        Sort = Sort.Replace("-asc", "");
        Sort = Sort.Replace("-desc", "");
        int IsPagination = int.Parse(strContent[6]);          //启用分页
        string ThisPage = strContent[7];                      //当前页样式
        string OtherPage = strContent[8];                    //其它页样式
        #endregion

        #region   |--取得数据--|
        StringBuilder strWhere = new StringBuilder();
        strWhere.Append(" [C_Job].TypeID=[C_JobType].ID AND [C_Job].Verify=1 AND [C_Job].UserID=[U_UserInfo].UserID");
        string strSelect = " [U_UserInfo].LoginName,[U_UserInfo].CompanyName,[U_UserInfo].Summary,[C_Job].TypeID,[C_Job].ID,[C_JobType].TypeName,[C_Job].Position,[C_Job].Count,[C_Job].Degree";
        strSelect += ",[C_Job].SalaryLevel,[C_Job].Sex,[C_Job].AddDate,[C_Job].EndDate,[C_Job].Experience,[C_Job].WorkTemper,[C_Job].Address";
        string Table = " [C_Job],[C_JobType],[U_UserInfo] ";
        int ID = 0; //(分类页表示类别ID,详细页表示招聘ID)
        if (NewsType == "auto" || NewsType == "other")
        {
            if (GetRequest.CheckQueryStringisInt("ID"))
                ID = int.Parse(HttpContext.Current.Request.QueryString["ID"]);
        }
        if (NewsType == "auto" && ID != 0)
            strWhere.Append(" AND [C_Job].TypeID=" + ID + " ");
        else if (NewsType == "all")
            strWhere.Append("");
        else if (NewsType == "other" && ID != 0)
            strWhere.Append(" AND [C_Job].UserID=" + "(SELECT UserID FROM [C_Job] WHERE ID=" + ID + ") AND [C_Job].ID!=" + ID);
        else if (GetRequest.isNum(NewsType))
            strWhere.Append(" AND [C_Job].TypeID=" + NewsType + " ");
        if (Array.Remarks.Equals("推荐企业"))
            strWhere.Append(" AND IsRecommend=1 ");
	if (Array.Remarks.Equals("推荐招聘信息"))
            strWhere.Append(" AND IsRecommend=1 ");
        Sort = " [C_Job]." + Sort;
        int Page = 1;
        if (IsPagination == 1)
        {
            if (GetRequest.CheckQueryStringisInt("Page"))
                Page = int.Parse(HttpContext.Current.Request.QueryString["Page"]);
        }
        if (NewsType == "auto")
        {
            String Title = "";
            if (HttpContext.Current.Request["Title"] != null && HttpContext.Current.Request["Title"] != "")
            {
                Title = HttpContext.Current.Request["Title"];
                strWhere.Append(" AND [C_Job].Position LIKE'%" + Title + "%' ");
            }
            String DateLine = "";
            if (HttpContext.Current.Request["Dateline"] != null && HttpContext.Current.Request["Dateline"] != "")
            {
                DateLine = HttpContext.Current.Request["Dateline"]; //默认全部日期
                if (DateLine.Equals("0"))
                {
                    strWhere.Append(" AND DATEDIFF(day,[C_Job].AddDate ,getdate())>=0");
                }
                else
                {
                    strWhere.Append(" AND DATEDIFF(day,[C_Job].AddDate ,getdate())<=" + DateLine);
                }
              }
        }
        #endregion

        #region  |--处理数据--|
        DataTable NewsList = Pagination.GetDataTable(strWhere.ToString(), Table, OrderType, Sort, strSelect, Num, Page, 0);
        // 定义全局变量，最后返回
        StringBuilder ReBulider = new StringBuilder();
        string[,] strAtttibute = Function.GetAttribute(Array.Content, 15);   // 查询属性
        if (NewsList.Rows.Count <= 0)
            ReBulider.Append("暂无招聘信息.");
        else
        {
            ReBulider.Append(Array.Head);
            for (int i = 0; i < NewsList.Rows.Count; i++)
            {
                string Temp = Array.Content;
                for (int j = 0; j < strAtttibute.Length / 2; j++)
                {
                    if (strAtttibute[j, 0] == null)
                        break;
                    int k = int.Parse(strAtttibute[j, 0]);
                    string Name = strAtttibute[j, 1];
                    string Value = "";
                    if (NewsList.Rows[i][Name] != null)
                        Value = NewsList.Rows[i][Name].ToString();
                    if (Value != "")
                    {
                        if (Name.Equals("AddDate"))
                            Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                        else if (Name.Equals("EndDate"))
                            Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                    }
                    if (k != 0 && Value != "")
                        Temp = Temp.Replace("{PR:WS_" + Name + "(" + k + ")}", Function.GetString(Value, k));
                    else
                        Temp = Temp.Replace("{PR:WS_" + Name + "}", Value);

                }
                ReBulider.Append(Temp);
            }
            ReBulider.Append(Array.Footer);
        }
        string strUrl = "{PB_WebURL}Job/JobTrade";
        if (Page <= 0) Page = 1;
        if (NewsType == "all" || NewsType == "auto")
            if (ID != 0)
                strUrl += "-" + ID;
        strUrl += "-p";
        string Pages = "";
        if (IsPagination == 1)
        {
            if (ThisPage.Equals("") || OtherPage.Equals(""))
                Pages = Pagination.GoToPager(Page, Num, strUrl, strWhere.ToString(), Table);
            else
                Pages = Pagination.GoToPager(Page, Num, strUrl, strWhere.ToString(), Table, ThisPage, OtherPage);
            ReBulider.Append(Pages);
        }
        #endregion

        return ReBulider.ToString();
    }

    /// <summary>
    /// 简历详细内容标签
    /// </summary>
    /// <param name="Array"></param>
    /// <returns></returns>
    public static string SY_ResumeInfo(TSystemLable Array)
    {
        #region   |--分解参数--|
        string DateClass = Array.Info;
        string strPage = "";
        int ID = 0;
        if (GetRequest.CheckQueryStringisInt("ID"))                  //取得简历ID
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
        if (ID <= 0)
            return "该求职信息不存在!";
        strPage = HttpContext.Current.Request.QueryString["page"];  //获取分页值
        if (strPage == null) strPage = "1";
        #endregion

        #region   |--取得数据--|
        StringBuilder strSQL = new StringBuilder();
        strSQL.Append("SELECT [U_Resume].*,[C_JobType].TypeName FROM [U_Resume],[C_JobType] ");
        strSQL.Append("WHERE  [U_Resume].ID=" + ID);
        DataTable ResumeInfo = Function.GetDataTable(strSQL.ToString());
        #endregion

        #region   |--处理数据--|
        StringBuilder strBuilde = new StringBuilder();
        if (ResumeInfo.Rows.Count <= 0)
            return "不存在该简历!";
        StringBuilder strReturn = new StringBuilder();
        string[,] strAtttibute = Function.GetAttribute(Array.Content, 25);   // 查询属性
        System.Collections.Hashtable HashInfo = Function.SeparatePages(ResumeInfo.Rows[0]["PersResume"].ToString(), strPage, "detail-" + ID);
        strBuilde.Append(HashInfo["content"].ToString());
        strBuilde.Append(@"</p><p class=""info_page"">");
        strBuilde.Append(HashInfo["pagetxt"].ToString());
        strBuilde.Append(@"");
        if (strAtttibute.Length != 0)
        {
            string Temp = Array.Content;
            for (int j = 0; j < strAtttibute.Length / 2; j++)
            {
                if (strAtttibute[j, 0] == null)
                    break;
                int k = int.Parse(strAtttibute[j, 0]);
                string Name = strAtttibute[j, 1];
                string Value = "";
                if (ResumeInfo.Rows[0][Name] != null)
                    Value = ResumeInfo.Rows[0][Name].ToString();
                if (Value != "")
                {
                    if (Name.Equals("Photo"))
                        Value = Function.ProcessImageUrl(Value);
                    else if (Name.Equals("AddDate"))
                        Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                    else if (Name.Equals("PersResume"))
                        Value = strBuilde.ToString();
                    else if (Name.Equals("DateofBirth"))
                    {
                        Value = ((DateTime.Now.Year) - (DateTime.Parse(Value).Year)) + "";
                    }
                    else if (Name.Equals("IsEnable"))
                    {
                        if (Value.Equals("False"))
                            Value = "暂不求职";
                        else
                            Value = "正在求职";
                    }
                }
                else
                {
                    if (Name.Equals("Photo"))
                    {
                        Value = Function.ProcessImageUrl(Value);
                    }
                }
             
                if (k != 0 && Value != "")
                    Temp = Temp.Replace("{PR:WS_" + Name + "(" + k + ")}", Function.GetString(Value, k));
                else
                    Temp = Temp.Replace("{PR:WS_" + Name + "}", Value);

            }
            strReturn.Append(Temp);
        }
        #endregion

        return strReturn.ToString();
    }

    /// <summary>
    /// 招聘详细内容标签
    /// </summary>
    /// <param name="Array"></param>
    /// <returns></returns>
    public static string SY_JobInfo(TSystemLable Array)
    {
        #region   |--分解参数--|
        string DateClass = Array.Info;
        string strPage = "";
        int ID = 0;
        if (GetRequest.CheckQueryStringisInt("ID"))                  //取得招聘ID
            ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
        if (ID <= 0)
            return "该招聘信息不存在!";
        #endregion

        #region   |--取得数据--|
        StringBuilder strSQL = new StringBuilder();
        strSQL.Append("SELECT [C_Job].*,[C_JobType].TypeName,[U_UserInfo].LoginName,[U_UserInfo].CompanyName FROM [C_Job],[C_JobType],[U_UserInfo] ");
        strSQL.Append("WHERE [U_UserInfo].UserID=[C_Job].UserID AND [C_Job].TypeID=[C_JobType].ID AND [C_Job].ID=" + ID);
        DataTable JobInfo = Function.GetDataTable(strSQL.ToString());
        #endregion

        #region   |--处理数据--|
        if (JobInfo.Rows.Count <= 0)
            return "不存在该招聘信息!";
        StringBuilder strReturn = new StringBuilder();
        string[,] strAtttibute = Function.GetAttribute(Array.Content, 17);   // 查询属性
        if (strAtttibute.Length != 0)
        {
            string Temp = Array.Content;
            for (int j = 0; j < strAtttibute.Length / 2; j++)
            {
                if (strAtttibute[j, 0] == null)
                    break;
                int k = int.Parse(strAtttibute[j, 0]);
                string Name = strAtttibute[j, 1];
                string Value = "";
                if (JobInfo.Rows[0][Name] != null)
                    Value = JobInfo.Rows[0][Name].ToString();
                if (Value != "")
                {
                    if (Name.Equals("AddDate"))
                        Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                    else if (Name.Equals("EndDate"))
                        Value = DateTime.Parse(Value.ToString()).ToString(DateClass);
                }
                if (k != 0 && Value != "")
                    Temp = Temp.Replace("{PR:WS_" + Name + "(" + k + ")}", Function.GetString(Value, k));
                else
                    Temp = Temp.Replace("{PR:WS_" + Name + "}", Value);

            }
            strReturn.Append(Temp);
        }
        #endregion

        return strReturn.ToString();
    }

    /// </summary>
    /// <param name="Array">
    /// 求职招聘类别标签
    /// num	显示条数
    /// </param>
    /// <returns></returns>
    public static string SY_LavoroTypeList(TSystemLable Array)
    {
        #region   |--分解参数--|
        int Num = 12;
        if (GetRequest.isNum(Array.Info))
            Num = Convert.ToInt32(Array.Info);
        #endregion

        #region   |--取得数据--|
        //临时字符串
        string strWhere = " WHERE 1=1 ";
        string strSelect = "";
        //读取几条信息
        if (Num <= 0)
            strSelect = "top 1 ";
        else
            strSelect = " top " + Num + " ID,TypeName ";
        DataTable TypeList = Function.GetDataTable(strSelect, strWhere, "[C_JobType]");
        #endregion

        #region   |--处理数据--|
        StringBuilder strBuilder = new StringBuilder();
        if (TypeList.Rows.Count == 0)                /*若2级分类下无数据,则重新加载一级分类*/
            return "暂无人才分类";
        string[] strAtttibute = Function.GetAttribute(Array.Content);   // 查询属性
        if (TypeList.Rows.Count != 0)
        {
            strBuilder.Append(Array.Head);
            for (int i = 0; i < TypeList.Rows.Count; i++)
            {
                string strContent = Array.Content;
                for (int j = 0; j < strAtttibute.Length; j++)
                {
                    string Label = strAtttibute[j].ToUpper();
                    switch (Label)
                    {
                        case "{PR:WS_TYPENAME}":
                            strContent = strContent.Replace(strAtttibute[j].ToString(), TypeList.Rows[i]["TypeName"].ToString());
                            break;
                        case "{PR:WS_ID}":
                            strContent = strContent.Replace(strAtttibute[j].ToString(), TypeList.Rows[i]["ID"].ToString());
                            break;
                    }
                }
                strBuilder.Append(strContent);
            }
            strBuilder.Append(Array.Footer);
        }
        #endregion

        return strBuilder.ToString();
    }

    /// <summary>
    /// 取得求职招聘类别
    /// </summary>
    /// <param name="intID"></param>
    /// <returns></returns>
    private static string GetTypeStr(string intID)
    {
        string strName = Function.GetOnlyDate("TypeName", " WHERE ID=" + intID, "[C_JobType]");
        return strName; 
    }

    /// <summary>
    /// 转换人才首页的私有变量
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string PR_LavoroIndex(string Restr, string str)
    {
        Restr = Restr.Replace("{PR_KEYWORD}", "人才首页");
        return Restr;
    }

    /// <summary>
    /// 转换招聘分类页的私有变量
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string PR_JobTrade(string Restr, string str)
    {
        int ID = 0;
        ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
        if (ID <= 0)
        {
            Restr = Restr.Replace("{PR_POSITION}", "<a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > 招聘列表");
            Restr = Restr.Replace("{PR_KEYWORD}", "");
        }
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [C_JobType] WHERE ID=" + ID);
        //分解传递过来的数据，取得模板内所有的私有标签
        if (dt.Rows.Count > 0)
        {
            string[] strArray;
            strArray = str.Split('|');
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), " <a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> >" + "<a href=\"{PB_WEBURL}Job/JobTrade-"+ID+BasePage.Config.Rewrite+"\">"+dt.Rows[0]["TypeName"].ToString()+"</a>");
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), dt.Rows[0]["TypeName"].ToString());
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message;
            }
        }
        return Restr;
    }

    /// <summary>
    /// 转换招聘详细页的私有变量
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string PR_JobDetail(string Restr, string str)
    {

        // 分解传递过来的数据，取得模板内所有的私有标签
        string[] strArray;
        strArray = str.Split('|');
        int ID = 0;
        ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
        if (ID <= 0)
        {
            Restr = Restr.Replace("{PR_POSITION}", "<a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > 求职列表");
            Restr = Restr.Replace("{PR_KEYWORD}", "");
        }
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [U_Resume] WHERE ID=" + ID);
        if (dt.Rows.Count > 0)
        {
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), " <a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > " + "<a href=\"{PB_WEBURL}Job/ResumeTrade-" + ID + BasePage.Config.Rewrite + "\">" + dt.Rows[0]["WantPosition"].ToString() + "</a>");
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), dt.Rows[0]["WantPosition"].ToString());
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        return Restr;
    }

    /// <summary>
    /// 转换求职分类页的私有变量
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string PR_ResumeTrade(string Restr, string str)
    {
        int ID = 0;
        ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
        if (ID <= 0)
        {
            Restr = Restr.Replace("{PR_POSITION}", "<a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > 求职列表");
            Restr = Restr.Replace("{PR_KEYWORD}", "");
        }
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [C_JobType] WHERE ID=" + ID);
        if (dt.Rows.Count > 0)
        {
            //分解传递过来的数据，取得模板内所有的私有标签
            string[] strArray;
            strArray = str.Split('|');
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), " <a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > " +"<a href=\"{PB_WEBURL}Job/ResumeTrade-"+ID+BasePage.Config.Rewrite+"\">"+ dt.Rows[0]["TypeName"].ToString()+"</a>");
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), dt.Rows[0]["TypeName"].ToString());
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception e)
            {
                Restr = e.Message;
            }
        }
        return Restr;
    }

    /// <summary>
    /// 转换求职详细页的私有变量
    /// </summary>
    /// <param name="str"></param>
    /// <returns></returns>
    public static string PR_ResumeDetail(string Restr, string str)
    {
        // 分解传递过来的数据，取得模板内所有的私有标签
        string[] strArray;
        strArray = str.Split('|');
        int ID = 0;
        ID = Convert.ToInt32(HttpContext.Current.Request.QueryString["ID"]);
        if (ID <= 0)
        {
            Restr = Restr.Replace("{PR_POSITION}", "<a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > 招聘列表");
            Restr = Restr.Replace("{PR_POSITIONS}", "<a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > 求职列表");
            Restr = Restr.Replace("{PR_KEYWORD}", "");
        }
        else
        {
            Restr = Restr.Replace("{PR_POSITIONS}", "<a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > 求职列表");
            Restr = Restr.Replace("{PR_KEYWORD}", "");
        }
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [U_Resume] WHERE ID=" + ID);
        if (dt.Rows.Count > 0)
        {
            try
            {
                for (int i = 0; i < strArray.Length; i++)
                {
                    switch (strArray[i].ToString().ToUpper())
                    {
                        case "{PR_POSITION}":
                            Restr = Restr.Replace(strArray[i].ToString(), " <a href=\"{PB_WEBurl}\" >首页</a> > <a href=\"{PB_WEBurl}job/job.aspx\">人才</a> > " + "<a href=\"{PB_WEBURL}Job/ResumeTrade-" + dt.Rows[0]["TalentType"].ToString() + BasePage.Config.Rewrite + "\">" + GetTypeStr(dt.Rows[0]["TalentType"].ToString()) + "</a> > " + dt.Rows[0]["WantPosition"].ToString());
                            break;
                        case "{PR_KEYWORD}":
                            Restr = Restr.Replace(strArray[i].ToString(), dt.Rows[0]["WantPosition"].ToString());
                            break;
                        default:
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }
        return Restr;
    }
}
